/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import mmcorej.CMMCore;
import org.micromanager.MMOptions;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class OptionsDlg
extends MMDialog {
    private JTextField startupScriptFile_;
    private static final long serialVersionUID = 1L;
    private JTextField bufSizeField_;
    private MMOptions opts_;
    private CMMCore core_;
    private SpringLayout springLayout;
    private Preferences mainPrefs_;
    private JComboBox comboDisplayBackground_;
    private ScriptInterface parent_;
    private GUIColors guiColors_;
    private String currentCfgPath_;
    private JComboBox windowZoomCombo_;

    public OptionsDlg(MMOptions mMOptions, CMMCore cMMCore, Preferences preferences, ScriptInterface scriptInterface, String string) {
        this.currentCfgPath_ = string;
        this.parent_ = scriptInterface;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OptionsDlg.this.savePosition();
                OptionsDlg.this.parent_.makeActive();
            }
        });
        this.setResizable(false);
        this.setModal(true);
        this.opts_ = mMOptions;
        this.core_ = cMMCore;
        this.mainPrefs_ = preferences;
        this.setTitle("Micro-Manager Options");
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.setBounds(100, 100, 371, 340);
        this.guiColors_ = new GUIColors();
        Dimension dimension = new Dimension(120, 20);
        if (this.opts_.displayBackground_.equals("Day")) {
            this.setBackground(SystemColor.control);
        } else if (this.opts_.displayBackground_.equals("Night")) {
            this.setBackground(Color.gray);
        }
        Preferences preferences2 = Preferences.userNodeForPackage(this.getClass());
        this.setPrefsNode(preferences2.node(preferences2.absolutePath() + "/OptionsDlg"));
        Rectangle rectangle = this.getBounds();
        this.loadPosition(rectangle.x, rectangle.y);
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText("Set extra verbose logging for debugging purposes");
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OptionsDlg)OptionsDlg.this).opts_.debugLogEnabled_ = jCheckBox.isSelected();
                OptionsDlg.this.core_.enableDebugLog(((OptionsDlg)OptionsDlg.this).opts_.debugLogEnabled_);
            }
        });
        jCheckBox.setText("Debug log enabled");
        this.getContentPane().add(jCheckBox);
        this.springLayout.putConstraint("South", (Component)jCheckBox, 30, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jCheckBox, 7, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jCheckBox, 190, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jCheckBox, 10, "West", (Component)this.getContentPane());
        jCheckBox.setSelected(this.opts_.debugLogEnabled_);
        final JCheckBox jCheckBox2 = new JCheckBox();
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OptionsDlg)OptionsDlg.this).opts_.doNotAskForConfigFile_ = jCheckBox2.isSelected();
            }
        });
        jCheckBox2.setText("Do not ask for config file");
        this.getContentPane().add(jCheckBox2);
        this.springLayout.putConstraint("East", (Component)jCheckBox2, 220, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jCheckBox2, 0, "West", (Component)jCheckBox);
        this.springLayout.putConstraint("South", (Component)jCheckBox2, 50, "North", (Component)this.getContentPane());
        jCheckBox2.setSelected(this.opts_.doNotAskForConfigFile_);
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Erases all entries in the current log file (recommended)");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg.this.core_.clearLog();
                OptionsDlg.this.parent_.logStartupProperties();
            }
        });
        jButton.setFont(new Font("", 0, 10));
        jButton.setText("Clear log file");
        jButton.setPreferredSize(dimension);
        this.getContentPane().add(jButton);
        this.springLayout.putConstraint("North", (Component)jButton, 175, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton, 20, "North", (Component)this.getContentPane());
        JButton jButton2 = new JButton();
        jButton2.setToolTipText("Clears all persistent settings and returns to defaults");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl = OptionsDlg.this.mainPrefs_.getBoolean("registered", false);
                    OptionsDlg.this.mainPrefs_.clear();
                    Preferences preferences = OptionsDlg.this.mainPrefs_.node(OptionsDlg.this.mainPrefs_.absolutePath() + "/" + "AcquistionSettings");
                    preferences.clear();
                    OptionsDlg.this.mainPrefs_.putBoolean("registered", bl);
                }
                catch (BackingStoreException backingStoreException) {
                    ReportingUtils.showError(actionEvent);
                }
            }
        });
        jButton2.setText("Clear registry");
        jButton2.setFont(new Font("", 0, 10));
        jButton2.setPreferredSize(dimension);
        this.getContentPane().add(jButton2);
        this.springLayout.putConstraint("East", (Component)jButton2, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton2, 0, "West", (Component)jButton);
        this.springLayout.putConstraint("North", (Component)jButton2, 5, "South", (Component)jButton);
        JButton jButton3 = new JButton();
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((OptionsDlg)OptionsDlg.this).opts_.circularBufferSizeMB_ = NumberUtils.displayStringToInt(OptionsDlg.this.bufSizeField_.getText());
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                    return;
                }
                ((OptionsDlg)OptionsDlg.this).opts_.startupScript_ = OptionsDlg.this.startupScriptFile_.getText();
                OptionsDlg.this.savePosition();
                OptionsDlg.this.parent_.makeActive();
                OptionsDlg.this.dispose();
            }
        });
        jButton3.setText("Close");
        jButton3.setFont(new Font("", 0, 10));
        jButton3.setPreferredSize(dimension);
        this.getContentPane().add(jButton3);
        this.springLayout.putConstraint("North", (Component)jButton3, 12, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton3, 35, "North", (Component)this.getContentPane());
        JLabel jLabel = new JLabel();
        jLabel.setText("Sequence buffer size [MB]");
        this.getContentPane().add(jLabel);
        this.springLayout.putConstraint("East", (Component)jLabel, 180, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel, 15, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jLabel, 84, "North", (Component)this.getContentPane());
        this.bufSizeField_ = new JTextField(Integer.toString(this.opts_.circularBufferSizeMB_));
        this.getContentPane().add(this.bufSizeField_);
        this.springLayout.putConstraint("South", (Component)this.bufSizeField_, 85, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.bufSizeField_, 65, "North", (Component)this.getContentPane());
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Display-Background");
        this.getContentPane().add(jLabel2);
        this.springLayout.putConstraint("East", (Component)jLabel2, 170, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel2, 15, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jLabel2, 108, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel2, 92, "North", (Component)this.getContentPane());
        this.comboDisplayBackground_ = new JComboBox<String>(this.guiColors_.styleOptions);
        this.comboDisplayBackground_.setFont(new Font("Arial", 0, 10));
        this.comboDisplayBackground_.setMaximumRowCount(2);
        this.comboDisplayBackground_.setSelectedItem(this.opts_.displayBackground_);
        this.comboDisplayBackground_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg.this.changeBackground();
            }
        });
        this.getContentPane().add(this.comboDisplayBackground_);
        this.springLayout.putConstraint("East", (Component)this.bufSizeField_, 0, "East", (Component)this.comboDisplayBackground_);
        this.springLayout.putConstraint("West", (Component)this.bufSizeField_, 220, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.comboDisplayBackground_, 331, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.comboDisplayBackground_, 220, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.comboDisplayBackground_, 114, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.comboDisplayBackground_, 91, "North", (Component)this.getContentPane());
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Startup script");
        this.getContentPane().add(jLabel3);
        this.springLayout.putConstraint("East", (Component)jLabel3, 115, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel3, 0, "West", (Component)jLabel2);
        this.springLayout.putConstraint("South", (Component)jLabel3, 135, "North", (Component)this.getContentPane());
        this.startupScriptFile_ = new JTextField(this.opts_.startupScript_);
        this.getContentPane().add(this.startupScriptFile_);
        this.springLayout.putConstraint("East", (Component)jButton3, 0, "East", (Component)this.startupScriptFile_);
        this.springLayout.putConstraint("West", (Component)jButton3, 250, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.startupScriptFile_, 131, "West", (Component)this.comboDisplayBackground_);
        this.springLayout.putConstraint("West", (Component)this.startupScriptFile_, 140, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.startupScriptFile_, 137, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.startupScriptFile_, 5, "South", (Component)this.comboDisplayBackground_);
        final JCheckBox jCheckBox3 = new JCheckBox();
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OptionsDlg)OptionsDlg.this).opts_.autoreloadDevices_ = jCheckBox3.isSelected();
            }
        });
        jCheckBox3.setText("Auto-reload devices (Danger!)");
        this.getContentPane().add(jCheckBox3);
        this.springLayout.putConstraint("North", (Component)jCheckBox3, 0, "North", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jCheckBox3, 5, "East", (Component)jButton);
        jCheckBox3.setSelected(this.opts_.autoreloadDevices_);
        final JCheckBox jCheckBox4 = new JCheckBox();
        jCheckBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OptionsDlg)OptionsDlg.this).opts_.closeOnExit_ = jCheckBox4.isSelected();
                MMStudioMainFrame.getInstance().setExitStrategy(((OptionsDlg)OptionsDlg.this).opts_.closeOnExit_);
            }
        });
        jCheckBox4.setText("Close app when quitting MM");
        this.getContentPane().add(jCheckBox4);
        this.springLayout.putConstraint("North", (Component)jCheckBox4, 20, "North", (Component)jCheckBox3);
        this.springLayout.putConstraint("West", (Component)jCheckBox4, 0, "West", (Component)jCheckBox3);
        jCheckBox4.setSelected(this.opts_.closeOnExit_);
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8%", "12%", "16%", "25%", "33%", "50%", "75%", "100%", "150%", "200%", "300%", "400%", "600%"}));
        double d = this.opts_.windowMag_;
        int n = 0;
        if (d == 0.08333333333333333) {
            n = 0;
        } else if (d == 0.125) {
            n = 1;
        } else if (d == 0.16) {
            n = 2;
        } else if (d == 0.25) {
            n = 3;
        } else if (d == 0.33) {
            n = 4;
        } else if (d == 0.5) {
            n = 5;
        } else if (d == 0.75) {
            n = 6;
        } else if (d == 1.0) {
            n = 7;
        } else if (d == 1.5) {
            n = 8;
        } else if (d == 2.0) {
            n = 9;
        } else if (d == 3.0) {
            n = 10;
        } else if (d == 4.0) {
            n = 11;
        } else if (d == 6.0) {
            n = 12;
        }
        jComboBox.setSelectedIndex(n);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (jComboBox.getSelectedIndex()) {
                    case 0: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.08333333333333333;
                        break;
                    }
                    case 1: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.125;
                        break;
                    }
                    case 2: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.16;
                        break;
                    }
                    case 3: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.25;
                        break;
                    }
                    case 4: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.33;
                        break;
                    }
                    case 5: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.5;
                        break;
                    }
                    case 6: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.75;
                        break;
                    }
                    case 7: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 1.0;
                        break;
                    }
                    case 8: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 1.5;
                        break;
                    }
                    case 9: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 2.0;
                        break;
                    }
                    case 10: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 3.0;
                        break;
                    }
                    case 11: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 4.0;
                        break;
                    }
                    case 12: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 6.0;
                    }
                }
            }
        });
        this.getContentPane().add(jComboBox);
        this.springLayout.putConstraint("North", jComboBox, 30, "North", (Component)jCheckBox4);
        this.springLayout.putConstraint("West", jComboBox, 90, "West", (Component)jCheckBox3);
        JLabel jLabel4 = new JLabel("Preferred image window zoom:");
        this.getContentPane().add(jLabel4);
        this.springLayout.putConstraint("West", (Component)jLabel4, 20, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel4, 5, "North", jComboBox);
        final JCheckBox jCheckBox5 = new JCheckBox();
        jCheckBox5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OptionsDlg)OptionsDlg.this).opts_.mpTiffMetadataFile_ = jCheckBox5.isSelected();
            }
        });
        jCheckBox5.setText("Create metadata txt file with multi-image file saving");
        this.getContentPane().add(jCheckBox5);
        this.springLayout.putConstraint("West", (Component)jCheckBox5, 20, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jCheckBox5, 10, "South", (Component)jLabel4);
        jCheckBox5.setSelected(this.opts_.mpTiffMetadataFile_);
        final JCheckBox jCheckBox6 = new JCheckBox();
        jCheckBox6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OptionsDlg)OptionsDlg.this).opts_.mpTiffSeperateFilesForPositions_ = jCheckBox6.isSelected();
            }
        });
        jCheckBox6.setText("Save XY Positions in seperate Multi-Image Files");
        this.getContentPane().add(jCheckBox6);
        this.springLayout.putConstraint("West", (Component)jCheckBox6, 20, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jCheckBox6, 5, "South", (Component)jCheckBox5);
        jCheckBox6.setSelected(this.opts_.mpTiffSeperateFilesForPositions_);
    }

    private void changeBackground() {
        String string;
        this.opts_.displayBackground_ = string = (String)this.comboDisplayBackground_.getSelectedItem();
        this.setBackground(this.guiColors_.background.get(string));
        if (this.parent_ != null) {
            MMStudioMainFrame.getInstance().setBackgroundStyle(string);
        }
    }
}

