/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

class BooleanLock {
    private boolean value;

    public BooleanLock(boolean bl) {
        this.value = bl;
    }

    public BooleanLock() {
        this(false);
    }

    public synchronized void setValue(boolean bl) {
        if (bl != this.value) {
            this.value = bl;
            this.notifyAll();
        }
    }

    public synchronized boolean waitToSetTrue(long l) throws InterruptedException {
        boolean bl = this.waitUntilFalse(l);
        if (bl) {
            this.setValue(true);
        }
        return bl;
    }

    public synchronized boolean waitToSetFalse(long l) throws InterruptedException {
        boolean bl = this.waitUntilTrue(l);
        if (bl) {
            this.setValue(false);
        }
        return bl;
    }

    public synchronized boolean isTrue() {
        return this.value;
    }

    public synchronized boolean isFalse() {
        return !this.value;
    }

    public synchronized boolean waitUntilTrue(long l) throws InterruptedException {
        return this.waitUntilStateIs(true, l);
    }

    public synchronized boolean waitUntilFalse(long l) throws InterruptedException {
        return this.waitUntilStateIs(false, l);
    }

    public synchronized boolean waitUntilStateIs(boolean bl, long l) throws InterruptedException {
        if (l == 0L) {
            while (this.value != bl) {
                this.wait();
            }
            return true;
        }
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        while (this.value != bl && l3 > 0L) {
            this.wait(l3);
            l3 = l2 - System.currentTimeMillis();
        }
        return this.value == bl;
    }
}

