/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.micromanager.CustomTimeIntervalsPanel;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMDialog;

public class AdvancedOptionsDialog
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private AcquisitionEngine acqEng_;
    private JTabbedPane tabbedPane_;
    private JPanel closeButtonPanel_;
    private CustomTimeIntervalsPanel customTimeIntervalsPanel_;

    public AdvancedOptionsDialog(AcquisitionEngine acquisitionEngine, ScriptInterface scriptInterface) {
        this.setModal(true);
        this.acqEng_ = acquisitionEngine;
        this.loadPosition(0, 0, 600, 500);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AdvancedOptionsDialog.this.savePosition();
            }
        });
        this.setTitle("Advanced acquisition options");
        this.setMinimumSize(new Dimension(600, 400));
        this.tabbedPane_ = new JTabbedPane();
        this.customTimeIntervalsPanel_ = new CustomTimeIntervalsPanel(this.acqEng_, this.tabbedPane_, scriptInterface);
        this.tabbedPane_.add("Custom time intervals", this.customTimeIntervalsPanel_);
        this.getContentPane().add(this.tabbedPane_);
        this.closeButtonPanel_ = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedOptionsDialog.this.close();
            }
        });
        this.closeButtonPanel_.add(jButton);
        this.getContentPane().add((Component)this.closeButtonPanel_, "Last");
    }

    public void setVisible(boolean bl) {
        this.updatePanels();
        super.setVisible(bl);
    }

    private void updatePanels() {
        this.customTimeIntervalsPanel_.syncCheckBoxFromAcqEng();
        this.customTimeIntervalsPanel_.syncIntervalsFromAcqEng();
    }

    private void close() {
        this.setVisible(false);
    }
}

