/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.zip.DeflaterOutputStream;

public class PDFStream
extends PDFObject
implements Serializable {
    transient ByteArrayOutputStream buf = new ByteArrayOutputStream();
    boolean deflate = false;

    public PDFStream() {
        this(null);
    }

    public PDFStream(String string) {
        super(string);
    }

    public void setDeflate(boolean bl) {
        this.deflate = bl;
    }

    public boolean getDeflate() {
        return this.deflate;
    }

    public OutputStream getOutputStream() {
        return this.buf;
    }

    public PrintWriter getWriter() {
        return new PrintWriter(this.buf, true);
    }

    public ByteArrayOutputStream getStream() {
        return this.buf;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.writeStart(outputStream);
        this.writeStream(outputStream);
    }

    public void writeStream(OutputStream outputStream) throws IOException {
        if (this.deflate) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            this.buf.writeTo(deflaterOutputStream);
            deflaterOutputStream.finish();
            deflaterOutputStream.close();
            outputStream.write("/Filter /FlateDecode\n".getBytes());
            outputStream.write("/Length ".getBytes());
            outputStream.write(Integer.toString(byteArrayOutputStream.size() + 1).getBytes());
            outputStream.write("\n>>\nstream\n".getBytes());
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.write("\n".getBytes());
        } else {
            outputStream.write("/Length ".getBytes());
            outputStream.write(Integer.toString(this.buf.size()).getBytes());
            outputStream.write("\n>>\nstream\n".getBytes());
            this.buf.writeTo(outputStream);
        }
        outputStream.write("endstream\nendobj\n".getBytes());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.buf.size());
        objectOutputStream.write(this.buf.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.read(byArray, 0, n);
        this.buf = new ByteArrayOutputStream(n);
        this.buf.write(byArray);
    }
}

