/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFGraphics;
import gnu.jpdf.PDFInfo;
import gnu.jpdf.PDFJob;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Locale;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.RequestingUserName;
import javax.swing.JFileChooser;

public class PDFPrinterJob
extends PrinterJob {
    private static JFileChooser fileChooser;
    private PrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
    private PDFInfo info = new PDFInfo();
    private Pageable pageable = null;
    private PageFormat pageFormat = new PageFormat();
    private Printable printable;
    private PDFJob printJob;

    public PDFPrinterJob() {
        this.setJobName("Java Printing");
    }

    public void cancel() {
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        return this.validatePage(pageFormat);
    }

    public int getCopies() {
        return ((IntegerSyntax)((Object)this.attributes.get(Copies.class))).getValue();
    }

    public String getJobName() {
        return ((TextSyntax)((Object)this.attributes.get(JobName.class))).getValue();
    }

    public static PrinterJob getPrinterJob() {
        return new PDFPrinterJob();
    }

    public String getUserName() {
        return ((TextSyntax)((Object)this.attributes.get(RequestingUserName.class))).getValue();
    }

    public boolean isCancelled() {
        return false;
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        return (PageFormat)pageFormat.clone();
    }

    public void print(String string) throws PrinterException {
        File file = null;
        FileOutputStream fileOutputStream = null;
        try {
            file = new File(string);
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception exception) {
            System.err.println("Error!! - Invalid output file path: " + string);
        }
        PDFGraphics pDFGraphics = null;
        this.printJob = new PDFJob(fileOutputStream);
        if (this.info != null) {
            this.printJob.getPDFDocument().setPDFInfo(this.info);
        }
        int n = this.pageable.getNumberOfPages();
        for (int i = 0; i < n; ++i) {
            this.pageFormat = this.pageable.getPageFormat(i);
            pDFGraphics = (PDFGraphics)this.printJob.getGraphics(this.pageFormat);
            this.printable = this.pageable.getPrintable(i);
            this.printable.print(pDFGraphics, this.pageFormat, i);
            pDFGraphics.dispose();
        }
        this.printJob.end();
    }

    public void print() throws PrinterException {
        String string = this.getJobName();
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
        }
        if (string.equals("")) {
            string = "Java Printing";
        }
        string = string.replaceAll("\\\\", "-");
        string = string.replaceAll("/", "-");
        File file = fileChooser.getCurrentDirectory();
        File file2 = new File(file, string + ".pdf");
        fileChooser.setSelectedFile(file2);
        if (fileChooser.showSaveDialog(null) == 0) {
            file2 = fileChooser.getSelectedFile();
            this.print(file2.getAbsolutePath());
        }
    }

    public boolean printDialog() throws HeadlessException {
        return true;
    }

    public void setAuthor(String string) {
        this.info.setAuthor(string);
    }

    public void setCopies(int n) {
        this.attributes.add(new Copies(n));
    }

    public void setCreator(String string) {
        this.info.setCreator(string);
    }

    public void setJobName(String string) {
        this.attributes.add(new JobName(string, Locale.getDefault()));
        if (this.info.getTitle() == null) {
            this.info.setTitle(string);
        }
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        if (pageable == null) {
            throw new NullPointerException("Pageable cannot be null.");
        }
        this.pageable = pageable;
    }

    public void setPrintable(Printable printable) {
        this.printable = printable;
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.printable = printable;
        this.pageFormat = pageFormat;
    }

    public void setTitle(String string) {
        this.info.setTitle(string);
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        return (PageFormat)pageFormat.clone();
    }
}

