/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFAnnot;
import gnu.jpdf.PDFFont;
import gnu.jpdf.PDFGraphics;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFOutline;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;

public class PDFPage
extends PDFObject
implements Serializable {
    private static final PageFormat DEF_FORMAT = new PageFormat();
    protected PageFormat pageFormat;
    protected PDFObject pdfPageList;
    protected Vector<PDFObject> contents;
    protected PDFObject thumbnail = null;
    protected Vector<PDFObject> annotations;
    protected Vector<String> resources;
    protected Vector<String> imageResources;
    protected Vector<PDFFont> fonts;
    protected boolean hasImageB;
    protected boolean hasImageC;
    protected boolean hasImageI;
    protected procset procset = null;
    private Vector<String> xobjects = new Vector();

    public PDFPage() {
        super("/Page");
        this.pageFormat = DEF_FORMAT;
        this.contents = new Vector();
        this.annotations = new Vector();
        this.resources = new Vector();
        this.imageResources = new Vector();
        this.fonts = new Vector();
    }

    public PDFPage(int n) {
        this();
        this.setOrientation(n);
    }

    public PDFPage(PageFormat pageFormat) {
        this();
        this.pageFormat = pageFormat;
    }

    public void addToProcset(String string) {
        if (this.procset == null) {
            this.addProcset();
        }
        this.procset.add(string);
    }

    public PDFGraphics getGraphics() {
        try {
            PDFGraphics pDFGraphics = new PDFGraphics();
            pDFGraphics.init(this);
            return pDFGraphics;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public PDFFont getFont(String string, String string2, int n) {
        for (PDFFont pDFFont : this.fonts) {
            if (!pDFFont.equals(string, string2, n)) continue;
            return pDFFont;
        }
        if (this.fonts.size() == 0) {
            this.addProcset();
            this.procset.add("/Text");
        }
        PDFFont pDFFont = this.pdfDocument.getFont(string, string2, n);
        this.fonts.addElement(pDFFont);
        return pDFFont;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Dimension getDimension() {
        return new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
    }

    public Rectangle getImageableArea() {
        return new Rectangle((int)this.pageFormat.getImageableX(), (int)this.pageFormat.getImageableY(), (int)(this.pageFormat.getImageableX() + this.pageFormat.getImageableWidth()), (int)(this.pageFormat.getImageableY() + this.pageFormat.getImageableHeight()));
    }

    public void setOrientation(int n) {
        this.pageFormat.setOrientation(n);
    }

    public int getOrientation() {
        return this.pageFormat.getOrientation();
    }

    public void add(PDFObject pDFObject) {
        this.contents.addElement(pDFObject);
    }

    public void addAnnotation(PDFObject pDFObject) {
        this.annotations.addElement(pDFObject);
    }

    public PDFAnnot addNote(String string, int n, int n2, int n3, int n4) {
        int[] nArray = this.cxy(n, n2 + n4);
        int[] nArray2 = this.cxy(n + n3, n2);
        PDFAnnot pDFAnnot = new PDFAnnot(nArray[0], nArray[1], nArray2[0], nArray2[1], string);
        this.pdfDocument.add(pDFAnnot);
        this.annotations.addElement(pDFAnnot);
        return pDFAnnot;
    }

    public PDFAnnot addLink(int n, int n2, int n3, int n4, PDFObject pDFObject) {
        int[] nArray = this.cxy(n, n2 + n4);
        int[] nArray2 = this.cxy(n + n3, n2);
        PDFAnnot pDFAnnot = new PDFAnnot(nArray[0], nArray[1], nArray2[0], nArray2[1], pDFObject);
        this.pdfDocument.add(pDFAnnot);
        this.annotations.addElement(pDFAnnot);
        return pDFAnnot;
    }

    public PDFAnnot addLink(int n, int n2, int n3, int n4, PDFObject pDFObject, int n5, int n6, int n7, int n8) {
        int[] nArray = this.cxy(n, n2 + n4);
        int[] nArray2 = this.cxy(n + n3, n2);
        int[] nArray3 = this.cxy(n5, n6 + n8);
        int[] nArray4 = this.cxy(n5 + n7, n6);
        PDFAnnot pDFAnnot = new PDFAnnot(nArray[0], nArray[1], nArray2[0], nArray2[1], pDFObject, nArray3[0], nArray3[1], nArray4[0], nArray4[1]);
        this.pdfDocument.add(pDFAnnot);
        this.annotations.addElement(pDFAnnot);
        return pDFAnnot;
    }

    public void addXObject(String string) {
        this.xobjects.addElement(string);
    }

    public void addResource(String string) {
        this.resources.addElement(string);
    }

    public void addImageResource(String string) {
        this.imageResources.addElement(string);
    }

    public void setThumbnail(PDFObject pDFObject) {
        this.thumbnail = pDFObject;
    }

    public PDFOutline addOutline(String string) {
        PDFOutline pDFOutline = new PDFOutline(string, this);
        this.pdfDocument.add(pDFOutline);
        this.pdfDocument.getOutline().add(pDFOutline);
        return pDFOutline;
    }

    public PDFOutline addOutline(String string, int n, int n2, int n3, int n4) {
        int[] nArray = this.cxy(n, n2 + n4);
        int[] nArray2 = this.cxy(n + n3, n2);
        PDFOutline pDFOutline = new PDFOutline(string, this, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        this.pdfDocument.add(pDFOutline);
        this.pdfDocument.getOutline().add(pDFOutline);
        return pDFOutline;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.writeStart(outputStream);
        outputStream.write("/Parent ".getBytes());
        outputStream.write(this.pdfPageList.toString().getBytes());
        outputStream.write("\n".getBytes());
        outputStream.write("/MediaBox [".getBytes());
        outputStream.write(Integer.toString(0).getBytes());
        outputStream.write(" ".getBytes());
        outputStream.write(Integer.toString(0).getBytes());
        outputStream.write(" ".getBytes());
        outputStream.write(Integer.toString((int)this.pageFormat.getWidth()).getBytes());
        outputStream.write(" ".getBytes());
        outputStream.write(Integer.toString((int)this.pageFormat.getHeight()).getBytes());
        outputStream.write("]\n".getBytes());
        outputStream.write("/Resources << ".getBytes());
        if (this.fonts.size() > 0) {
            outputStream.write("\n/Font << ".getBytes());
            for (PDFFont object : this.fonts) {
                outputStream.write(object.getName().getBytes());
                outputStream.write(" ".getBytes());
                outputStream.write(object.toString().getBytes());
                outputStream.write(" ".getBytes());
            }
            outputStream.write(">> ".getBytes());
        }
        if (this.xobjects.size() > 0) {
            outputStream.write("\n/XObject << ".getBytes());
            for (String string : this.xobjects) {
                outputStream.write(string.getBytes());
                outputStream.write(" ".getBytes());
            }
            outputStream.write(">> ".getBytes());
        }
        for (String string : this.resources) {
            outputStream.write(string.getBytes());
            outputStream.write(" ".getBytes());
        }
        if (this.imageResources.size() > 0) {
            outputStream.write("/XObject << ".getBytes());
            for (String string : this.imageResources) {
                outputStream.write(string.getBytes());
                outputStream.write(" ".getBytes());
            }
            outputStream.write(" >> ".getBytes());
        }
        outputStream.write(">>\n".getBytes());
        if (this.thumbnail != null) {
            outputStream.write("/Thumb ".getBytes());
            outputStream.write(this.thumbnail.toString().getBytes());
            outputStream.write("\n".getBytes());
        }
        if (this.contents.size() > 0) {
            if (this.contents.size() == 1) {
                PDFObject pDFObject = this.contents.elementAt(0);
                outputStream.write("/Contents ".getBytes());
                outputStream.write(pDFObject.toString().getBytes());
                outputStream.write("\n".getBytes());
            } else {
                outputStream.write("/Contents [".getBytes());
                outputStream.write(PDFObject.toArray(this.contents).getBytes());
                outputStream.write("\n".getBytes());
            }
        }
        if (this.annotations.size() > 0) {
            outputStream.write("/Annots ".getBytes());
            outputStream.write(PDFObject.toArray(this.annotations).getBytes());
            outputStream.write("\n".getBytes());
        }
        this.writeEnd(outputStream);
    }

    private void addProcset() {
        if (this.procset == null) {
            this.procset = new procset();
            this.pdfDocument.add(this.procset);
            this.resources.addElement("/ProcSet " + this.procset);
        }
    }

    public int cy(int n, int n2) {
        return this.cxy(n, n2)[1];
    }

    public int cx(int n, int n2) {
        return this.cxy(n, n2)[0];
    }

    public int[] cxy(int n, int n2) {
        int[] nArray = new int[]{n, (int)this.pageFormat.getHeight() - n2};
        return nArray;
    }

    public class procset
    extends PDFObject {
        private Vector<String> set;

        public procset() {
            super(null);
            this.set = new Vector();
            this.set.addElement("/PDF");
        }

        public void add(String string) {
            this.set.addElement(" " + string);
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(Integer.toString(this.objser).getBytes());
            outputStream.write(" 0 obj\n".getBytes());
            outputStream.write("[".getBytes());
            for (String string : this.set) {
                outputStream.write(string.getBytes());
            }
            outputStream.write("]\n".getBytes());
            outputStream.write("endobj\n".getBytes());
        }
    }
}

