/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFAnnot;
import gnu.jpdf.PDFDocument;
import gnu.jpdf.PDFGraphics;
import gnu.jpdf.PDFOutline;
import gnu.jpdf.PDFPage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class PDFJob
extends PrintJob
implements Serializable {
    protected transient OutputStream os;
    protected PDFDocument pdfDocument;
    protected PDFPage page;
    protected int pagenum;

    public PDFJob() {
        this(null);
    }

    public PDFJob(OutputStream outputStream) {
        this(outputStream, "PDF Doc");
    }

    public PDFJob(OutputStream outputStream, String string) {
        this.os = outputStream;
        this.pdfDocument = new PDFDocument();
        this.pagenum = 0;
        this.pdfDocument.getPDFInfo().setTitle(string);
    }

    public Graphics getGraphics(int n) {
        this.page = new PDFPage(n);
        this.pdfDocument.add(this.page);
        ++this.pagenum;
        return new graphic(this.page, this);
    }

    public Graphics getGraphics(PageFormat pageFormat) {
        this.page = new PDFPage(pageFormat);
        this.pdfDocument.add(this.page);
        ++this.pagenum;
        return new graphic(this.page, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        try {
            this.pdfDocument.write(this.os);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.os = null;
        this.pdfDocument = null;
    }

    public Graphics getGraphics() {
        return this.getGraphics(1);
    }

    public Dimension getPageDimension() {
        if (this.page == null) {
            System.err.println("PDFJob.getPageDimension(), page is null");
        }
        return this.page.getDimension();
    }

    public int getPageResolution() {
        return 72;
    }

    public boolean lastPageFirst() {
        return false;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDocument;
    }

    public PDFPage getCurrentPage() {
        return this.page;
    }

    public int getCurrentPageNumber() {
        return this.pagenum;
    }

    public PDFOutline addOutline(String string) {
        return this.page.addOutline(string);
    }

    public PDFOutline addOutline(String string, int n, int n2, int n3, int n4) {
        return this.page.addOutline(string, n, n2, n3, n4);
    }

    public PDFAnnot addNote(String string, int n, int n2, int n3, int n4) {
        return this.page.addNote(string, n, n2, n3, n4);
    }

    class graphic
    extends PDFGraphics
    implements PrintGraphics {
        private PDFJob job;

        graphic(PDFPage pDFPage, PDFJob pDFJob2) {
            this.init(pDFPage);
            this.job = pDFJob2;
        }

        graphic(PDFPage pDFPage, PDFJob pDFJob2, PrintWriter printWriter) {
            this.init(pDFPage, printWriter);
            this.job = pDFJob2;
        }

        public Graphics create() {
            this.closeBlock();
            graphic graphic2 = new graphic(this.getPage(), this.job, this.getWriter());
            graphic2.clipRectangle = new Rectangle(this.clipRectangle);
            return graphic2;
        }

        public PrintJob getPrintJob() {
            return this.job;
        }
    }
}

