/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PDFFont
extends PDFObject
implements Serializable {
    private String name;
    private String type;
    private String font;
    private String javaFont;
    private int style;
    private static String[][] base14 = new String[][]{{"arial", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"sansserif", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"monospaced", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"timesroman", "/Times-Roman", "/Times-Bold", "/Times-Italic", "/Times-BoldItalic"}, {"courier", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"helvetica", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"dialog", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"dialoginput", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}};

    protected PDFFont() {
        this("/F1", "/Type1", "Helvetica", 0);
    }

    public PDFFont(String string, String string2, String string3, int n) {
        super("/Font");
        this.name = string;
        this.type = string2;
        this.style = n;
        String string4 = string3.toLowerCase();
        this.font = string3;
        this.javaFont = "/" + string3;
        for (int i = 0; i < base14.length; ++i) {
            if (!base14[i][0].equals(string4)) continue;
            this.javaFont = base14[i][0];
            this.font = base14[i][1 + n];
            break;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getFont() {
        return this.font;
    }

    public int getStyle() {
        return this.style;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.writeStart(outputStream);
        outputStream.write("/Subtype ".getBytes());
        outputStream.write(this.type.getBytes());
        outputStream.write("\n/Name ".getBytes());
        outputStream.write(this.name.getBytes());
        outputStream.write("\n/BaseFont ".getBytes());
        outputStream.write(this.font.getBytes());
        outputStream.write("\n/Encoding ".getBytes());
        outputStream.write("/WinAnsiEncoding".getBytes());
        outputStream.write("\n".getBytes());
        this.writeEnd(outputStream);
    }

    protected boolean equals(String string, String string2, int n) {
        return this.type.equals(string) && (this.font.equalsIgnoreCase(string2) || this.javaFont.equalsIgnoreCase(string2));
    }
}

