/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class HelpFrame
extends JFrame {
    public HelpFrame() {
        this.setTitle("gnupdf Help");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea(20, 40);
        jTextArea.setLineWrap(true);
        jTextArea.append(this.getHelpText());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        container.add(jScrollPane);
        this.setSize(jScrollPane.getSize());
        this.setLocation(new Point(200, 200));
        this.pack();
        this.toFront();
        this.show();
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
    }

    private String getHelpText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("gnujpdf Help File and Tutorial\n");
        stringBuffer.append("\n");
        stringBuffer.append("This file contains some general help and a simple tutorial on the\n");
        stringBuffer.append("gnujpdf java package (gnu.jpdf.*).  More information can be\n");
        stringBuffer.append("obtained from the website, http://gnujpdf.sourceforge.net.\n");
        stringBuffer.append("\n");
        stringBuffer.append("gnujpdf is a set of Java classes that allows a programmer to use\n");
        stringBuffer.append("extended versions of java.awt.Graphics and java.awt.PrintJob to\n");
        stringBuffer.append("generate and print pdf files.  The idea is to use methods and\n");
        stringBuffer.append("classes that act on a Graphics object to produce the same output\n");
        stringBuffer.append("in a pdf file, on the screen, and on the printer.\n");
        stringBuffer.append("\n");
        stringBuffer.append("The best source of information for a programmer wishing to use\n");
        stringBuffer.append("this simple API is the source code in PDFTest.java.  It\n");
        stringBuffer.append("demonstrates a simple application that displays various\n");
        stringBuffer.append("formatting and simultaneously writes a pdf file that will be an\n");
        stringBuffer.append("identical copy of what is seen on the screen.\n");
        stringBuffer.append("\n");
        stringBuffer.append("The starting point for creating any PDF document with this\n");
        stringBuffer.append("library is the PDFJob class.\n");
        stringBuffer.append("\n");
        stringBuffer.append("PDFJob job = new PDFJob(fileOutputStream);\n");
        stringBuffer.append("\n");
        stringBuffer.append("The fileOutputStream is normally a stream initialized with the\n");
        stringBuffer.append("name of the pdf you wish to generate, such as \"test.pdf\".  A\n");
        stringBuffer.append("PDFGraphics object can be obtained from the job by calling:\n");
        stringBuffer.append("\n");
        stringBuffer.append("Graphics pdfGraphics = job.getGraphics();\n");
        stringBuffer.append("\n");
        stringBuffer.append("This Graphics object can be passed into the same methods used to\n");
        stringBuffer.append("draw to the screen.  Most of the common methods in\n");
        stringBuffer.append("java.awt.Graphics have been implemented (with a few important\n");
        stringBuffer.append("exceptions - this is a beta product, so there is still plenty of\n");
        stringBuffer.append("work to be done - see the source code for more specifics).  When\n");
        stringBuffer.append("calling methods such as drawString(..)  or drawImage(..), what is\n");
        stringBuffer.append("actually happening is that the PDFGraphics object is writing the\n");
        stringBuffer.append("necessary markup to the output stream.\n");
        stringBuffer.append("\n");
        stringBuffer.append("A new pdf page is initialized by disposing of the exisiting\n");
        stringBuffer.append("Graphics object and getting a new one from the job.\n");
        stringBuffer.append("\n");
        stringBuffer.append("pdfGraphics.dispose(); \n");
        stringBuffer.append("pdfGraphics = job.getGraphics();\n");
        stringBuffer.append("\n");
        stringBuffer.append("Any Graphics operations will now be made on a new page in the pdf\n");
        stringBuffer.append("document.  When the document is finished, the job must be closed\n");
        stringBuffer.append("out:\n");
        stringBuffer.append("\n");
        stringBuffer.append("pdfGraphics.dispose();\n");
        stringBuffer.append("job.end();\n");
        stringBuffer.append("\n");
        stringBuffer.append("And the fileOutputStream will need to be closed properly as well,\n");
        stringBuffer.append("as this is not guaranteed to be taken care of by the PDF classes.\n");
        stringBuffer.append("\n");
        stringBuffer.append("----------------\n");
        stringBuffer.append("End of Help File\n");
        stringBuffer.append("\n");
        stringBuffer.append("For more information, see http://gnujpdf.sourceforge.net\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

