/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import ome.io.nio.PixelBuffer;
import ome.io.nio.TileLoopIteration;

public class Utils {
    public static int forEachTile(TileLoopIteration iteration, PixelBuffer pixelBuffer, int tileWidth, int tileHeight) {
        int sizeX = pixelBuffer.getSizeX();
        int sizeY = pixelBuffer.getSizeY();
        int sizeZ = pixelBuffer.getSizeZ();
        int sizeC = pixelBuffer.getSizeC();
        int sizeT = pixelBuffer.getSizeT();
        return Utils.forEachTile(iteration, sizeX, sizeY, sizeZ, sizeC, sizeT, tileWidth, tileHeight);
    }

    public static int forEachTile(TileLoopIteration iteration, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int tileWidth, int tileHeight) {
        int tileCount = 0;
        for (int t = 0; t < sizeT; ++t) {
            for (int c = 0; c < sizeC; ++c) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int tileOffsetY = 0; tileOffsetY < (sizeY + tileHeight - 1) / tileHeight; ++tileOffsetY) {
                        for (int tileOffsetX = 0; tileOffsetX < (sizeX + tileWidth - 1) / tileWidth; ++tileOffsetX) {
                            int h;
                            int x = tileOffsetX * tileWidth;
                            int y = tileOffsetY * tileHeight;
                            int w = tileWidth;
                            if (w + x > sizeX) {
                                w = sizeX - x;
                            }
                            if ((h = tileHeight) + y > sizeY) {
                                h = sizeY - y;
                            }
                            iteration.run(z, c, t, x, y, w, h, tileCount);
                            ++tileCount;
                        }
                    }
                }
            }
        }
        return tileCount;
    }
}

