/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.meta.IMinMaxStore;
import ome.conditions.LockTimeout;
import ome.conditions.ResourceError;
import ome.io.bioformats.BfPixelBuffer;
import ome.io.bioformats.BfPyramidPixelBuffer;
import ome.io.messages.MissingPyramidMessage;
import ome.io.nio.AbstractFileSystemService;
import ome.io.nio.BackOff;
import ome.io.nio.ConfiguredTileSizes;
import ome.io.nio.FilePathResolver;
import ome.io.nio.PixelBuffer;
import ome.io.nio.RomioPixelBuffer;
import ome.io.nio.SimpleBackOff;
import ome.io.nio.TileLoopIteration;
import ome.io.nio.TileSizes;
import ome.io.nio.Utils;
import ome.model.core.Pixels;
import ome.model.stats.StatsInfo;
import ome.util.PixelData;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PixelsService
extends AbstractFileSystemService
implements ApplicationEventPublisherAware {
    private static transient Log log = LogFactory.getLog(PixelsService.class);
    private transient ApplicationEventPublisher pub;
    public static final String DV_FORMAT = "DV";
    public static final String PYRAMID_SUFFIX = "_pyramid";
    public static final int NULL_PLANE_SIZE = 64;
    protected FilePathResolver resolver;
    protected BackOff backOff;
    protected TileSizes sizes;
    public static final byte[] nullPlane = new byte[]{-128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127};

    public PixelsService(String path) {
        this(path, null, new SimpleBackOff(), new ConfiguredTileSizes());
    }

    public PixelsService(String path, FilePathResolver resolver) {
        this(path, resolver, new SimpleBackOff(), new ConfiguredTileSizes());
    }

    public PixelsService(String path, FilePathResolver resolver, BackOff backOff, TileSizes sizes) {
        super(path);
        this.resolver = resolver;
        this.backOff = backOff;
        this.sizes = sizes;
        if (log.isInfoEnabled()) {
            log.info((Object)("PixelsService(path=" + path + ", resolver=" + resolver + ", backoff=" + backOff + ", sizes=" + sizes + ")"));
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher pub) {
        if (this.pub != null) {
            throw new FatalBeanException("Publisher already set.");
        }
        this.pub = pub;
    }

    public void setFilePathResolver(FilePathResolver resolver) {
        this.resolver = resolver;
    }

    public PixelBuffer createPixelBuffer(Pixels pixels) throws IOException {
        RomioPixelBuffer pixbuf = new RomioPixelBuffer(this.getPixelsPath(pixels.getId()), pixels, true);
        this.initPixelBuffer(pixbuf);
        return pixbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatsInfo[] makePyramid(Pixels pixels) {
        String pixelsFilePath = this.getPixelsPath(pixels.getId());
        File pixelsFile = new File(pixelsFilePath);
        String pixelsPyramidFilePath = pixelsFilePath + PYRAMID_SUFFIX;
        File pixelsPyramidFile = new File(pixelsPyramidFilePath);
        String originalFilePath = this.getOriginalFilePath(pixels);
        if (pixelsPyramidFile.exists()) {
            log.debug((Object)("Pyramid already exists: " + pixelsPyramidFilePath));
            return null;
        }
        BfPyramidPixelBuffer pixelsPyramid = this.createPyramidPixelBuffer(pixels, pixelsPyramidFilePath, true);
        try {
            if (!pixelsFile.exists() && originalFilePath == null) {
                log.error((Object)("FAIL -- Original pixels file does not exist: " + pixelsFile.getAbsolutePath()));
                StatsInfo[] statsInfoArray = null;
                return statsInfoArray;
            }
            PixelsPyramidMinMaxStore minMaxStore = this.performWrite(pixels, pixelsPyramidFile, pixelsPyramid, pixelsFile, pixelsFilePath, originalFilePath);
            if (minMaxStore != null) {
                StatsInfo[] statsInfoArray = minMaxStore.createStatsInfo();
                return statsInfoArray;
            }
            StatsInfo[] statsInfoArray = null;
            return statsInfoArray;
        }
        finally {
            if (pixelsPyramid != null) {
                try {
                    pixelsPyramid.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing pixel pyramid.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PixelsPyramidMinMaxStore performWrite(final Pixels pixels, final File pixelsPyramidFile, final BfPyramidPixelBuffer pixelsPyramid, File pixelsFile, String pixelsFilePath, String originalFilePath) {
        Dimension tileSize;
        PixelBuffer source;
        PixelsPyramidMinMaxStore minMaxStore;
        if (pixelsFile.exists()) {
            minMaxStore = null;
            source = this.createRomioPixelBuffer(pixelsFilePath, pixels, false);
            tileSize = new Dimension(Math.min(pixels.getSizeX(), this.sizes.getTileWidth()), Math.min(pixels.getSizeY(), this.sizes.getTileHeight()));
        } else {
            minMaxStore = new PixelsPyramidMinMaxStore(pixels.getSizeC());
            int series = this.getSeries(pixels);
            BfPixelBuffer bfPixelBuffer = this.createMinMaxBfPixelBuffer(originalFilePath, series, minMaxStore);
            pixelsPyramid.setByteOrder(bfPixelBuffer.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            source = bfPixelBuffer;
            Dimension sourceTileSize = source.getTileSize();
            double tileWidth = sourceTileSize.getWidth();
            double tileHeight = sourceTileSize.getHeight();
            double factor = Math.pow(2.0, 5.0);
            boolean tileDimensionTooSmall = tileWidth / factor < 1.0 || tileHeight / factor < 1.0;
            tileSize = tileWidth == (double)source.getSizeX() || tileHeight == (double)source.getSizeY() || tileDimensionTooSmall ? new Dimension(Math.min(pixels.getSizeX(), this.sizes.getTileWidth()), Math.min(pixels.getSizeY(), this.sizes.getTileHeight())) : sourceTileSize;
        }
        log.info((Object)("Destination pyramid tile size: " + tileSize));
        try {
            final double totalTiles = (double)(source.getSizeZ() * source.getSizeC() * source.getSizeT()) * Math.ceil((double)source.getSizeX() / tileSize.getWidth()) * Math.ceil((double)source.getSizeY() / tileSize.getHeight());
            final int tenPercent = Math.max((int)totalTiles / 10, 1);
            Utils.forEachTile(new TileLoopIteration(){

                public void run(int z, int c, int t, int x, int y, int w, int h, int tileCount) {
                    if (log.isInfoEnabled() && tileCount % tenPercent == 0) {
                        log.info((Object)String.format("Pyramid creation for Pixels:%d %d/%d (%d%%).", pixels.getId(), tileCount + 1, (int)totalTiles, (int)((double)tileCount / totalTiles * 100.0)));
                    }
                    try {
                        PixelData tile = source.getTile(z, c, t, x, y, w, h);
                        pixelsPyramid.setTile(tile.getData().array(), z, c, t, x, y, w, h);
                    }
                    catch (IOException e1) {
                        log.error((Object)"FAIL -- Error during tile population", (Throwable)e1);
                        try {
                            pixelsPyramidFile.delete();
                            FileUtils.touch((File)pixelsPyramidFile);
                        }
                        catch (Exception e2) {
                            log.warn((Object)"Error clearing empty or incomplete pixel buffer.", (Throwable)e2);
                        }
                        return;
                    }
                }
            }, source, (int)tileSize.getWidth(), (int)tileSize.getHeight());
            log.info((Object)("SUCCESS -- Pyramid created for pixels id:" + pixels.getId()));
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing pixel pyramid.", (Throwable)e);
                }
            }
        }
        return minMaxStore;
    }

    @Deprecated
    public PixelBuffer getPixelBuffer(Pixels pixels) {
        return this.getPixelBuffer(pixels, true);
    }

    public PixelBuffer getPixelBuffer(Pixels pixels, boolean write) {
        String originalFilePath = this.getOriginalFilePath(pixels);
        boolean requirePyramid = originalFilePath == null ? this.requiresPixelsPyramid(pixels) : true;
        String pixelsFilePath = this.getPixelsPath(pixels.getId());
        File pixelsFile = new File(pixelsFilePath);
        String pixelsPyramidFilePath = pixelsFilePath + PYRAMID_SUFFIX;
        File pixelsPyramidFile = new File(pixelsPyramidFilePath);
        if ((pixelsFile.exists() || originalFilePath != null) && requirePyramid) {
            while (!pixelsPyramidFile.exists()) {
                this.handleMissingPyramid(pixels, pixelsPyramidFilePath);
            }
        }
        if (pixelsPyramidFile.exists()) {
            log.info((Object)("Using Pyramid BfPixelBuffer: " + pixelsPyramidFilePath));
            return this.createPyramidPixelBuffer(pixels, pixelsPyramidFilePath, write);
        }
        if (!pixelsFile.exists()) {
            if (requirePyramid) {
                if (!write) {
                    throw new LockTimeout("Pixels pyramid missing, being created or import in progress.", 15000L, 0);
                }
                log.info((Object)("Creating Pyramid BfPixelBuffer: " + pixelsPyramidFilePath));
                return this.createPyramidPixelBuffer(pixels, pixelsPyramidFilePath, write);
            }
            if (!write) {
                throw new LockTimeout("Import in progress.", 15000L, 0);
            }
            if (originalFilePath != null) {
                int series = this.getSeries(pixels);
                return this.createBfPixelBuffer(originalFilePath, series);
            }
            log.info((Object)"Creating ROMIO Pixel buffer.");
            this.createSubpath(pixelsFilePath);
            return this.createRomioPixelBuffer(pixelsFilePath, pixels, write);
        }
        log.info((Object)"Pixel buffer file exists returning read-only ROMIO pixel buffer.");
        return this.createRomioPixelBuffer(pixelsFilePath, pixels, false);
    }

    public boolean requiresPixelsPyramid(Pixels pixels) {
        int sizeY;
        int sizeX = pixels.getSizeX();
        boolean requirePyramid = sizeX * (sizeY = pixels.getSizeY().intValue()) > this.sizes.getMaxPlaneWidth() * this.sizes.getMaxPlaneHeight();
        return requirePyramid;
    }

    protected String getOriginalFilePath(Pixels pixels) {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getOriginalFilePath(this, pixels);
    }

    protected int getSeries(Pixels pixels) {
        try {
            Map<String, String> params = this.resolver.getPixelsParams(pixels);
            return Integer.valueOf(params.get("image_no"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPixelBuffer(RomioPixelBuffer pixbuf) throws IOException {
        String path = this.getPixelsPath(pixbuf.getId());
        this.createSubpath(path);
        byte[] padding = new byte[pixbuf.getPlaneSize() - 64];
        FileOutputStream stream = new FileOutputStream(path);
        try {
            for (int z = 0; z < pixbuf.getSizeZ(); ++z) {
                for (int c = 0; c < pixbuf.getSizeC(); ++c) {
                    for (int t = 0; t < pixbuf.getSizeT(); ++t) {
                        stream.write(nullPlane);
                        stream.write(padding);
                    }
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing stream.", (Throwable)e);
                }
            }
        }
    }

    protected void handleMissingPyramid(Pixels pixels, String pixelsPyramidFilePath) {
        MissingPyramidMessage mpm = new MissingPyramidMessage(this, pixels.getId());
        this.pub.publishEvent((ApplicationEvent)mpm);
        if (mpm.isRetry()) {
            log.debug((Object)("Retrying pyramid:" + pixelsPyramidFilePath));
            return;
        }
        String msg = "Missing pyramid:" + pixelsPyramidFilePath;
        log.info((Object)msg);
        this.backOff.throwMissingPyramidException(msg, pixels);
    }

    protected BfPixelBuffer createMinMaxBfPixelBuffer(String filePath, int series, IMinMaxStore store) {
        try {
            ImageReader reader = new ImageReader();
            reader = new ChannelFiller((IFormatReader)reader);
            reader = new ChannelSeparator((IFormatReader)reader);
            MinMaxCalculator calculator = new MinMaxCalculator((IFormatReader)reader);
            calculator.setMinMaxStore(store);
            BfPixelBuffer pixelBuffer = new BfPixelBuffer(filePath, (IFormatReader)calculator);
            pixelBuffer.setSeries(series);
            log.info((Object)String.format("Creating BfPixelBuffer: %s Series: %d", filePath, series));
            return pixelBuffer;
        }
        catch (Exception e) {
            String msg = "Error instantiating pixel buffer: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new ResourceError(msg);
        }
    }

    protected PixelBuffer createBfPixelBuffer(String filePath, int series) {
        try {
            ImageReader reader = new ImageReader();
            reader = new ChannelFiller((IFormatReader)reader);
            reader = new ChannelSeparator((IFormatReader)reader);
            BfPixelBuffer pixelBuffer = new BfPixelBuffer(filePath, (IFormatReader)reader);
            pixelBuffer.setSeries(series);
            log.info((Object)String.format("Creating BfPixelBuffer: %s Series: %d", filePath, series));
            return pixelBuffer;
        }
        catch (Exception e) {
            String msg = "Error instantiating pixel buffer: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new ResourceError(msg);
        }
    }

    protected BfPyramidPixelBuffer createPyramidPixelBuffer(Pixels pixels, String filePath, boolean write) {
        try {
            if (write) {
                this.createSubpath(filePath);
            }
            return new BfPyramidPixelBuffer(pixels, filePath, write);
        }
        catch (Exception e) {
            if (e instanceof LockTimeout) {
                throw (LockTimeout)e;
            }
            String msg = "Error instantiating pixel buffer: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new ResourceError(msg);
        }
    }

    protected PixelBuffer createRomioPixelBuffer(String pixelsFilePath, Pixels pixels, boolean allowModification) {
        return new RomioPixelBuffer(pixelsFilePath, pixels, allowModification);
    }

    public void removePixels(List<Long> pixelIds) {
        boolean success = false;
        for (Long id : pixelIds) {
            String pixelPath = this.getPixelsPath(id);
            File file = new File(pixelPath);
            String fileName = file.getName();
            if (!file.exists()) continue;
            success = file.delete();
            if (!success) {
                throw new ResourceError("Pixels " + fileName + " deletion failed");
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("INFO: Pixels " + fileName + " deleted."));
        }
    }

    class PixelsPyramidMinMaxStore
    implements IMinMaxStore {
        final double[][] channelGlobalMinMax;
        final int sizeC;

        public PixelsPyramidMinMaxStore(int sizeC) {
            this.sizeC = sizeC;
            this.channelGlobalMinMax = new double[sizeC][2];
        }

        public void setChannelGlobalMinMax(int channel, double minimum, double maximum, int series) {
            this.channelGlobalMinMax[channel][0] = minimum;
            this.channelGlobalMinMax[channel][1] = maximum;
        }

        public StatsInfo[] createStatsInfo() {
            StatsInfo[] statsInfo = new StatsInfo[this.sizeC];
            for (int c = 0; c < this.sizeC; ++c) {
                statsInfo[c] = new StatsInfo();
                statsInfo[c].setGlobalMin(Double.valueOf(this.channelGlobalMinMax[c][0]));
                statsInfo[c].setGlobalMax(Double.valueOf(this.channelGlobalMinMax[c][1]));
            }
            return statsInfo;
        }
    }
}

