/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.File;
import java.util.List;
import ome.conditions.ResourceError;
import ome.io.nio.AbstractFileSystemService;
import ome.io.nio.FileBuffer;
import ome.model.core.OriginalFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OriginalFilesService
extends AbstractFileSystemService {
    private static transient Log log = LogFactory.getLog(OriginalFilesService.class);

    public OriginalFilesService(String path) {
        super(path);
    }

    public FileBuffer getFileBuffer(OriginalFile file) {
        String path = this.getFilesPath(file.getId());
        this.createSubpath(path);
        return new FileBuffer(path, file);
    }

    public void removeFiles(List<Long> fileIds) {
        boolean success = false;
        for (Long id : fileIds) {
            String filePath = this.getFilesPath(id);
            File file = new File(filePath);
            if (!file.exists()) continue;
            success = file.delete();
            if (!success) {
                throw new ResourceError("File " + file.getName() + " deletion failed");
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("INFO: File " + file.getName() + " deleted."));
        }
    }

    public boolean exists(OriginalFile file) {
        String path = this.getFilesPath(file.getId());
        return new File(path).exists();
    }
}

