/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import ome.io.nio.AbstractBuffer;
import ome.model.core.OriginalFile;

public class FileBuffer
extends AbstractBuffer {
    private OriginalFile file;
    FileChannel channel;

    FileBuffer(String path, OriginalFile file) {
        super(path);
        if (file == null) {
            throw new NullPointerException("Expecting a not-null file element.");
        }
        this.file = file;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    private FileChannel getFileChannel() throws FileNotFoundException {
        if (this.channel == null) {
            RandomAccessFile file = new RandomAccessFile(this.getPath(), "rw");
            this.channel = file.getChannel();
        }
        return this.channel;
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.getFileChannel().read(dst);
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        return this.getFileChannel().read(dst, position);
    }

    public int write(ByteBuffer src, long position) throws IOException {
        return this.getFileChannel().write(src, position);
    }

    public int write(ByteBuffer src) throws IOException {
        return this.getFileChannel().write(src);
    }

    long getId() {
        return this.file.getId();
    }

    String getName() {
        return this.file.getName();
    }

    public long size() throws IOException {
        return this.getFileChannel().size();
    }

    public void truncate(long size) throws IOException {
        this.getFileChannel().truncate(size);
    }
}

