/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.File;
import java.util.Formatter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractFileSystemService {
    private static Log log = LogFactory.getLog(AbstractFileSystemService.class);
    public static final String ROOT_DEFAULT = File.separator + "OMERO" + File.separator;
    public static final String PIXELS_PATH = "Pixels" + File.separator;
    public static final String FILES_PATH = "Files" + File.separator;
    public static final String THUMBNAILS_PATH = "Thumbnails" + File.separator;
    private final String root;

    public AbstractFileSystemService(String path) {
        File rootDirectory = new File(path);
        if (!(rootDirectory.isDirectory() && rootDirectory.canRead() && rootDirectory.canWrite())) {
            throw new IllegalArgumentException("Invalid directory specified for file system service." + rootDirectory);
        }
        this.root = rootDirectory.getAbsolutePath();
        if (log.isDebugEnabled()) {
            log.warn((Object)("Using root path: '" + this.root + "'"));
        }
    }

    protected void createSubpath(String path) {
        File directory;
        File file = new File(path);
        if (!file.exists() && !(directory = new File(file.getParent())).exists()) {
            directory.mkdirs();
        }
    }

    public String getPixelsPath(Long id) {
        return this.getPath(PIXELS_PATH, id);
    }

    public String getFilesPath(Long id) {
        return this.getPath(FILES_PATH, id);
    }

    public String getThumbnailPath(Long id) {
        return this.getPath(THUMBNAILS_PATH, id);
    }

    private String getPath(String prefix, Long id) {
        String suffix = "";
        Long remaining = id;
        Long dirno = 0L;
        if (id == null) {
            throw new NullPointerException("Expecting a not-null id.");
        }
        while (remaining > 999L) {
            if ((remaining = Long.valueOf(remaining / 1000L)) <= 0L) continue;
            Formatter formatter = new Formatter();
            dirno = remaining % 1000L;
            suffix = formatter.format("Dir-%03d", dirno).out().toString() + File.separator + suffix;
        }
        String path = FilenameUtils.concat((String)this.root, (String)(prefix + suffix + id));
        return path;
    }
}

