/*
 * Decompiled with CFR 0.152.
 */
package ome.io.bioformats;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.in.TiffReader;
import loci.formats.out.TiffWriter;
import loci.formats.tiff.IFD;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OmeroPixelsPyramidWriter
extends TiffWriter {
    private static final Log log = LogFactory.getLog(OmeroPixelsPyramidWriter.class);
    public static final String IMAGE_DESCRIPTION = "OmeroPixelsPyramid v1.0.0";
    public static final int IFD_TAG_SERIES = 65000;
    public static final int IFD_TAG_PLANE_NUMBER = 65001;

    public void close() throws IOException {
        log.debug((Object)("close(" + this.currentId + ")"));
        try {
            if (this.currentId != null) {
                this.postProcess();
            }
        }
        catch (FormatException e) {
            String m = "Error during process processing!";
            log.error((Object)m, (Throwable)e);
            throw new IOException(m);
        }
        finally {
            super.close();
        }
    }

    public void setId(String id) throws FormatException, IOException {
        log.debug((Object)("setId(" + id + ")"));
        super.setId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postProcess() throws IOException, FormatException {
        TiffReader reader = new TiffReader();
        try {
            reader.setId(this.currentId);
            this.recompressSeries(reader, 1);
            this.recompressSeries(reader, 2);
        }
        finally {
            reader.close();
        }
    }

    protected void recompressSeries(TiffReader source, int series) throws FormatException, IOException {
        int sourceSeries = source.getSeriesCount() - series;
        source.setSeries(sourceSeries);
        int imageCount = source.getImageCount();
        this.setSeries(series);
        for (int i = 0; i < imageCount; ++i) {
            byte[] plane = source.openBytes(i);
            IFD ifd = new IFD();
            ifd.put((Object)278, (Object)new long[]{source.getSizeY()});
            ifd.put((Object)270, (Object)IMAGE_DESCRIPTION);
            ifd.put((Object)65000, (Object)(sourceSeries - 1));
            ifd.put((Object)65001, (Object)i);
            this.saveBytes(i, plane, ifd);
        }
    }
}

