/*
 * Decompiled with CFR 0.152.
 */
package ome.io.bioformats;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import ome.io.nio.DimensionsOutOfBoundsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BfPixelsWrapper {
    private static final Log log = LogFactory.getLog(BfPixelsWrapper.class);
    private final IFormatReader reader;
    private final String path;
    private final int sizeZ;
    private final int sizeC;
    private final int sizeT;
    private final int rgbChannels;
    private final int pixelType;
    private final int pixelSize;

    public BfPixelsWrapper(String path, IFormatReader reader) throws IOException, FormatException {
        this.path = path;
        this.reader = reader;
        reader.setId(path);
        this.sizeZ = reader.getSizeZ();
        this.sizeC = reader.getSizeC();
        this.sizeT = reader.getSizeT();
        this.rgbChannels = reader.getRGBChannelCount();
        this.pixelType = reader.getPixelType();
        this.pixelSize = this.getBytesPerPixel();
    }

    public byte[] getMessageDigest() throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        for (int t = 0; t < this.sizeT; ++t) {
            try {
                byte[] buffer = new byte[this.getTimepointSize().intValue()];
                this.getTimepoint(t, buffer);
                md.update(ByteBuffer.wrap(buffer));
                continue;
            }
            catch (DimensionsOutOfBoundsException e) {
                throw new RuntimeException(e);
            }
        }
        return md.digest();
    }

    public void checkBounds(Integer x, Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        if (x != null && (x > sizeX - 1 || x < 0)) {
            throw new DimensionsOutOfBoundsException("X '" + x + "' greater than sizeX '" + this.getSizeX() + "'.");
        }
        if (y != null && (y > sizeY - 1 || y < 0)) {
            throw new DimensionsOutOfBoundsException("Y '" + y + "' greater than sizeY '" + this.getSizeY() + "'.");
        }
        if (z != null && (z > this.sizeZ - 1 || z < 0)) {
            throw new DimensionsOutOfBoundsException("Z '" + z + "' greater than sizeZ '" + this.getSizeZ() + "'.");
        }
        if (c != null && (c > this.sizeC - 1 || c < 0)) {
            throw new DimensionsOutOfBoundsException("C '" + c + "' greater than sizeC '" + this.getSizeC() + "'.");
        }
        if (t != null && (t > this.sizeT - 1 || t < 0)) {
            throw new DimensionsOutOfBoundsException("T '" + t + "' greater than sizeT '" + this.getSizeT() + "'.");
        }
    }

    private void checkCubeBounds(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        if (offset.size() != 5 || size.size() != 5 || step.size() != 5) {
            throw new DimensionsOutOfBoundsException("Invalid List length: each list must contain 5 elements XYZCT");
        }
        this.checkBounds(offset.get(0), offset.get(1), offset.get(2), offset.get(3), offset.get(4));
        this.checkBounds(offset.get(0) + size.get(0) - 1, offset.get(1) + size.get(1) - 1, offset.get(2) + size.get(2) - 1, offset.get(3) + size.get(3) - 1, offset.get(4) + size.get(4) - 1);
        if (step.get(0) < 1 || step.get(1) < 1 || step.get(2) < 1 || step.get(3) < 1 || step.get(4) < 1) {
            throw new DimensionsOutOfBoundsException("Invalid step size: steps sizes must be 1 or greater");
        }
    }

    public void close() throws IOException {
    }

    public long getId() {
        return 0L;
    }

    public String getPath() {
        return this.path;
    }

    public int getSizeC() {
        return this.sizeC;
    }

    public int getSizeT() {
        return this.sizeT;
    }

    public int getSizeX() {
        return this.reader.getSizeX();
    }

    public int getSizeY() {
        return this.reader.getSizeY();
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public int getByteWidth() {
        return this.pixelSize;
    }

    public Integer getRowSize() {
        return this.getSizeX() * this.pixelSize;
    }

    public Integer getColSize() {
        return this.getSizeY() * this.pixelSize;
    }

    public Integer getPlaneSize() {
        return this.getSizeY() * this.getRowSize();
    }

    public Integer getStackSize() {
        return this.getSizeZ() * this.getPlaneSize();
    }

    public Integer getTimepointSize() {
        return this.getSizeC() * this.getStackSize();
    }

    public Integer getTotalSize() {
        return this.getSizeT() * this.getTimepointSize();
    }

    public Integer getHypercubeSize(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        this.checkCubeBounds(offset, size, step);
        int tStripes = (size.get(4) + step.get(4) - 1) / step.get(4);
        int cStripes = (size.get(3) + step.get(3) - 1) / step.get(3);
        int zStripes = (size.get(2) + step.get(2) - 1) / step.get(2);
        int yStripes = (size.get(1) + step.get(1) - 1) / step.get(1);
        int xStripes = (size.get(0) + step.get(0) - 1) / step.get(0);
        int tileRowSize = this.pixelSize * xStripes;
        int cubeSize = tileRowSize * yStripes * zStripes * cStripes * tStripes;
        return cubeSize;
    }

    public Long getRowOffset(Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, y, z, c, t);
        return this.getPlaneOffset(z, c, t) + (long)(y * this.getRowSize());
    }

    public Long getPlaneOffset(Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, z, c, t);
        return this.getStackOffset(c, t) + (long)(z * this.getPlaneSize());
    }

    public Long getStackOffset(Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, c, t);
        return this.getTimepointOffset(t) + (long)(c * this.getStackSize());
    }

    public Long getTimepointOffset(Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, null, t);
        return (long)t.intValue() * (long)this.getTimepointSize().intValue();
    }

    public byte[] getCol(Integer x, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(x, null, z, c, t);
        try {
            if (buffer.length != this.getColSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            byte[] plane = new byte[this.getPlaneSize().intValue()];
            this.getWholePlane(z, c, t, plane);
            for (int y = 0; y < this.reader.getSizeY(); ++y) {
                System.arraycopy(plane, y * this.getRowSize() + x * this.pixelSize, buffer, y * this.pixelSize, this.pixelSize);
            }
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getPlane(Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, null, z, c, t);
        try {
            if (buffer.length != this.getPlaneSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            this.getWholePlane(z, c, t, buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getPlaneRegion(Integer z, Integer c, Integer t, Integer count, Integer offset, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        return null;
    }

    public byte[] getRegion(Integer size, Long offset, byte[] buffer) throws IOException {
        return null;
    }

    public byte[] getRow(Integer y, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, y, z, c, t);
        try {
            if (buffer.length != this.getRowSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            byte[] plane = new byte[this.getPlaneSize().intValue()];
            this.getWholePlane(z, c, t, plane);
            System.arraycopy(plane, y * this.getRowSize(), buffer, 0, this.getRowSize());
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getStack(Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, c, t);
        try {
            if (buffer.length != this.getStackSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            byte[] plane = new byte[this.getPlaneSize().intValue()];
            for (int z = 0; z < this.sizeZ; ++z) {
                this.getWholePlane(z, c, t, plane);
                System.arraycopy(plane, 0, buffer, z * this.getPlaneSize(), this.getPlaneSize());
            }
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getTimepoint(Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, null, t);
        if (buffer.length != this.getTimepointSize()) {
            throw new RuntimeException("Buffer size incorrect.");
        }
        byte[] stack = new byte[this.getStackSize().intValue()];
        for (int c = 0; c < this.sizeC; ++c) {
            this.getStack(c, t, stack);
            System.arraycopy(stack, 0, buffer, c * this.getStackSize(), this.getStackSize());
        }
        return buffer;
    }

    public byte[] getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        if (buffer.length != this.getHypercubeSize(offset, size, step)) {
            throw new RuntimeException("Buffer size incorrect.");
        }
        try {
            this.getWholeHypercube(offset, size, step, buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getTile(int z, int c, int t, int x, int y, int w, int h, byte[] buffer) throws FormatException, IOException {
        return this.reader.openBytes(this.reader.getIndex(z, c, t), buffer, x, y, w, h);
    }

    private byte[] getWholePlane(int z, int c, int t, byte[] plane) throws IOException, FormatException {
        if (this.rgbChannels == 1) {
            int planeNumber = this.reader.getIndex(z, c, t);
            this.reader.openBytes(planeNumber, plane);
        } else {
            byte[] fullPlane = new byte[this.getPlaneSize() * this.rgbChannels];
            int planeNumber = this.reader.getIndex(z, 0, t);
            this.reader.openBytes(planeNumber, fullPlane);
            if (this.reader.isInterleaved()) {
                for (int p = 0; p < this.getPlaneSize(); p += this.pixelSize) {
                    System.arraycopy(fullPlane, c * this.pixelSize + p * this.rgbChannels, plane, p, this.pixelSize);
                }
            } else {
                System.arraycopy(fullPlane, c * this.getPlaneSize(), plane, 0, this.getPlaneSize());
            }
        }
        return plane;
    }

    private byte[] getWholeHypercube(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] cube) throws IOException, FormatException {
        int cubeOffset = 0;
        int xStripes = (size.get(0) + step.get(0) - 1) / step.get(0);
        int tileRowSize = this.pixelSize * xStripes;
        byte[] plane = new byte[this.getPlaneSize().intValue()];
        for (int t = offset.get(4).intValue(); t < size.get(4) + offset.get(4); t += step.get(4).intValue()) {
            for (int c = offset.get(3).intValue(); c < size.get(3) + offset.get(3); c += step.get(3).intValue()) {
                for (int z = offset.get(2).intValue(); z < size.get(2) + offset.get(2); z += step.get(2).intValue()) {
                    this.getWholePlane(z, c, t, plane);
                    int rowOffset = offset.get(1) * this.getRowSize();
                    if (step.get(0) == 1) {
                        int byteOffset = rowOffset + offset.get(0) * this.pixelSize;
                        for (int y = offset.get(1).intValue(); y < size.get(1) + offset.get(1); y += step.get(1).intValue()) {
                            System.arraycopy(plane, byteOffset, cube, cubeOffset, tileRowSize);
                            cubeOffset += tileRowSize;
                            byteOffset += this.getRowSize() * step.get(1);
                        }
                        continue;
                    }
                    for (int y = offset.get(1).intValue(); y < size.get(1) + offset.get(1); y += step.get(1).intValue()) {
                        int byteOffset = offset.get(0) * this.pixelSize;
                        for (int x = offset.get(0).intValue(); x < size.get(0) + offset.get(0); x += step.get(0).intValue()) {
                            System.arraycopy(plane, rowOffset + byteOffset, cube, cubeOffset, this.pixelSize);
                            cubeOffset += this.pixelSize;
                            byteOffset += step.get(0) * this.pixelSize;
                        }
                        rowOffset += this.getRowSize() * step.get(1);
                    }
                }
            }
        }
        return cube;
    }

    private int getBytesPerPixel() {
        switch (this.pixelType) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + this.pixelType + "'");
    }

    public String getPixelsType() {
        switch (this.pixelType) {
            case 0: {
                return "int8";
            }
            case 1: {
                return "uint8";
            }
            case 2: {
                return "int16";
            }
            case 3: {
                return "uint16";
            }
            case 4: {
                return "int32";
            }
            case 5: {
                return "uint32";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
        }
        throw new RuntimeException("Unknown type with id: '" + this.pixelType + "'");
    }

    public boolean isFloat() {
        switch (this.pixelType) {
            case 6: 
            case 7: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + this.pixelType + "'");
    }

    public boolean isSigned() {
        switch (this.pixelType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + this.pixelType + "'");
    }

    public byte[] swapIfRequired(byte[] bytes) throws FormatException, IOException {
        if (this.pixelSize == 1) {
            return bytes;
        }
        boolean isLittleEndian = this.reader.isLittleEndian();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        if (isLittleEndian) {
            if (this.pixelSize == 2) {
                ShortBuffer buf = buffer.asShortBuffer();
                int length = buffer.limit() / 2;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((short)buf.get(i)));
                }
            } else if (this.pixelSize == 4) {
                IntBuffer buf = buffer.asIntBuffer();
                int length = buffer.limit() / 4;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((int)buf.get(i)));
                }
            } else if (this.pixelSize == 8) {
                LongBuffer buf = buffer.asLongBuffer();
                int length = buffer.limit() / 8;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((long)buf.get(i)));
                }
            } else {
                throw new FormatException(String.format("Unsupported sample bit width: %d", this.pixelSize));
            }
        }
        bytes = buffer.array();
        return bytes;
    }
}

