/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.util;

import mpicbg.util.Util;

public class RealSum {
    protected boolean[] flags;
    protected double[] sums;

    public RealSum() {
        this.flags = new boolean[1];
        this.sums = new double[1];
    }

    public RealSum(int capacity) {
        int ldu = Util.ldu(capacity) + 1;
        this.flags = new boolean[ldu];
        this.sums = new double[ldu];
    }

    public final double getSum() {
        double sum = 0.0;
        double[] dArray = this.sums;
        int n = this.sums.length;
        int n2 = 0;
        while (n2 < n) {
            double s = dArray[n2];
            sum += s;
            ++n2;
        }
        return sum;
    }

    protected final void expand(double s) {
        double[] oldSums = this.sums;
        this.sums = new double[oldSums.length + 1];
        System.arraycopy(oldSums, 0, this.sums, 0, oldSums.length);
        this.sums[oldSums.length] = s;
        boolean[] oldFlags = this.flags;
        this.flags = new boolean[this.sums.length];
        System.arraycopy(oldFlags, 0, this.flags, 0, oldFlags.length);
        this.flags[oldSums.length] = true;
    }

    public final void add(double a) {
        int i = 0;
        double s = a;
        try {
            while (this.flags[i]) {
                this.flags[i] = false;
                s += this.sums[i];
                this.sums[i] = 0.0;
                ++i;
            }
            this.flags[i] = true;
            this.sums[i] = s;
            return;
        }
        catch (IndexOutOfBoundsException e) {
            this.expand(s);
            return;
        }
    }
}

