/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.util;

import mpicbg.models.NoninvertibleModelException;

public final class Matrix3x3 {
    public float m00 = 1.0f;
    public float m01 = 0.0f;
    public float m02 = 0.0f;
    public float m10 = 0.0f;
    public float m11 = 1.0f;
    public float m12 = 0.0f;
    public float m20 = 0.0f;
    public float m21 = 0.0f;
    public float m22 = 1.0f;

    public Matrix3x3() {
    }

    public Matrix3x3(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3x3(float[] m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m10 = m[3];
        this.m11 = m[4];
        this.m12 = m[5];
        this.m20 = m[6];
        this.m21 = m[7];
        this.m22 = m[8];
    }

    public final float det() {
        return this.m00 * this.m11 * this.m22 + this.m10 * this.m21 * this.m02 + this.m20 * this.m01 * this.m12 - this.m02 * this.m11 * this.m20 - this.m12 * this.m21 * this.m00 - this.m22 * this.m01 * this.m10;
    }

    public static final float det(float[] a) {
        assert (a.length == 9) : "Matrix3x3 supports 3x3 float[][] only.";
        return a[0] * a[4] * a[8] + a[3] * a[7] * a[2] + a[6] * a[1] * a[5] - a[2] * a[4] * a[6] - a[5] * a[7] * a[0] - a[8] * a[1] * a[3];
    }

    public static final float det(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return m00 * m11 * m22 + m10 * m21 * m02 + m20 * m01 * m12 - m02 * m11 * m20 - m12 * m21 * m00 - m22 * m01 * m10;
    }

    public final void invert() throws NoninvertibleModelException {
        float det = this.det();
        if (det == 0.0f) {
            throw new NoninvertibleModelException("Matrix not invertible.");
        }
        float i00 = (this.m11 * this.m22 - this.m12 * this.m21) / det;
        float i01 = (this.m02 * this.m21 - this.m01 * this.m22) / det;
        float i02 = (this.m01 * this.m12 - this.m02 * this.m11) / det;
        float i10 = (this.m12 * this.m20 - this.m10 * this.m22) / det;
        float i11 = (this.m00 * this.m22 - this.m02 * this.m20) / det;
        float i12 = (this.m02 * this.m10 - this.m00 * this.m12) / det;
        float i20 = (this.m10 * this.m21 - this.m11 * this.m20) / det;
        float i21 = (this.m01 * this.m20 - this.m00 * this.m21) / det;
        float i22 = (this.m00 * this.m11 - this.m01 * this.m10) / det;
        this.m00 = i00;
        this.m01 = i01;
        this.m02 = i02;
        this.m10 = i10;
        this.m11 = i11;
        this.m12 = i12;
        this.m20 = i20;
        this.m21 = i21;
        this.m22 = i22;
    }

    public static final void invert(float[] m) throws NoninvertibleModelException {
        assert (m.length == 9) : "Matrix3x3 supports 3x3 float[][] only.";
        float det = Matrix3x3.det(m);
        if (det == 0.0f) {
            throw new NoninvertibleModelException("Matrix not invertible.");
        }
        float i00 = (m[4] * m[8] - m[5] * m[7]) / det;
        float i01 = (m[2] * m[7] - m[1] * m[8]) / det;
        float i02 = (m[1] * m[5] - m[2] * m[4]) / det;
        float i10 = (m[5] * m[6] - m[3] * m[8]) / det;
        float i11 = (m[0] * m[8] - m[2] * m[6]) / det;
        float i12 = (m[2] * m[3] - m[0] * m[5]) / det;
        float i20 = (m[3] * m[7] - m[4] * m[6]) / det;
        float i21 = (m[1] * m[6] - m[0] * m[7]) / det;
        float i22 = (m[0] * m[4] - m[1] * m[3]) / det;
        m[0] = i00;
        m[1] = i01;
        m[2] = i02;
        m[3] = i10;
        m[4] = i11;
        m[5] = i12;
        m[6] = i20;
        m[7] = i21;
        m[8] = i22;
    }

    public static final float[] createInverse(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) throws NoninvertibleModelException {
        float det = Matrix3x3.det(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        if (det == 0.0f) {
            throw new NoninvertibleModelException("Matrix not invertible.");
        }
        return new float[]{(m11 * m22 - m12 * m21) / det, (m02 * m21 - m01 * m22) / det, (m01 * m12 - m02 * m11) / det, (m12 * m20 - m10 * m22) / det, (m00 * m22 - m02 * m20) / det, (m02 * m10 - m00 * m12) / det, (m10 * m21 - m11 * m20) / det, (m01 * m20 - m00 * m21) / det, (m00 * m11 - m01 * m10) / det};
    }

    public final void concatenate(Matrix3x3 m) {
        float a00 = this.m00 * m.m00 + this.m01 * m.m10 + this.m02 * m.m20;
        float a01 = this.m00 * m.m01 + this.m01 * m.m11 + this.m02 * m.m21;
        float a02 = this.m00 * m.m02 + this.m01 * m.m12 + this.m02 * m.m22;
        float a10 = this.m10 * m.m00 + this.m11 * m.m10 + this.m12 * m.m20;
        float a11 = this.m10 * m.m01 + this.m11 * m.m11 + this.m12 * m.m21;
        float a12 = this.m10 * m.m02 + this.m11 * m.m12 + this.m12 * m.m22;
        float a20 = this.m20 * m.m00 + this.m21 * m.m10 + this.m22 * m.m20;
        float a21 = this.m20 * m.m01 + this.m21 * m.m11 + this.m22 * m.m21;
        float a22 = this.m20 * m.m02 + this.m21 * m.m12 + this.m22 * m.m22;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
    }

    public final void preConcatenate(Matrix3x3 m) {
        float a00 = m.m00 * this.m00 + m.m01 * this.m10 + m.m02 * this.m20;
        float a01 = m.m00 * this.m01 + m.m01 * this.m11 + m.m02 * this.m21;
        float a02 = m.m00 * this.m02 + m.m01 * this.m12 + m.m02 * this.m22;
        float a10 = m.m10 * this.m00 + m.m11 * this.m10 + m.m12 * this.m20;
        float a11 = m.m10 * this.m01 + m.m11 * this.m11 + m.m12 * this.m21;
        float a12 = m.m10 * this.m02 + m.m11 * this.m12 + m.m12 * this.m22;
        float a20 = m.m20 * this.m00 + m.m21 * this.m10 + m.m22 * this.m20;
        float a21 = m.m20 * this.m01 + m.m21 * this.m11 + m.m22 * this.m21;
        float a22 = m.m20 * this.m02 + m.m21 * this.m12 + m.m22 * this.m22;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
    }

    public final void set(Matrix3x3 m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
    }

    public final void reset() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
    }

    public final Matrix3x3 clone() {
        return new Matrix3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }
}

