/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import mpicbg.models.Point;
import mpicbg.models.Spring;

public class Vertex
extends Point {
    private static final long serialVersionUID = 452481402612427648L;
    protected final HashMap<Vertex, Spring> springs = new HashMap();
    protected final float[] direction;
    protected float speed;
    private float forceSum;
    private final float[] force;
    private float forceAmplitude;

    public Collection<Spring> getSprings() {
        return this.springs.values();
    }

    public Set<Vertex> getConnectedVertices() {
        return this.springs.keySet();
    }

    public Spring getSpring(Vertex vertex) {
        return this.springs.get(vertex);
    }

    public void addSpring(Vertex v2, Spring spring) {
        this.springs.put(v2, spring);
        v2.springs.put(this, spring);
    }

    public void addSpring(Vertex v2, float[] weights) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weights));
    }

    public void addSpring(Vertex v2, float[] weights, float maxStretch) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weights, maxStretch));
    }

    public void addSpring(Vertex v2, float weight) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weight));
    }

    public void addSpring(Vertex v2, float weight, float maxStretch) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weight, maxStretch));
    }

    public float[] getDirection() {
        return this.direction;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getForceSum() {
        return this.forceSum;
    }

    public float[] getForces() {
        return this.force;
    }

    public float getForce() {
        return this.forceAmplitude;
    }

    public Vertex(float[] l) {
        super(l);
        this.direction = new float[l.length];
        this.force = new float[this.direction.length];
    }

    public Vertex(float[] l, float[] w) {
        super(l, w);
        this.direction = new float[l.length];
        this.force = new float[this.direction.length];
    }

    public Vertex(Point point) {
        this(point.getL(), point.getW());
    }

    public void update(float damp) {
        int i = 0;
        while (i < this.force.length) {
            this.force[i] = 0.0f;
            ++i;
        }
        this.forceSum = 0.0f;
        float[] f = new float[this.force.length];
        Set<Vertex> vertices = this.springs.keySet();
        for (Vertex vertex : vertices) {
            Spring spring = this.springs.get(vertex);
            spring.calculateForce(this, vertex, f);
            float fAmplitude = 0.0f;
            int i2 = 0;
            while (i2 < this.force.length) {
                int n = i2;
                this.force[n] = this.force[n] + f[i2];
                fAmplitude += f[i2] * f[i2];
                ++i2;
            }
            this.forceSum += (float)Math.sqrt(fAmplitude);
        }
        this.forceAmplitude = 0.0f;
        this.speed = 0.0f;
        int i3 = 0;
        while (i3 < this.force.length) {
            this.forceAmplitude += this.force[i3] * this.force[i3];
            int n = i3;
            this.direction[n] = this.direction[n] + this.force[i3];
            int n2 = i3;
            this.direction[n2] = this.direction[n2] * damp;
            this.speed += this.direction[i3] * this.direction[i3];
            ++i3;
        }
        this.forceAmplitude = (float)Math.sqrt(this.forceAmplitude);
        this.speed = (float)Math.sqrt(this.speed);
    }

    public final void move(float t) {
        int i = 0;
        while (i < this.w.length) {
            int n = i;
            this.w[n] = this.w[n] + t * this.direction[i];
            ++i;
        }
    }

    public final int traceConnectedGraph(Set<Vertex> graph) {
        graph.add(this);
        Set<Vertex> vertices = this.springs.keySet();
        for (Vertex vertex : vertices) {
            if (vertices.contains(vertex)) continue;
            vertex.traceConnectedGraph(graph);
        }
        return graph.size();
    }
}

