/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class TranslationModel3D
extends AbstractAffineModel3D<TranslationModel3D>
implements InvertibleBoundable {
    protected static final int MIN_NUM_MATCHES = 1;
    protected final float[] translation = new float[3];

    @Override
    public final int getMinNumMatches() {
        return 1;
    }

    public final float[] getTranslation() {
        return this.translation;
    }

    @Override
    public final float[] apply(float[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        return new float[]{point[0] + this.translation[0], point[1] + this.translation[1], point[2] + this.translation[2]};
    }

    @Override
    public final void applyInPlace(float[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        point[0] = point[0] + this.translation[0];
        point[1] = point[1] + this.translation[1];
        point[2] = point[2] + this.translation[2];
    }

    @Override
    public final float[] applyInverse(float[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        return new float[]{point[0] - this.translation[0], point[1] - this.translation[1], point[2] - this.translation[2]};
    }

    @Override
    public final void applyInverseInPlace(float[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        point[0] = point[0] - this.translation[0];
        point[1] = point[1] - this.translation[1];
        point[2] = point[2] - this.translation[2];
    }

    public final String toString() {
        return "[1,3](" + this.translation[0] + "," + this.translation[1] + "," + this.translation[2] + ") " + this.cost;
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 3d translation model, at least " + 1 + " data points required.");
        }
        float pcx = 0.0f;
        float pcy = 0.0f;
        float pcz = 0.0f;
        float qcx = 0.0f;
        float qcy = 0.0f;
        float qcz = 0.0f;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            float w = m.getWeight();
            ws += (double)w;
            pcx += w * p[0];
            pcy += w * p[1];
            pcz += w * p[2];
            qcx += w * q[0];
            qcy += w * q[1];
            qcz += w * q[2];
        }
        pcx = (float)((double)pcx / ws);
        pcy = (float)((double)pcy / ws);
        pcz = (float)((double)pcz / ws);
        qcx = (float)((double)qcx / ws);
        qcy = (float)((double)qcy / ws);
        qcz = (float)((double)qcz / ws);
        this.translation[0] = qcx - pcx;
        this.translation[1] = qcy - pcy;
        this.translation[2] = qcz - pcz;
    }

    public final void set(float tx, float ty, float tz) {
        this.translation[0] = tx;
        this.translation[1] = ty;
        this.translation[2] = tz;
    }

    @Override
    public final void set(TranslationModel3D m) {
        this.translation[0] = m.translation[0];
        this.translation[1] = m.translation[1];
        this.translation[2] = m.translation[2];
        this.cost = m.getCost();
    }

    @Override
    public TranslationModel3D copy() {
        TranslationModel3D m = new TranslationModel3D();
        m.translation[0] = this.translation[0];
        m.translation[1] = this.translation[1];
        m.translation[2] = this.translation[2];
        m.cost = this.cost;
        return m;
    }

    @Override
    public TranslationModel3D createInverse() {
        TranslationModel3D ict = new TranslationModel3D();
        ict.translation[0] = -this.translation[0];
        ict.translation[1] = -this.translation[1];
        ict.translation[2] = -this.translation[2];
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void estimateBounds(float[] min, float[] max) {
        this.applyInPlace(min);
        this.applyInPlace(max);
    }

    @Override
    public void estimateInverseBounds(float[] min, float[] max) throws NoninvertibleModelException {
        this.applyInverseInPlace(min);
        this.applyInverseInPlace(max);
    }

    @Override
    public void preConcatenate(TranslationModel3D model) {
        this.concatenate(model);
    }

    @Override
    public void concatenate(TranslationModel3D model) {
        this.translation[0] = this.translation[0] + model.translation[0];
        this.translation[1] = this.translation[1] + model.translation[1];
        this.translation[2] = this.translation[2] + model.translation[2];
    }

    @Override
    public void toArray(float[] data) {
        data[0] = 1.0f;
        data[1] = 0.0f;
        data[2] = 0.0f;
        data[3] = 0.0f;
        data[4] = 1.0f;
        data[5] = 0.0f;
        data[6] = 0.0f;
        data[7] = 0.0f;
        data[8] = 1.0f;
        data[9] = this.translation[0];
        data[10] = this.translation[1];
        data[11] = this.translation[2];
    }

    @Override
    public void toArray(double[] data) {
        data[0] = 1.0;
        data[1] = 0.0;
        data[2] = 0.0;
        data[3] = 0.0;
        data[4] = 1.0;
        data[5] = 0.0;
        data[6] = 0.0;
        data[7] = 0.0;
        data[8] = 1.0;
        data[9] = this.translation[0];
        data[10] = this.translation[1];
        data[11] = this.translation[2];
    }

    @Override
    public float[] getMatrix(float[] m) {
        float[] a = m == null || m.length != 12 ? new float[12] : m;
        a[0] = 1.0f;
        a[1] = 0.0f;
        a[2] = 0.0f;
        a[3] = this.translation[0];
        a[4] = 0.0f;
        a[5] = 1.0f;
        a[6] = 0.0f;
        a[7] = this.translation[1];
        a[8] = 0.0f;
        a[9] = 0.0f;
        a[10] = 1.0f;
        a[11] = this.translation[2];
        return a;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = 1.0f;
        data[0][1] = 0.0f;
        data[0][2] = 0.0f;
        data[0][3] = this.translation[0];
        data[1][0] = 0.0f;
        data[1][1] = 1.0f;
        data[1][2] = 0.0f;
        data[1][3] = this.translation[1];
        data[2][0] = 0.0f;
        data[2][1] = 0.0f;
        data[2][2] = 1.0f;
        data[2][3] = this.translation[2];
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = 1.0;
        data[0][1] = 0.0;
        data[0][2] = 0.0;
        data[0][3] = this.translation[0];
        data[1][0] = 0.0;
        data[1][1] = 1.0;
        data[1][2] = 0.0;
        data[1][3] = this.translation[1];
        data[2][0] = 0.0;
        data[2][1] = 0.0;
        data[2][2] = 1.0;
        data[2][3] = this.translation[2];
    }
}

