/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class TranslationModel2D
extends AbstractAffineModel2D<TranslationModel2D> {
    protected static final int MIN_NUM_MATCHES = 1;
    protected float tx = 0.0f;
    protected float ty = 0.0f;

    @Override
    public final int getMinNumMatches() {
        return 1;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, this.tx, this.ty);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -this.tx, -this.ty);
    }

    @Override
    public final float[] apply(float[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        return new float[]{l[0] + this.tx, l[1] + this.ty};
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        l[0] = l[0] + this.tx;
        l[1] = l[1] + this.ty;
    }

    @Override
    public final float[] applyInverse(float[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        return new float[]{l[0] - this.tx, l[1] - this.ty};
    }

    @Override
    public final void applyInverseInPlace(float[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        l[0] = l[0] - this.tx;
        l[1] = l[1] - this.ty;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d translations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 1) {
            throw new NotEnoughDataPointsException(String.valueOf(l) + " data points are not enough to estimate a 2d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        int i = 0;
        while (i < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
            ++i;
        }
        this.tx = (float)((qcx /= ws) - (pcx /= ws));
        this.ty = (float)((qcy /= ws) - (pcy /= ws));
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 2d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * (double)p[0];
            pcy += w * (double)p[1];
            qcx += w * (double)q[0];
            qcy += w * (double)q[1];
        }
        this.tx = (float)((qcx /= ws) - (pcx /= ws));
        this.ty = (float)((qcy /= ws) - (pcy /= ws));
    }

    @Override
    public TranslationModel2D copy() {
        TranslationModel2D m = new TranslationModel2D();
        m.tx = this.tx;
        m.ty = this.ty;
        m.cost = this.cost;
        return m;
    }

    @Override
    public final void set(TranslationModel2D m) {
        this.tx = m.tx;
        this.ty = m.ty;
        this.cost = m.getCost();
    }

    @Override
    public final void preConcatenate(TranslationModel2D m) {
        this.tx += m.tx;
        this.ty += m.ty;
    }

    @Override
    public final void concatenate(TranslationModel2D m) {
        this.tx += m.tx;
        this.ty += m.ty;
    }

    public final void set(float tx, float ty) {
        this.tx = tx;
        this.ty = ty;
    }

    @Override
    public TranslationModel2D createInverse() {
        TranslationModel2D ict = new TranslationModel2D();
        ict.tx = -this.tx;
        ict.ty = -this.ty;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(float[] data) {
        data[0] = 1.0f;
        data[1] = 0.0f;
        data[2] = 0.0f;
        data[3] = 1.0f;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = 1.0;
        data[1] = 0.0;
        data[2] = 0.0;
        data[3] = 1.0;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = 1.0f;
        data[0][1] = 0.0f;
        data[0][2] = this.tx;
        data[1][0] = 0.0f;
        data[1][1] = 1.0f;
        data[1][1] = this.ty;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = 1.0;
        data[0][1] = 0.0;
        data[0][2] = this.tx;
        data[1][0] = 0.0;
        data[1][1] = 1.0;
        data[1][1] = this.ty;
    }
}

