/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractAffineModel1D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class TranslationModel1D
extends AbstractAffineModel1D<TranslationModel1D> {
    protected static final int MIN_NUM_MATCHES = 1;
    protected float t = 0.0f;

    public final float getTranslation() {
        return this.t;
    }

    @Override
    public final int getMinNumMatches() {
        return 1;
    }

    @Override
    public final float[] apply(float[] l) {
        assert (l.length >= 1) : "1d translation transformations can be applied to 1d points only.";
        return new float[]{l[0] + this.t};
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 1) : "1d translation transformations can be applied to 1d points only.";
        l[0] = l[0] + this.t;
    }

    @Override
    public final float[] applyInverse(float[] l) {
        assert (l.length >= 1) : "1d translation transformations can be applied to 1d points only.";
        return new float[]{l[0] - this.t};
    }

    @Override
    public final void applyInverseInPlace(float[] l) {
        assert (l.length >= 1) : "1d translation transformations can be applied to 1d points only.";
        l[0] = l[0] - this.t;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 1 && q.length >= 1) : "1d translations can be applied to 1d points only.";
        assert (p[0].length == q[0].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 1) {
            throw new NotEnoughDataPointsException(String.valueOf(l) + " data points are not enough to estimate a 1d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double qcx = 0.0;
        double ws = 0.0;
        int i = 0;
        while (i < l) {
            float[] pX = p[0];
            float[] qX = q[0];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            qcx += ww * (double)qX[i];
            ++i;
        }
        this.t = (float)((qcx /= ws) - (pcx /= ws));
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 1d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double qcx = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * (double)p[0];
            qcx += w * (double)q[0];
        }
        this.t = (float)((qcx /= ws) - (pcx /= ws));
    }

    @Override
    public TranslationModel1D copy() {
        TranslationModel1D m = new TranslationModel1D();
        m.t = this.t;
        m.cost = this.cost;
        return m;
    }

    @Override
    public final void set(TranslationModel1D m) {
        this.t = m.t;
        this.cost = m.getCost();
    }

    @Override
    public final void preConcatenate(TranslationModel1D m) {
        this.t += m.t;
    }

    @Override
    public final void concatenate(TranslationModel1D m) {
        this.t += m.t;
    }

    @Override
    public final void set(float t) {
        this.t = t;
    }

    @Override
    public TranslationModel1D createInverse() {
        TranslationModel1D ict = new TranslationModel1D();
        ict.t = -this.t;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(float[] data) {
        data[0] = 1.0f;
        data[1] = this.t;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = 1.0;
        data[1] = this.t;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = 1.0f;
        data[0][1] = this.t;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = 1.0;
        data[0][1] = this.t;
    }

    @Override
    public float[] getMatrix(float[] m) {
        float[] a = m == null || m.length != 2 ? new float[2] : m;
        a[0] = 1.0f;
        a[1] = this.t;
        return a;
    }
}

