/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.Set;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransformMap2D;
import mpicbg.models.PointMatch;
import mpicbg.models.TransformMesh;

public class TransformMeshMap2D
extends CoordinateTransformMap2D {
    public TransformMeshMap2D(TransformMesh t, int width, int height) {
        super(new float[height][width * 2]);
        float[] min = new float[2];
        float[] max = new float[2];
        float[] l = new float[2];
        int y = 0;
        while (y < this.map.length) {
            int x = 0;
            while (x < this.map[y].length) {
                this.map[y][x] = Float.NaN;
                ++x;
            }
            ++y;
        }
        Set<AffineModel2D> s = t.getAV().keySet();
        for (AffineModel2D ai : s) {
            ArrayList<PointMatch> pm = t.getAV().get(ai);
            TransformMeshMap2D.calculateBoundingBoxInverse(pm, min, max);
            int y2 = (int)min[1];
            while ((float)y2 <= max[1]) {
                if (y2 >= 0 && y2 < this.map.length) {
                    int x = (int)min[0];
                    while ((float)x <= max[0]) {
                        int xi = 2 * x;
                        if (x >= 0 && xi < this.map[y2].length) {
                            l[0] = x;
                            l[1] = y2;
                            if (TransformMesh.isInSourcePolygon(pm, l)) {
                                ai.applyInPlace(l);
                                this.map[y2][xi] = l[0];
                                this.map[y2][xi + 1] = l[1];
                            }
                        }
                        ++x;
                    }
                }
                ++y2;
            }
        }
    }

    private static final void calculateBoundingBoxInverse(ArrayList<PointMatch> pm, float[] min, float[] max) {
        float[] first = pm.get(0).getP1().getL();
        min[0] = first[0];
        min[1] = first[1];
        max[0] = first[0];
        max[1] = first[1];
        for (PointMatch p : pm) {
            float[] t = p.getP1().getL();
            if (t[0] < min[0]) {
                min[0] = t[0];
            } else if (t[0] > max[0]) {
                max[0] = t[0];
            }
            if (t[1] < min[1]) {
                min[1] = t[1];
                continue;
            }
            if (!(t[1] > max[1])) continue;
            max[1] = t[1];
        }
    }
}

