/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.util.Util;

public class TransformMesh
implements InvertibleCoordinateTransform {
    protected final float width;
    protected final float height;
    protected final HashMap<AffineModel2D, ArrayList<PointMatch>> av = new HashMap();
    protected final HashMap<PointMatch, ArrayList<AffineModel2D>> va = new HashMap();

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public HashMap<AffineModel2D, ArrayList<PointMatch>> getAV() {
        return this.av;
    }

    public HashMap<PointMatch, ArrayList<AffineModel2D>> getVA() {
        return this.va;
    }

    public TransformMesh(int numX, int numY, float width, float height) {
        int numXs = Math.max(2, numX);
        int numYs = Math.max(2, numY);
        float w = width * height / (float)numXs / (float)numYs;
        PointMatch[] pq = new PointMatch[numXs * numYs + (numXs - 1) * (numYs - 1)];
        this.width = width;
        this.height = height;
        float dy = (height - 1.0f) / (float)(numYs - 1);
        float dx = (width - 1.0f) / (float)(numXs - 1);
        int i = 0;
        int xi = 0;
        while (xi < numXs) {
            float xip = (float)xi * dx;
            Point p = new Point(new float[]{xip, 0.0f});
            pq[i] = new PointMatch(p, p.clone());
            ++i;
            ++xi;
        }
        int yi = 1;
        while (yi < numYs) {
            ArrayList<PointMatch> t2;
            int i3;
            float xip;
            float yip = (float)yi * dy - dy / 2.0f;
            Point p = new Point(new float[]{dx - dx / 2.0f, yip});
            pq[i] = new PointMatch(p, p.clone(), w);
            int i1 = i - numXs;
            int i2 = i1 + 1;
            ArrayList<PointMatch> t1 = new ArrayList<PointMatch>();
            t1.add(pq[i1]);
            t1.add(pq[i2]);
            t1.add(pq[i]);
            this.addTriangle(t1);
            ++i;
            int xi2 = 2;
            while (xi2 < numXs) {
                xip = (float)xi2 * dx - dx / 2.0f;
                p = new Point(new float[]{xip, yip});
                pq[i] = new PointMatch(p, p.clone(), w);
                i1 = i - numXs;
                i2 = i1 + 1;
                i3 = i - 1;
                t1 = new ArrayList();
                t1.add(pq[i1]);
                t1.add(pq[i2]);
                t1.add(pq[i]);
                this.addTriangle(t1);
                t2 = new ArrayList<PointMatch>();
                t2.add(pq[i1]);
                t2.add(pq[i]);
                t2.add(pq[i3]);
                this.addTriangle(t2);
                ++i;
                ++xi2;
            }
            yip = (float)yi * dy;
            p = new Point(new float[]{0.0f, yip});
            pq[i] = new PointMatch(p, p.clone(), w);
            i1 = i - numXs + 1;
            i2 = i1 - numXs;
            t1 = new ArrayList();
            t1.add(pq[i2]);
            t1.add(pq[i1]);
            t1.add(pq[i]);
            this.addTriangle(t1);
            ++i;
            xi2 = 1;
            while (xi2 < numXs - 1) {
                xip = (float)xi2 * dx;
                p = new Point(new float[]{xip, yip});
                pq[i] = new PointMatch(p, p.clone(), w);
                i1 = i - numXs;
                i2 = i1 + 1;
                i3 = i - 1;
                t1 = new ArrayList();
                t1.add(pq[i1]);
                t1.add(pq[i]);
                t1.add(pq[i3]);
                this.addTriangle(t1);
                t2 = new ArrayList();
                t2.add(pq[i1]);
                t2.add(pq[i2]);
                t2.add(pq[i]);
                this.addTriangle(t2);
                ++i;
                ++xi2;
            }
            p = new Point(new float[]{width - 1.0f, yip});
            pq[i] = new PointMatch(p, p.clone(), w);
            i1 = i - numXs;
            i2 = i1 - numXs + 1;
            i3 = i - 1;
            t1 = new ArrayList();
            t1.add(pq[i3]);
            t1.add(pq[i1]);
            t1.add(pq[i]);
            this.addTriangle(t1);
            t2 = new ArrayList();
            t2.add(pq[i1]);
            t2.add(pq[i2]);
            t2.add(pq[i]);
            this.addTriangle(t2);
            ++i;
            ++yi;
        }
    }

    protected static final int numY(int numX, float width, float height) {
        int numXs = Math.max(2, numX);
        float dx = width / (float)(numXs - 1);
        float dy = 2.0f * (float)Math.sqrt(0.75f * dx * dx);
        return Math.max(2, Util.roundPos(height / dy) + 1);
    }

    public TransformMesh(int numX, float width, float height) {
        this(numX, TransformMesh.numY(numX, width, height), width, height);
    }

    public void addTriangle(ArrayList<PointMatch> t) {
        AffineModel2D m = new AffineModel2D();
        try {
            m.fit(t);
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace();
        }
        catch (IllDefinedDataPointsException e) {
            e.printStackTrace();
        }
        this.av.put(m, t);
        for (PointMatch pm : t) {
            if (!this.va.containsKey(pm)) {
                this.va.put(pm, new ArrayList());
            }
            this.va.get(pm).add(m);
        }
    }

    protected void illustrateTriangle(AffineModel2D ai, GeneralPath path) {
        ArrayList<PointMatch> m = this.av.get(ai);
        float[] w = m.get(0).getP2().getW();
        path.moveTo(w[0], w[1]);
        int i = 1;
        while (i < m.size()) {
            float[] wi = m.get(i).getP2().getW();
            path.lineTo(wi[0], wi[1]);
            ++i;
        }
        path.closePath();
    }

    public Shape illustrateMesh() {
        GeneralPath path = new GeneralPath();
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            this.illustrateTriangle(ai, path);
        }
        return path;
    }

    private String illustrateTriangleSVG(AffineModel2D ai) {
        String svg = "";
        ArrayList<PointMatch> m = this.av.get(ai);
        float[] w = m.get(0).getP2().getW();
        svg = String.valueOf(svg) + "M " + w[0] + " " + w[1] + " ";
        int i = 1;
        while (i < m.size()) {
            float[] wi = m.get(i).getP2().getW();
            svg = String.valueOf(svg) + "L " + wi[0] + " " + wi[1] + " ";
            ++i;
        }
        svg = String.valueOf(svg) + "Z ";
        return svg;
    }

    public String illustrateMeshSVG() {
        String svg = "<path style=\"fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" d=\"";
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            svg = String.valueOf(svg) + this.illustrateTriangleSVG(ai);
        }
        svg = String.valueOf(svg) + "\" />";
        return svg;
    }

    public String illustrateBestRigidSVG() {
        String svg = "<path style=\"fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" d=\"";
        Set<PointMatch> s = this.va.keySet();
        RigidModel2D m = new RigidModel2D();
        try {
            m.fit(s);
        }
        catch (NotEnoughDataPointsException ex) {
            ex.printStackTrace();
            return "";
        }
        float[] l = new float[]{0.0f, 0.0f};
        m.applyInPlace(l);
        svg = String.valueOf(svg) + "M " + l[0] + " " + l[1] + " ";
        l[0] = this.width;
        l[1] = 0.0f;
        m.applyInPlace(l);
        svg = String.valueOf(svg) + "L " + l[0] + " " + l[1] + " ";
        l[0] = this.width;
        l[1] = this.height;
        m.applyInPlace(l);
        svg = String.valueOf(svg) + "L " + l[0] + " " + l[1] + " ";
        l[0] = 0.0f;
        l[1] = this.height;
        m.applyInPlace(l);
        svg = String.valueOf(svg) + "L " + l[0] + " " + l[1] + " ";
        svg = String.valueOf(svg) + "Z";
        svg = String.valueOf(svg) + "\" />";
        return svg;
    }

    public void updateAffine(PointMatch p) {
        for (AffineModel2D ai : this.va.get(p)) {
            try {
                ai.fit((Collection)this.av.get(ai));
            }
            catch (NotEnoughDataPointsException e) {
                e.printStackTrace();
            }
            catch (IllDefinedDataPointsException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateAffines() {
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            try {
                ai.fit((Collection)this.av.get(ai));
            }
            catch (NotEnoughDataPointsException e) {
                e.printStackTrace();
            }
            catch (IllDefinedDataPointsException e) {
                e.printStackTrace();
            }
        }
    }

    public PointMatch findClosestSourcePoint(float[] there) {
        Set<PointMatch> points = this.va.keySet();
        PointMatch closest = null;
        float cd = Float.MAX_VALUE;
        for (PointMatch m : points) {
            float dy;
            float[] here = m.getP1().getL();
            float dx = here[0] - there[0];
            float d = dx * dx + (dy = here[1] - there[1]) * dy;
            if (!(d < cd)) continue;
            cd = d;
            closest = m;
        }
        return closest;
    }

    public PointMatch findClosestTargetPoint(float[] there) {
        Set<PointMatch> points = this.va.keySet();
        PointMatch closest = null;
        float cd = Float.MAX_VALUE;
        for (PointMatch m : points) {
            float dy;
            float[] here = m.getP2().getW();
            float dx = here[0] - there[0];
            float d = dx * dx + (dy = here[1] - there[1]) * dy;
            if (!(d < cd)) continue;
            cd = d;
            closest = m;
        }
        return closest;
    }

    public static boolean isInConvexTargetPolygon(ArrayList<PointMatch> pm, float[] t) {
        assert (t.length == 2) : "2d transform meshs can be applied to 2d points only.";
        int i = 0;
        while (i < pm.size()) {
            float x2;
            float y1;
            float y2;
            PointMatch r1 = pm.get(i);
            PointMatch r2 = pm.get((i + 1) % pm.size());
            float[] t1 = r1.getP2().getW();
            float[] t2 = r2.getP2().getW();
            float x1 = t2[0] - t1[0];
            if (x1 * (y2 = t[1] - t1[1]) - (y1 = t2[1] - t1[1]) * (x2 = t[0] - t1[0]) < 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isInSourcePolygon(ArrayList<PointMatch> pm, float[] t) {
        assert (t.length == 2) : "2d transform meshs can be applied to 2d points only.";
        int i = 0;
        while (i < pm.size()) {
            float x2;
            float y1;
            float y2;
            PointMatch r1 = pm.get(i);
            PointMatch r2 = pm.get((i + 1) % pm.size());
            float[] t1 = r1.getP1().getL();
            float[] t2 = r2.getP1().getL();
            float x1 = t2[0] - t1[0];
            if (x1 * (y2 = t[1] - t1[1]) - (y1 = t2[1] - t1[1]) * (x2 = t[0] - t1[0]) < 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public float[] apply(float[] location) {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        float[] transformed = (float[])location.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public void applyInPlace(float[] location) {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            ArrayList<PointMatch> pm = this.av.get(ai);
            if (!TransformMesh.isInSourcePolygon(pm, location)) continue;
            ai.applyInPlace(location);
            return;
        }
    }

    @Override
    public float[] applyInverse(float[] location) throws NoninvertibleModelException {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        float[] transformed = (float[])location.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public void applyInverseInPlace(float[] location) throws NoninvertibleModelException {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            ArrayList<PointMatch> pm = this.av.get(ai);
            if (!TransformMesh.isInConvexTargetPolygon(pm, location)) continue;
            ai.applyInverseInPlace(location);
            return;
        }
        throw new NoninvertibleModelException("Noninvertible location ( " + location[0] + ", " + location[1] + " )");
    }

    @Override
    public TransformMesh createInverse() {
        TransformMesh ict = new TransformMesh(0, 0, this.width, this.height);
        Set<PointMatch> v = this.va.keySet();
        HashMap<PointMatch, PointMatch> vv = new HashMap<PointMatch, PointMatch>();
        for (PointMatch pointMatch : v) {
            float[] l = pointMatch.getP1().getL();
            float[] w = pointMatch.getP2().getW();
            Point pi1 = new Point((float[])w.clone());
            Point pi2 = new Point((float[])w.clone());
            float[] pi2w = pi2.getW();
            int i = 0;
            while (i < pi2w.length) {
                pi2w[i] = l[i];
                ++i;
            }
            PointMatch pim = new PointMatch(pi1, pi2);
            vv.put(pointMatch, pim);
        }
        ict.va.clear();
        ict.av.clear();
        for (Map.Entry entry : vv.entrySet()) {
            ict.va.put((PointMatch)entry.getValue(), new ArrayList());
        }
        for (Map.Entry entry : this.av.entrySet()) {
            ArrayList<PointMatch> pm = new ArrayList<PointMatch>();
            AffineModel2D a = new AffineModel2D();
            for (PointMatch p : (ArrayList)entry.getValue()) {
                PointMatch q = (PointMatch)vv.get(p);
                this.va.get(q).add(a);
                pm.add(q);
            }
            ict.av.put(a, pm);
        }
        ict.updateAffines();
        return ict;
    }

    public void init(CoordinateTransform t) {
        Set<PointMatch> vertices = this.va.keySet();
        for (PointMatch vertex : vertices) {
            vertex.getP2().apply(t);
        }
        this.updateAffines();
    }

    public void scale(float scale) {
        for (PointMatch m : this.va.keySet()) {
            Point p1 = m.getP1();
            Point p2 = m.getP2();
            float[] l1 = p1.getL();
            float[] w1 = p1.getW();
            float[] l2 = p2.getL();
            float[] w2 = p2.getW();
            int i = 0;
            while (i < l1.length) {
                int n = i;
                l1[n] = l1[n] * scale;
                int n2 = i;
                w1[n2] = w1[n2] * scale;
                int n3 = i;
                l2[n3] = l2[n3] * scale;
                int n4 = i++;
                w2[n4] = w2[n4] * scale;
            }
            this.updateAffines();
        }
    }

    public void bounds(float[] min, float[] max) {
        min[1] = Float.MAX_VALUE;
        min[0] = Float.MAX_VALUE;
        max[1] = -3.4028235E38f;
        max[0] = -3.4028235E38f;
        Set<PointMatch> vertices = this.va.keySet();
        for (PointMatch vertex : vertices) {
            float[] w = vertex.getP2().getW();
            if (w[0] < min[0]) {
                min[0] = w[0];
            }
            if (w[0] > max[0]) {
                max[0] = w[0];
            }
            if (w[1] < min[1]) {
                min[1] = w[1];
            }
            if (!(w[1] > max[1])) continue;
            max[1] = w[1];
        }
    }
}

