/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.util.RealSum;

public class TileConfiguration {
    protected static final DecimalFormat decimalFormat = new DecimalFormat();
    protected static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    protected final HashSet<Tile<?>> tiles = new HashSet();
    protected final HashSet<Tile<?>> fixedTiles = new HashSet();
    protected double minError = Double.MAX_VALUE;
    protected double maxError = 0.0;
    protected double error = Double.MAX_VALUE;

    public final HashSet<Tile<?>> getTiles() {
        return this.tiles;
    }

    public final HashSet<Tile<?>> getFixedTiles() {
        return this.fixedTiles;
    }

    public final double getMinError() {
        return this.minError;
    }

    public final double getMaxError() {
        return this.maxError;
    }

    public final double getError() {
        return this.error;
    }

    public TileConfiguration() {
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
    }

    protected void println(String s) {
        System.out.println(s);
    }

    public void clear() {
        this.tiles.clear();
        this.fixedTiles.clear();
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        this.error = Double.MAX_VALUE;
    }

    public void addTile(Tile<?> t) {
        this.tiles.add(t);
    }

    public void addTiles(Collection<? extends Tile<?>> t) {
        this.tiles.addAll(t);
    }

    public void addTiles(TileConfiguration t) {
        this.tiles.addAll(t.tiles);
    }

    public void fixTile(Tile<?> t) {
        this.fixedTiles.add(t);
    }

    protected void apply() {
        for (Tile<?> t : this.tiles) {
            t.apply();
        }
    }

    protected void updateErrors() {
        double cd = 0.0;
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        for (Tile<?> t : this.tiles) {
            t.updateCost();
            double d = t.getDistance();
            if (d < this.minError) {
                this.minError = d;
            }
            if (d > this.maxError) {
                this.maxError = d;
            }
            cd += d;
        }
        this.error = cd /= (double)this.tiles.size();
    }

    protected void update() {
        double cd = 0.0;
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        for (Tile<?> t : this.tiles) {
            t.update();
            double d = t.getDistance();
            if (d < this.minError) {
                this.minError = d;
            }
            if (d > this.maxError) {
                this.maxError = d;
            }
            cd += d;
        }
        this.error = cd /= (double)this.tiles.size();
    }

    public void optimizeSilently(ErrorStatistic observer, float maxAllowedError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int i = 0;
        boolean proceed = i < maxIterations;
        this.apply();
        while (proceed) {
            for (Tile<?> tile : this.tiles) {
                if (this.fixedTiles.contains(tile)) continue;
                tile.fitModel();
                tile.apply();
            }
            this.updateErrors();
            observer.add(this.error);
            if (i > maxPlateauwidth) {
                proceed = this.error > (double)maxAllowedError;
                int d = maxPlateauwidth;
                while (!proceed && d >= 1) {
                    try {
                        proceed |= Math.abs(observer.getWideSlope(d)) > 1.0E-4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    d /= 2;
                }
            }
            proceed &= ++i < maxIterations;
        }
    }

    public void optimize(float maxAllowedError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        this.optimize(observer, maxAllowedError, maxIterations, maxPlateauwidth);
    }

    public void optimize(ErrorStatistic observer, float maxAllowedError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.println("Optimizing...");
        this.optimizeSilently(observer, maxAllowedError, maxIterations, maxPlateauwidth);
        this.println(new StringBuffer("Successfully optimized configuration of ").append(this.tiles.size()).append(" tiles after ").append(observer.n()).append(" iterations:").toString());
        this.println(new StringBuffer("  average displacement: ").append(decimalFormat.format(this.error)).append("px").toString());
        this.println(new StringBuffer("  minimal displacement: ").append(decimalFormat.format(this.minError)).append("px").toString());
        this.println(new StringBuffer("  maximal displacement: ").append(decimalFormat.format(this.maxError)).append("px").toString());
    }

    public void optimizeAndFilter(float maxAllowedError, int maxIterations, int maxPlateauwidth, float maxMeanFactor) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        boolean proceed = true;
        block0: while (proceed) {
            ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
            this.optimize(observer, maxAllowedError, maxIterations, maxPlateauwidth);
            RealSum sum = new RealSum();
            RealSum weights = new RealSum();
            float dMax = 0.0f;
            for (Tile<?> t : this.tiles) {
                t.update();
            }
            for (Tile<?> t : this.tiles) {
                for (PointMatch p : t.getMatches()) {
                    float d = p.getDistance();
                    float w = p.getWeight();
                    sum.add(d * w);
                    weights.add(w);
                    if (!(d > dMax)) continue;
                    dMax = d;
                }
            }
            this.println("Filter outliers...");
            if ((double)dMax > (double)maxMeanFactor * sum.getSum() / weights.getSum()) {
                for (Tile<?> t : this.tiles) {
                    for (PointMatch p : t.getMatches()) {
                        if (!(p.getDistance() >= dMax)) continue;
                        Tile<?> o = t.findConnectedTile(p);
                        t.removeConnectedTile(o);
                        o.removeConnectedTile(t);
                        this.println("Removing bad tile connection from configuration, error = " + dMax);
                        continue block0;
                    }
                }
                continue;
            }
            proceed = false;
        }
    }

    public List<Tile<?>> preAlign() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        ArrayList unAlignedTiles = new ArrayList();
        ArrayList alignedTiles = new ArrayList();
        if (this.getFixedTiles().size() == 0) {
            Iterator<Tile<?>> it = this.getTiles().iterator();
            alignedTiles.add(it.next());
            while (it.hasNext()) {
                unAlignedTiles.add(it.next());
            }
        } else {
            for (Tile<?> tile : this.getTiles()) {
                if (this.getFixedTiles().contains(tile)) {
                    alignedTiles.add(tile);
                    continue;
                }
                unAlignedTiles.add(tile);
            }
        }
        ListIterator<Tile<?>> referenceIterator = alignedTiles.listIterator();
        while (referenceIterator.hasNext()) {
            if (unAlignedTiles.size() == 0) break;
            Tile referenceTile = (Tile)referenceIterator.next();
            referenceTile.apply();
            ListIterator<Tile<?>> targetIterator = unAlignedTiles.listIterator();
            while (targetIterator.hasNext()) {
                ArrayList<PointMatch> pm;
                Tile<?> targetTile = targetIterator.next();
                if (!referenceTile.getConnectedTiles().contains(targetTile) || (pm = this.getConnectingPointMatches(targetTile, referenceTile)).size() <= ((Model)targetTile.getModel()).getMinNumMatches()) continue;
                ((Model)targetTile.getModel()).fit(pm);
                targetIterator.remove();
                int countFwd = 0;
                while (referenceIterator.hasNext()) {
                    referenceIterator.next();
                    ++countFwd;
                }
                referenceIterator.add(targetTile);
                int j = 0;
                while (j < countFwd + 1) {
                    referenceIterator.previous();
                    ++j;
                }
            }
        }
        return unAlignedTiles;
    }

    public ArrayList<PointMatch> getConnectingPointMatches(Tile<?> targetTile, Tile<?> referenceTile) {
        Set<PointMatch> referenceMatches = referenceTile.getMatches();
        ArrayList<Point> referencePoints = new ArrayList<Point>(referenceMatches.size());
        for (PointMatch pm : referenceMatches) {
            referencePoints.add(pm.getP1());
        }
        ArrayList<PointMatch> connectedPointMatches = new ArrayList<PointMatch>();
        for (PointMatch pm : targetTile.getMatches()) {
            if (!referencePoints.contains(pm.getP2())) continue;
            connectedPointMatches.add(pm);
        }
        return connectedPointMatches;
    }
}

