/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Spring;
import mpicbg.models.TransformMesh;
import mpicbg.models.Vertex;
import mpicbg.util.Util;

public class SpringMesh
extends TransformMesh {
    private static final int VIS_SIZE = 512;
    protected final HashSet<Vertex> fixedVertices = new HashSet();
    protected final HashSet<Vertex> vertices = new HashSet();
    protected final HashMap<Vertex, PointMatch> vp = new HashMap();
    protected final HashMap<PointMatch, Vertex> pv = new HashMap();
    protected final HashMap<AffineModel2D, Vertex> apv = new HashMap();
    protected final HashMap<Vertex, AffineModel2D> pva = new HashMap();
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    protected double force = 0.0;
    protected double minForce = Double.MAX_VALUE;
    protected double maxForce = 0.0;
    protected double maxSpeed = 0.0;
    protected float damp;

    public Set<Vertex> getVertices() {
        return this.vertices;
    }

    public int numVertices() {
        return this.pv.size();
    }

    public double getForce() {
        return this.force;
    }

    public SpringMesh(int numX, int numY, float width, float height, float springWeight, float maxStretch, float damp) {
        super(numX, numY, width, height);
        this.damp = damp;
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
        Set s = this.va.keySet();
        for (PointMatch p : s) {
            Vertex vertex = new Vertex(p.getP2());
            this.vp.put(vertex, p);
            this.pv.put(p, vertex);
            this.vertices.add(vertex);
        }
        for (Vertex vertex : this.vertices) {
            PointMatch p = this.vp.get(vertex);
            for (AffineModel2D ai : (ArrayList)this.va.get(p)) {
                Set<Vertex> connectedVertices = vertex.getConnectedVertices();
                for (PointMatch m : (ArrayList)this.av.get(ai)) {
                    Vertex connectedVertex = this.pv.get(m);
                    if (p == m || connectedVertices.contains(connectedVertex)) continue;
                    vertex.addSpring(connectedVertex, springWeight, maxStretch);
                }
            }
        }
    }

    public SpringMesh(int numX, float width, float height, float springWeight, float maxStretch, float damp) {
        this(numX, SpringMesh.numY(numX, width, height), width, height, springWeight, maxStretch, damp);
    }

    protected float weigh(float d, float alpha) {
        return 1.0f / (float)Math.pow(d, alpha);
    }

    protected static void println(String s) {
        IJ.log((String)s);
    }

    public final Vertex findClosestTargetVertex(float[] there) {
        Set<Vertex> vs = this.vp.keySet();
        Vertex closest = null;
        float cd = Float.MAX_VALUE;
        for (Vertex v : vs) {
            float dy;
            float[] here = v.getW();
            float dx = here[0] - there[0];
            float d = dx * dx + (dy = here[1] - there[1]) * dy;
            if (!(d < cd)) continue;
            cd = d;
            closest = v;
        }
        return closest;
    }

    public final Vertex findClosestSourceVertex(float[] there) {
        Set<Vertex> vs = this.vp.keySet();
        Vertex closest = null;
        float cd = Float.MAX_VALUE;
        for (Vertex v : vs) {
            float dy;
            float[] here = v.getL();
            float dx = here[0] - there[0];
            float d = dx * dx + (dy = here[1] - there[1]) * dy;
            if (!(d < cd)) continue;
            cd = d;
            closest = v;
        }
        return closest;
    }

    public void addPassiveVertex(Vertex vertex) {
        float[] l = vertex.getL();
        PointMatch closest = this.findClosestSourcePoint(vertex.getL());
        Collection s = (Collection)this.va.get(closest);
        for (AffineModel2D ai : s) {
            ArrayList pm = (ArrayList)this.av.get(ai);
            if (!SpringMesh.isInSourcePolygon(pm, l)) continue;
            this.apv.put(ai, vertex);
            this.pva.put(vertex, ai);
            return;
        }
    }

    public void removePassiveVertex(Vertex vertex) {
        this.apv.remove(this.pva.remove(vertex));
    }

    public void addVertex(Vertex vertex, float weight) {
        Vertex closest = this.findClosestTargetVertex(vertex.getW());
        vertex.addSpring(closest, weight);
    }

    public final void addVertexWeightedByDistance(Vertex vertex, float weight, float alpha) {
        Set<Vertex> vs = this.vp.keySet();
        float[] there = vertex.getW();
        float[] weights = new float[]{weight, 1.0f};
        for (Vertex v : vs) {
            float[] here = v.getL();
            float dx = here[0] - there[0];
            float dy = here[1] - there[1];
            weights[1] = this.weigh(1.0f + dx * dx + dy * dy, alpha);
            if (!vs.contains(v)) continue;
            vertex.addSpring(v, weights);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateForceAndSpeed(ErrorStatistic observer) {
        this.maxSpeed = 0.0;
        this.minForce = Double.MAX_VALUE;
        this.maxForce = 0.0;
        this.force = 0.0;
        SpringMesh springMesh = this;
        synchronized (springMesh) {
            for (Vertex vertex : this.vertices) {
                vertex.update(this.damp);
                float vertexForce = vertex.getForce();
                this.force += (double)vertexForce;
                float speed = vertex.getSpeed();
                if ((double)speed > this.maxSpeed) {
                    this.maxSpeed = speed;
                }
                if ((double)vertexForce < this.minForce) {
                    this.minForce = vertexForce;
                }
                if (!((double)vertexForce > this.maxForce)) continue;
                this.maxForce = vertexForce;
            }
            this.force /= (double)this.vertices.size();
        }
        observer.add(this.force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(float dt) {
        SpringMesh springMesh = this;
        synchronized (springMesh) {
            for (Vertex vertex : this.vertices) {
                vertex.move(dt);
            }
            this.updateAffines();
            this.updatePassiveVertices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimizeStep(ErrorStatistic observer) throws NotEnoughDataPointsException {
        this.maxSpeed = Double.MIN_VALUE;
        this.minForce = Double.MAX_VALUE;
        this.maxForce = 0.0;
        this.force = 0.0;
        SpringMesh springMesh = this;
        synchronized (springMesh) {
            for (Vertex vertex : this.vertices) {
                vertex.update(this.damp);
                float vertexForce = vertex.getForce();
                this.force += (double)vertexForce;
                float speed = vertex.getSpeed();
                if ((double)speed > this.maxSpeed) {
                    this.maxSpeed = speed;
                }
                if ((double)vertexForce < this.minForce) {
                    this.minForce = vertexForce;
                }
                if (!((double)vertexForce > this.maxForce)) continue;
                this.maxForce = vertexForce;
            }
            this.force /= (double)this.vertices.size();
            for (Vertex vertex : this.vertices) {
                vertex.move(Math.min(1000.0f, (float)(2.0 / this.maxSpeed)));
            }
            this.updateAffines();
            this.updatePassiveVertices();
        }
        observer.add(this.force);
    }

    public void updatePassiveVertices() {
        for (Map.Entry<Vertex, AffineModel2D> entry : this.pva.entrySet()) {
            entry.getKey().apply(entry.getValue());
        }
    }

    @Override
    public void updateAffines() {
        super.updateAffines();
    }

    public void optimize(float maxError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException {
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        int i = 0;
        boolean proceed = i < maxIterations;
        while (proceed) {
            this.optimizeStep(observer);
            if (i > maxPlateauwidth) {
                proceed = observer.values.get(observer.values.lastIndex()) > (double)maxError;
                int d = maxPlateauwidth;
                while (!proceed && d >= 1) {
                    try {
                        proceed |= Math.abs(observer.getWideSlope(d)) > 0.0;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    d /= 2;
                }
            }
            proceed &= ++i < maxIterations;
        }
        this.updateAffines();
        System.out.println("Successfully optimized configuration of " + this.vertices.size() + " vertices after " + i + " iterations:");
        System.out.println("  average force: " + decimalFormat.format(this.force) + "N");
        System.out.println("  minimal force: " + decimalFormat.format(this.minForce) + "N");
        System.out.println("  maximal force: " + decimalFormat.format(this.maxForce) + "N");
    }

    public static final ColorProcessor paintMeshes(Collection<SpringMesh> meshes, float scale) {
        int width = (int)(meshes.iterator().next().getWidth() * scale);
        int height = (int)(meshes.iterator().next().getHeight() * scale);
        ColorProcessor ip = new ColorProcessor(width, height);
        BufferedImage bi = ip.getBufferedImage();
        Graphics2D g = bi.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, width, height);
        g.setTransform(new AffineTransform(scale, 0.0f, 0.0f, scale, 0.0f, 0.0f));
        int i = 0;
        for (SpringMesh m : meshes) {
            Shape shape = m.illustrateMesh();
            g.setColor(mpicbg.ij.util.Util.createSaturatedColor(i++, meshes.size()));
            g.draw(shape);
        }
        return new ColorProcessor((Image)bi);
    }

    public static final ColorProcessor paintSprings(Collection<SpringMesh> meshes, float scale, float maxStretch) {
        int width = Util.round(meshes.iterator().next().getWidth() * scale);
        int height = Util.round(meshes.iterator().next().getHeight() * scale);
        ColorProcessor ip = new ColorProcessor(width, height);
        float maxSpringStretch = 0.0f;
        for (SpringMesh m : meshes) {
            for (Vertex vertex : m.getVertices()) {
                for (Vertex v : vertex.getConnectedVertices()) {
                    Spring spring = vertex.getSpring(v);
                    float stretch = Math.abs(Point.distance(vertex, v) - spring.getLength());
                    if (!(stretch > maxSpringStretch)) continue;
                    maxSpringStretch = stretch;
                }
            }
        }
        for (SpringMesh m : meshes) {
            m.illustrateSprings(ip, scale, maxSpringStretch);
        }
        return ip;
    }

    public static final ColorProcessor paintSprings(Collection<SpringMesh> meshes, int width, int height, float maxStretch) {
        ColorProcessor ip = new ColorProcessor(width, height);
        float[] min = new float[2];
        float[] max = new float[2];
        float maxSpringStretch = 0.0f;
        for (SpringMesh mesh : meshes) {
            float[] meshMin = new float[2];
            float[] meshMax = new float[2];
            mesh.bounds(meshMin, meshMax);
            Util.min(min, meshMin);
            Util.max(max, meshMax);
            for (Vertex vertex : mesh.getVertices()) {
                for (Vertex v : vertex.getConnectedVertices()) {
                    Spring spring = vertex.getSpring(v);
                    float stretch = Math.abs(Point.distance(vertex, v) - spring.getLength());
                    if (!(stretch > maxSpringStretch)) continue;
                    maxSpringStretch = stretch;
                }
            }
        }
        float w = max[0] - min[0];
        float h = max[1] - min[1];
        float scale = Math.min((float)width / w, (float)height / h);
        float offsetX = ((float)width - scale * w) / 2.0f - min[0] * scale;
        float offsetY = ((float)height - scale * h) / 2.0f - min[1] * scale;
        for (SpringMesh m : meshes) {
            m.illustrateSprings(ip, scale, maxSpringStretch, offsetX, offsetY);
        }
        return ip;
    }

    public static void optimizeMeshes(Collection<SpringMesh> meshes, float maxError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException {
        SpringMesh.optimizeMeshes(meshes, maxError, maxIterations, maxPlateauwidth, false);
    }

    public static void optimizeMeshes(Collection<SpringMesh> meshes, float maxError, int maxIterations, int maxPlateauwidth, boolean visualize) throws NotEnoughDataPointsException {
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        ErrorStatistic singleMeshObserver = new ErrorStatistic(maxPlateauwidth + 1);
        int i = 0;
        double force = 0.0;
        double maxForce = 0.0;
        double minForce = 0.0;
        boolean proceed = i < maxIterations;
        ImageStack stackAnimation = new ImageStack(512, 512);
        ImagePlus impAnimation = new ImagePlus();
        SpringMesh.println("i mean min max");
        while (proceed) {
            force = 0.0;
            maxForce = 0.0;
            minForce = Double.MAX_VALUE;
            double maxSpeed = 0.0;
            if (visualize) {
                stackAnimation.addSlice("" + i, (ImageProcessor)SpringMesh.paintSprings(meshes, 512, 512, maxError));
                impAnimation.setStack(stackAnimation);
                impAnimation.updateAndDraw();
                if (i == 1) {
                    impAnimation.show();
                }
            }
            for (SpringMesh mesh : meshes) {
                mesh.calculateForceAndSpeed(singleMeshObserver);
                force += mesh.getForce();
                if (mesh.maxSpeed > maxSpeed) {
                    maxSpeed = mesh.maxSpeed;
                }
                double meshMaxForce = mesh.maxForce;
                double meshMinForce = mesh.minForce;
                if (meshMaxForce > maxForce) {
                    maxForce = meshMaxForce;
                }
                if (!(meshMinForce < minForce)) continue;
                minForce = meshMinForce;
            }
            observer.add(force / (double)meshes.size());
            float dt = (float)Math.min(1000.0, 1.0 / maxSpeed);
            for (SpringMesh mesh : meshes) {
                mesh.update(dt);
            }
            SpringMesh.println(new StringBuffer(String.valueOf(i) + " ").append(force / (double)meshes.size()).append(" ").append(minForce).append(" ").append(maxForce).toString());
            if (i > maxPlateauwidth) {
                proceed = force > (double)maxError;
                int d = maxPlateauwidth;
                while (!proceed && d >= 1) {
                    try {
                        proceed |= Math.abs(observer.getWideSlope(d)) > 0.0;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    d /= 2;
                }
            }
            proceed &= ++i < maxIterations;
        }
        for (SpringMesh mesh : meshes) {
            mesh.updateAffines();
            mesh.updatePassiveVertices();
        }
        System.out.println("Successfully optimized " + meshes.size() + " meshes after " + i + " iterations:");
        System.out.println("  average force: " + decimalFormat.format(force / (double)meshes.size()) + "N");
        System.out.println("  minimal force: " + decimalFormat.format(minForce) + "N");
        System.out.println("  maximal force: " + decimalFormat.format(maxForce) + "N");
    }

    public Shape illustrateSprings() {
        GeneralPath path = new GeneralPath();
        for (Vertex vertex : this.vertices) {
            float[] v1 = vertex.getW();
            for (Vertex v : vertex.getConnectedVertices()) {
                float[] v2 = v.getW();
                path.moveTo(v1[0], v1[1]);
                path.lineTo(v2[0], v2[1]);
            }
        }
        return path;
    }

    public void illustrateSprings(ColorProcessor ip, float scale, float maxStretch) {
        for (Vertex vertex : this.vertices) {
            float[] v1 = vertex.getW();
            for (Vertex v : vertex.getConnectedVertices()) {
                Spring spring = vertex.getSpring(v);
                float stretch = Math.min(1.0f, Math.abs(Point.distance(vertex, v) - spring.getLength()) / maxStretch);
                float r = Math.min(1.0f, stretch * 2.0f);
                float g = Math.min(1.0f, 2.0f - stretch * 2.0f);
                ip.setColor(new Color(r, g, 0.0f));
                float[] v2 = v.getW();
                ip.drawLine(Util.round(scale * v1[0]), Util.round(scale * v1[1]), Util.round(scale * v2[0]), Util.round(scale * v2[1]));
            }
        }
    }

    public void illustrateSprings(ColorProcessor ip, float scale, float maxStretch, float offsetX, float offsetY) {
        for (Vertex vertex : this.vertices) {
            float[] v1 = vertex.getW();
            for (Vertex v : vertex.getConnectedVertices()) {
                Spring spring = vertex.getSpring(v);
                float stretch = Math.min(1.0f, Math.abs(Point.distance(vertex, v) - spring.getLength()) / maxStretch);
                float r = Math.min(1.0f, stretch * 2.0f);
                float g = Math.min(1.0f, 2.0f - stretch * 2.0f);
                ip.setColor(new Color(r, g, 0.0f));
                float[] v2 = v.getW();
                ip.drawLine(Util.round(scale * v1[0] + offsetX), Util.round(scale * v1[1] + offsetY), Util.round(scale * v2[0] + offsetX), Util.round(scale * v2[1] + offsetY));
            }
        }
    }

    @Override
    public Shape illustrateMesh() {
        GeneralPath path = (GeneralPath)super.illustrateMesh();
        for (Vertex vertex : this.pva.keySet()) {
            float[] w = vertex.getW();
            path.moveTo(w[0], w[1] - 1.0f);
            path.lineTo(w[0] + 1.0f, w[1]);
            path.lineTo(w[0], w[1] + 1.0f);
            path.lineTo(w[0] - 1.0f, w[1]);
            path.closePath();
        }
        return path;
    }

    @Override
    public void init(CoordinateTransform t) {
        super.init(t);
        this.updatePassiveVertices();
    }

    @Override
    public void scale(float scale) {
        float[] f;
        float[] d;
        super.scale(scale);
        for (Vertex v : this.vertices) {
            d = v.getDirection();
            f = v.getForces();
            int i = 0;
            while (i < d.length) {
                int n = i;
                d[n] = d[n] * scale;
                int n2 = i++;
                f[n2] = f[n2] * scale;
            }
            for (Spring s : v.getSprings()) {
                s.setLength(s.getLength() * scale);
            }
        }
        for (Vertex v : this.pva.keySet()) {
            d = v.getDirection();
            f = v.getForces();
            int i = 0;
            while (i < d.length) {
                int n = i;
                d[n] = d[n] * scale;
                int n3 = i++;
                f[n3] = f[n3] * scale;
            }
            for (Spring s : v.getSprings()) {
                s.setLength(s.getLength() * scale);
            }
        }
        this.updatePassiveVertices();
    }
}

