/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import java.util.Random;
import mpicbg.models.Point;

public class Spring
implements Serializable {
    private static final long serialVersionUID = -8807104366983065341L;
    protected static final Random rnd = new Random(0L);
    protected float length;
    protected final float maxStretch;
    protected float[] weights;
    protected float weight;

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    protected static float length(float[] p1, float[] p2) {
        assert (p1.length == p2.length) : "Both locations have to have the same dimensionality.";
        float l = 0.0f;
        int i = 0;
        while (i < p1.length) {
            float dl = p1[i] - p2[i];
            l += dl * dl;
            ++i;
        }
        return (float)Math.sqrt(l);
    }

    protected void calculateWeight() {
        this.weight = 1.0f;
        float[] fArray = this.weights;
        int n = this.weights.length;
        int n2 = 0;
        while (n2 < n) {
            float wi = fArray[n2];
            this.weight *= wi;
            ++n2;
        }
    }

    public float getWeight() {
        return this.weight;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setWeights(float[] weights) {
        this.weights = (float[])weights.clone();
        this.calculateWeight();
    }

    public void addWeight(float w) {
        float[] newWeights = new float[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 0, this.weights.length);
        newWeights[this.weights.length] = w;
        this.weights = newWeights;
        this.calculateWeight();
    }

    public void removeWeight(int index) {
        if (index < this.weights.length) {
            float[] newWeights = new float[this.weights.length - 1];
            int j = 0;
            int i = 0;
            while (i < this.weights.length) {
                if (i != index) {
                    newWeights[j++] = this.weights[i];
                }
                ++i;
            }
            this.weights = newWeights;
            this.calculateWeight();
        }
    }

    public void setWeight(int index, float weight) {
        this.weights[index] = weight;
        this.calculateWeight();
    }

    public void calculateForce(Point p1, Point p2, float[] force) {
        float[] w2;
        assert (force.length == p1.getL().length && force.length == p2.getL().length) : "Both vertices and force have to have the same dimensionality.";
        float[] w1 = p1.getW();
        float lw = Spring.length(w1, w2 = p2.getW());
        float d = lw - this.length;
        if (Math.abs(d) > this.maxStretch) {
            int i = 0;
            while (i < force.length) {
                force[i] = 0.0f;
                ++i;
            }
        } else if (lw == 0.0f) {
            int i = 0;
            while (i < force.length) {
                force[i] = 0.0f;
                ++i;
            }
            force[(int)((double)force.length * Spring.rnd.nextDouble())] = d * this.weight;
        } else {
            int i = 0;
            while (i < w1.length) {
                force[i] = (w2[i] - w1[i]) / lw * d * this.weight;
                ++i;
            }
        }
    }

    public Spring(float length, float[] weights) {
        this.length = length;
        this.weights = (float[])weights.clone();
        this.calculateWeight();
        this.maxStretch = Float.MAX_VALUE;
    }

    public Spring(float length, float[] weights, float maxStretch) {
        this.length = length;
        this.weights = (float[])weights.clone();
        this.calculateWeight();
        this.maxStretch = maxStretch;
    }

    public Spring(float length, float weight) {
        this.length = length;
        this.weights = new float[]{weight};
        this.weight = weight;
        this.maxStretch = Float.MAX_VALUE;
    }

    public Spring(float length, float weight, float maxStretch) {
        this.length = length;
        this.weights = new float[]{weight};
        this.weight = weight;
        this.maxStretch = maxStretch;
    }

    public Spring(float length) {
        this.length = length;
        this.weight = 1.0f;
        this.maxStretch = Float.MAX_VALUE;
    }

    public Spring(Point p1, Point p2, float[] weights) {
        this(Spring.length(p1.getL(), p2.getL()), weights);
    }

    public Spring(Point p1, Point p2, float[] weights, float maxStretch) {
        this(Spring.length(p1.getL(), p2.getL()), weights, maxStretch);
    }

    public Spring(Point p1, Point p2, float weight) {
        this(Spring.length(p1.getL(), p2.getL()), weight);
    }

    public Spring(Point p1, Point p2, float weight, float maxStretch) {
        this(Spring.length(p1.getL(), p2.getL()), weight, maxStretch);
    }

    public Spring(Point p1, Point p2) {
        this(Spring.length(p1.getL(), p2.getL()));
    }
}

