/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class SimilarityModel2D
extends AbstractAffineModel2D<SimilarityModel2D> {
    protected static final int MIN_NUM_MATCHES = 2;
    protected float scos = 1.0f;
    protected float ssin = 0.0f;
    protected float tx = 0.0f;
    protected float ty = 0.0f;
    private float iscos = 1.0f;
    private float issin = 0.0f;
    private float itx = 0.0f;
    private float ity = 0.0f;

    @Override
    public final int getMinNumMatches() {
        return 2;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(this.scos, this.ssin, -this.ssin, this.scos, this.tx, this.ty);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(this.iscos, this.issin, -this.issin, this.iscos, this.itx, this.ity);
    }

    @Override
    public final float[] apply(float[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        float[] transformed = (float[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        float l0 = l[0];
        l[0] = this.scos * l0 - this.ssin * l[1] + this.tx;
        l[1] = this.ssin * l0 + this.scos * l[1] + this.ty;
    }

    @Override
    public final float[] applyInverse(float[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        float[] transformed = (float[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(float[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        float l0 = l[0];
        l[0] = this.iscos * l0 - this.issin * l[1] + this.itx;
        l[1] = this.issin * l0 + this.iscos * l[1] + this.ity;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(String.valueOf(l) + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        int i = 0;
        while (i < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
            ++i;
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double scosd = 0.0;
        double ssind = 0.0;
        ws = 0.0;
        int i2 = 0;
        while (i2 < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i2];
            double x1 = (double)pX[i2] - pcx;
            double y1 = (double)pY[i2] - pcy;
            double x2 = (double)qX[i2] - qcx + dx;
            double y2 = (double)qY[i2] - qcy + dy;
            ssind += ww * (x1 * y2 - y1 * x2);
            scosd += ww * (x1 * x2 + y1 * y2);
            ws += ww * (x1 * x1 + y1 * y1);
            ++i2;
        }
        this.scos = (float)(scosd /= ws);
        this.ssin = (float)(ssind /= ws);
        this.tx = (float)(qcx - scosd * pcx + ssind * pcy);
        this.ty = (float)(qcy - ssind * pcx - scosd * pcy);
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 2) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * (double)p[0];
            pcy += w * (double)p[1];
            qcx += w * (double)q[0];
            qcy += w * (double)q[1];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double scosd = 0.0;
        double ssind = 0.0;
        ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            double x1 = (double)p[0] - pcx;
            double y1 = (double)p[1] - pcy;
            double x2 = (double)q[0] - qcx + dx;
            double y2 = (double)q[1] - qcy + dy;
            ssind += w * (x1 * y2 - y1 * x2);
            scosd += w * (x1 * x2 + y1 * y2);
            ws += w * (x1 * x1 + y1 * y1);
        }
        this.scos = (float)(scosd /= ws);
        this.ssin = (float)(ssind /= ws);
        this.tx = (float)(qcx - scosd * pcx + ssind * pcy);
        this.ty = (float)(qcy - ssind * pcx - scosd * pcy);
        this.invert();
    }

    @Override
    public SimilarityModel2D copy() {
        SimilarityModel2D m = new SimilarityModel2D();
        m.scos = this.scos;
        m.ssin = this.ssin;
        m.tx = this.tx;
        m.ty = this.ty;
        m.iscos = this.iscos;
        m.issin = this.issin;
        m.itx = this.itx;
        m.ity = this.ity;
        m.cost = this.cost;
        return m;
    }

    @Override
    public final void set(SimilarityModel2D m) {
        this.scos = m.scos;
        this.ssin = m.ssin;
        this.tx = m.tx;
        this.ty = m.ty;
        this.iscos = m.iscos;
        this.issin = m.issin;
        this.itx = m.itx;
        this.ity = m.ity;
        this.cost = m.cost;
    }

    protected final void invert() {
        double det = this.scos * this.scos + this.ssin * this.ssin;
        this.iscos = (float)((double)this.scos / det);
        this.issin = (float)((double)(-this.ssin) / det);
        this.itx = (float)((double)(-this.ssin * this.ty - this.scos * this.tx) / det);
        this.ity = (float)((double)(this.ssin * this.tx - this.scos * this.ty) / det);
    }

    @Override
    public final void preConcatenate(SimilarityModel2D model) {
        double a = model.scos * this.scos - model.ssin * this.ssin;
        double b = model.ssin * this.scos + model.scos * this.ssin;
        double c = model.scos * this.tx - model.ssin * this.ty + model.tx;
        double d = model.ssin * this.tx + model.scos * this.ty + model.ty;
        this.scos = (float)a;
        this.ssin = (float)b;
        this.tx = (float)c;
        this.ty = (float)d;
        this.invert();
    }

    @Override
    public final void concatenate(SimilarityModel2D model) {
        double a = this.scos * model.scos - this.ssin * model.ssin;
        double b = this.ssin * model.scos + this.scos * model.ssin;
        double c = this.scos * model.tx - this.ssin * model.ty + this.tx;
        double d = this.ssin * model.tx + this.scos * model.ty + this.ty;
        this.scos = (float)a;
        this.ssin = (float)b;
        this.tx = (float)c;
        this.ty = (float)d;
        this.invert();
    }

    public final void setScaleRotationTranslation(float s, float theta, float tx, float ty) {
        this.set(s * (float)Math.cos(theta), s * (float)Math.sin(theta), tx, ty);
    }

    public final void set(float scos, float ssin, float tx, float ty) {
        this.scos = scos;
        this.ssin = ssin;
        this.tx = tx;
        this.ty = ty;
        this.invert();
    }

    @Override
    public SimilarityModel2D createInverse() {
        SimilarityModel2D ict = new SimilarityModel2D();
        ict.scos = this.iscos;
        ict.ssin = this.issin;
        ict.tx = this.itx;
        ict.ty = this.ity;
        ict.iscos = this.scos;
        ict.issin = this.ssin;
        ict.itx = this.tx;
        ict.ity = this.ty;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(float[] data) {
        data[0] = this.scos;
        data[1] = this.ssin;
        data[2] = -this.ssin;
        data[3] = this.scos;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.scos;
        data[1] = this.ssin;
        data[2] = -this.ssin;
        data[3] = this.scos;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = this.scos;
        data[0][1] = -this.ssin;
        data[0][2] = this.tx;
        data[1][0] = this.ssin;
        data[1][1] = this.scos;
        data[1][1] = this.ty;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.scos;
        data[0][1] = -this.ssin;
        data[0][2] = this.tx;
        data[1][0] = this.ssin;
        data[1][1] = this.scos;
        data[1][1] = this.ty;
    }
}

