/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.TranslationModel3D;
import mpicbg.util.Matrix3x3;

public class RigidModel3D
extends AbstractAffineModel3D<RigidModel3D>
implements InvertibleBoundable {
    protected static final int MIN_NUM_MATCHES = 3;
    protected float m00 = 1.0f;
    protected float m01 = 0.0f;
    protected float m02 = 0.0f;
    protected float m03 = 0.0f;
    protected float m10 = 0.0f;
    protected float m11 = 1.0f;
    protected float m12 = 0.0f;
    protected float m13 = 0.0f;
    protected float m20 = 0.0f;
    protected float m21 = 0.0f;
    protected float m22 = 1.0f;
    protected float m23 = 0.0f;
    protected float i00 = 1.0f;
    protected float i01 = 0.0f;
    protected float i02 = 0.0f;
    protected float i03 = 0.0f;
    protected float i10 = 0.0f;
    protected float i11 = 1.0f;
    protected float i12 = 0.0f;
    protected float i13 = 0.0f;
    protected float i20 = 0.0f;
    protected float i21 = 0.0f;
    protected float i22 = 1.0f;
    protected float i23 = 0.0f;
    protected boolean isInvertible = true;

    @Override
    public float[] getMatrix(float[] m) {
        float[] a = m == null || m.length != 12 ? new float[12] : m;
        a[0] = this.m00;
        a[1] = this.m01;
        a[2] = this.m02;
        a[3] = this.m03;
        a[4] = this.m10;
        a[5] = this.m11;
        a[6] = this.m12;
        a[7] = this.m13;
        a[8] = this.m20;
        a[9] = this.m21;
        a[10] = this.m22;
        a[11] = this.m23;
        return a;
    }

    @Override
    public final int getMinNumMatches() {
        return 3;
    }

    @Override
    public final float[] apply(float[] l) {
        float[] transformed = (float[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        float l0 = l[0];
        float l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02 + this.m03;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12 + this.m13;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22 + this.m23;
    }

    @Override
    public final float[] applyInverse(float[] l) throws NoninvertibleModelException {
        float[] transformed = (float[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(float[] l) throws NoninvertibleModelException {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        float l0 = l[0];
        float l1 = l[1];
        l[0] = l0 * this.i00 + l1 * this.i01 + l[2] * this.i02 + this.i03;
        l[1] = l0 * this.i10 + l1 * this.i11 + l[2] * this.i12 + this.i13;
        l[2] = l0 * this.i20 + l1 * this.i21 + l[2] * this.i22 + this.i23;
    }

    public final String toString() {
        return "3d-rigid: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + ")";
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 3) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 3d rigid transformation model, at least " + 3 + " data points required.");
        }
        float pcx = 0.0f;
        float pcy = 0.0f;
        float pcz = 0.0f;
        float qcx = 0.0f;
        float qcy = 0.0f;
        float qcz = 0.0f;
        float sumW = 0.0f;
        for (PointMatch pm : matches) {
            float[] p1 = pm.getP1().getL();
            float[] p2 = pm.getP2().getW();
            float w = pm.getWeight();
            pcx += p1[0] * w;
            pcy += p1[1] * w;
            pcz += p1[2] * w;
            qcx += p2[0] * w;
            qcy += p2[1] * w;
            qcz += p2[2] * w;
            sumW += w;
        }
        pcx /= sumW;
        pcy /= sumW;
        pcz /= sumW;
        qcx /= sumW;
        qcy /= sumW;
        qcz /= sumW;
        float Sxx = 0.0f;
        float Sxy = 0.0f;
        float Sxz = 0.0f;
        float Syx = 0.0f;
        float Syy = 0.0f;
        float Syz = 0.0f;
        float Szx = 0.0f;
        float Szy = 0.0f;
        float Szz = 0.0f;
        for (PointMatch pm : matches) {
            float[] p1 = pm.getP1().getL();
            float[] p2 = pm.getP2().getW();
            float w = pm.getWeight();
            float x1 = (p1[0] - pcx) * w;
            float y1 = (p1[1] - pcy) * w;
            float z1 = (p1[2] - pcz) * w;
            float x2 = (p2[0] - qcx) * w;
            float y2 = (p2[1] - qcy) * w;
            float z2 = (p2[2] - qcz) * w;
            Sxx += x1 * x2;
            Sxy += x1 * y2;
            Sxz += x1 * z2;
            Syx += y1 * x2;
            Syy += y1 * y2;
            Syz += y1 * z2;
            Szx += z1 * x2;
            Szy += z1 * y2;
            Szz += z1 * z2;
        }
        double[][] N = new double[4][4];
        N[0][0] = Sxx + Syy + Szz;
        N[0][1] = Syz - Szy;
        N[0][2] = Szx - Sxz;
        N[0][3] = Sxy - Syx;
        N[1][0] = Syz - Szy;
        N[1][1] = Sxx - Syy - Szz;
        N[1][2] = Sxy + Syx;
        N[1][3] = Szx + Sxz;
        N[2][0] = Szx - Sxz;
        N[2][1] = Sxy + Syx;
        N[2][2] = -Sxx + Syy - Szz;
        N[2][3] = Syz + Szy;
        N[3][0] = Sxy - Syx;
        N[3][1] = Szx + Sxz;
        N[3][2] = Syz + Szy;
        N[3][3] = -Sxx - Syy + Szz;
        EigenvalueDecomposition evd = new EigenvalueDecomposition(new Matrix(N));
        double[] eigenvalues = evd.getRealEigenvalues();
        Matrix eigenVectors = evd.getV();
        int index = 0;
        int i = 1;
        while (i < 4) {
            if (eigenvalues[i] > eigenvalues[index]) {
                index = i;
            }
            ++i;
        }
        float q0 = (float)eigenVectors.get(0, index);
        float qx = (float)eigenVectors.get(1, index);
        float qy = (float)eigenVectors.get(2, index);
        float qz = (float)eigenVectors.get(3, index);
        this.m00 = q0 * q0 + qx * qx - qy * qy - qz * qz;
        this.m01 = 2.0f * (qx * qy - q0 * qz);
        this.m02 = 2.0f * (qx * qz + q0 * qy);
        this.m10 = 2.0f * (qy * qx + q0 * qz);
        this.m11 = q0 * q0 - qx * qx + qy * qy - qz * qz;
        this.m12 = 2.0f * (qy * qz - q0 * qx);
        this.m20 = 2.0f * (qz * qx - q0 * qy);
        this.m21 = 2.0f * (qz * qy + q0 * qx);
        this.m22 = q0 * q0 - qx * qx - qy * qy + qz * qz;
        this.m03 = qcx - this.m00 * pcx - this.m01 * pcy - this.m02 * pcz;
        this.m13 = qcy - this.m10 * pcx - this.m11 * pcy - this.m12 * pcz;
        this.m23 = qcz - this.m20 * pcx - this.m21 * pcy - this.m22 * pcz;
        this.invert();
    }

    @Override
    public final void set(RigidModel3D m) {
        this.m00 = m.m00;
        this.m10 = m.m10;
        this.m20 = m.m20;
        this.m01 = m.m01;
        this.m11 = m.m11;
        this.m21 = m.m21;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.m22 = m.m22;
        this.m03 = m.m03;
        this.m13 = m.m13;
        this.m23 = m.m23;
        this.cost = m.cost;
        this.invert();
    }

    @Override
    public RigidModel3D copy() {
        RigidModel3D m = new RigidModel3D();
        m.m00 = this.m00;
        m.m10 = this.m10;
        m.m20 = this.m20;
        m.m01 = this.m01;
        m.m11 = this.m11;
        m.m21 = this.m21;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.m22 = this.m22;
        m.m03 = this.m03;
        m.m13 = this.m13;
        m.m23 = this.m23;
        m.cost = this.cost;
        m.invert();
        return m;
    }

    protected void invert() {
        float det = Matrix3x3.det(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        if (det == 0.0f) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        float idet = 1.0f / det;
        this.i00 = (this.m11 * this.m22 - this.m12 * this.m21) * idet;
        this.i01 = (this.m02 * this.m21 - this.m01 * this.m22) * idet;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) * idet;
        this.i10 = (this.m12 * this.m20 - this.m10 * this.m22) * idet;
        this.i11 = (this.m00 * this.m22 - this.m02 * this.m20) * idet;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) * idet;
        this.i20 = (this.m10 * this.m21 - this.m11 * this.m20) * idet;
        this.i21 = (this.m01 * this.m20 - this.m00 * this.m21) * idet;
        this.i22 = (this.m00 * this.m11 - this.m01 * this.m10) * idet;
        this.i03 = -this.i00 * this.m03 - this.i01 * this.m13 - this.i02 * this.m23;
        this.i13 = -this.i10 * this.m03 - this.i11 * this.m13 - this.i12 * this.m23;
        this.i23 = -this.i20 * this.m03 - this.i21 * this.m13 - this.i22 * this.m23;
    }

    @Override
    public final void preConcatenate(RigidModel3D model) {
        float a00 = model.m00 * this.m00 + model.m01 * this.m10 + model.m02 * this.m20;
        float a01 = model.m00 * this.m01 + model.m01 * this.m11 + model.m02 * this.m21;
        float a02 = model.m00 * this.m02 + model.m01 * this.m12 + model.m02 * this.m22;
        float a03 = model.m00 * this.m03 + model.m01 * this.m13 + model.m02 * this.m23 + model.m03;
        float a10 = model.m10 * this.m00 + model.m11 * this.m10 + model.m12 * this.m20;
        float a11 = model.m10 * this.m01 + model.m11 * this.m11 + model.m12 * this.m21;
        float a12 = model.m10 * this.m02 + model.m11 * this.m12 + model.m12 * this.m22;
        float a13 = model.m10 * this.m03 + model.m11 * this.m13 + model.m12 * this.m23 + model.m13;
        float a20 = model.m20 * this.m00 + model.m21 * this.m10 + model.m22 * this.m20;
        float a21 = model.m20 * this.m01 + model.m21 * this.m11 + model.m22 * this.m21;
        float a22 = model.m20 * this.m02 + model.m21 * this.m12 + model.m22 * this.m22;
        float a23 = model.m20 * this.m03 + model.m21 * this.m13 + model.m22 * this.m23 + model.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(RigidModel3D model) {
        float a00 = this.m00 * model.m00 + this.m01 * model.m10 + this.m02 * model.m20;
        float a01 = this.m00 * model.m01 + this.m01 * model.m11 + this.m02 * model.m21;
        float a02 = this.m00 * model.m02 + this.m01 * model.m12 + this.m02 * model.m22;
        float a03 = this.m00 * model.m03 + this.m01 * model.m13 + this.m02 * model.m23 + this.m03;
        float a10 = this.m10 * model.m00 + this.m11 * model.m10 + this.m12 * model.m20;
        float a11 = this.m10 * model.m01 + this.m11 * model.m11 + this.m12 * model.m21;
        float a12 = this.m10 * model.m02 + this.m11 * model.m12 + this.m12 * model.m22;
        float a13 = this.m10 * model.m03 + this.m11 * model.m13 + this.m12 * model.m23 + this.m13;
        float a20 = this.m20 * model.m00 + this.m21 * model.m10 + this.m22 * model.m20;
        float a21 = this.m20 * model.m01 + this.m21 * model.m11 + this.m22 * model.m21;
        float a22 = this.m20 * model.m02 + this.m21 * model.m12 + this.m22 * model.m22;
        float a23 = this.m20 * model.m03 + this.m21 * model.m13 + this.m22 * model.m23 + this.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(TranslationModel3D model) {
        float[] t = model.getTranslation();
        this.m03 = this.m00 * t[0] + this.m01 * t[1] + this.m02 * t[2] + this.m03;
        this.m13 = this.m10 * t[0] + this.m11 * t[1] + this.m12 * t[2] + this.m13;
        this.m23 = this.m20 * t[0] + this.m21 * t[1] + this.m22 * t[2] + this.m23;
        this.invert();
    }

    @Override
    public final void preConcatenate(TranslationModel3D model) {
        float[] t = model.getTranslation();
        this.m03 += t[0];
        this.m13 += t[1];
        this.m23 += t[2];
        this.invert();
    }

    public final void set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.invert();
    }

    @Override
    public RigidModel3D createInverse() {
        RigidModel3D ict = new RigidModel3D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m20 = this.i20;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m21 = this.i21;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.m22 = this.i22;
        ict.m03 = this.i03;
        ict.m13 = this.i13;
        ict.m23 = this.i23;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i20 = this.m20;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i21 = this.m21;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.i22 = this.m22;
        ict.i03 = this.m03;
        ict.i13 = this.m13;
        ict.i23 = this.m23;
        ict.cost = this.cost;
        ict.isInvertible = this.isInvertible;
        return ict;
    }

    public void rotate(int axis, float d) {
        float dcos = (float)Math.cos(d);
        float dsin = (float)Math.sin(d);
        RigidModel3D dR = new RigidModel3D();
        switch (axis) {
            case 0: {
                dR.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, dcos, -dsin, 0.0f, 0.0f, dsin, dcos, 0.0f);
                break;
            }
            case 1: {
                dR.set(dcos, 0.0f, dsin, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -dsin, 0.0f, dcos, 0.0f);
                break;
            }
            default: {
                dR.set(dcos, -dsin, 0.0f, 0.0f, dsin, dcos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            }
        }
        this.preConcatenate(dR);
    }

    @Override
    public void toArray(float[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m20;
        data[3] = this.m01;
        data[4] = this.m11;
        data[5] = this.m21;
        data[6] = this.m02;
        data[7] = this.m12;
        data[8] = this.m22;
        data[9] = this.m03;
        data[10] = this.m13;
        data[11] = this.m23;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m20;
        data[3] = this.m01;
        data[4] = this.m11;
        data[5] = this.m21;
        data[6] = this.m02;
        data[7] = this.m12;
        data[8] = this.m22;
        data[9] = this.m03;
        data[10] = this.m13;
        data[11] = this.m23;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[0][3] = this.m03;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
        data[1][3] = this.m13;
        data[2][0] = this.m20;
        data[2][1] = this.m21;
        data[2][2] = this.m22;
        data[2][3] = this.m23;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[0][3] = this.m03;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
        data[1][3] = this.m13;
        data[2][0] = this.m20;
        data[2][1] = this.m21;
        data[2][2] = this.m22;
        data[2][3] = this.m23;
    }
}

