/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class RigidModel2D
extends AbstractAffineModel2D<RigidModel2D> {
    protected static final int MIN_NUM_MATCHES = 2;
    protected float cos = 1.0f;
    protected float sin = 0.0f;
    protected float tx = 0.0f;
    protected float ty = 0.0f;
    protected float itx = 0.0f;
    protected float ity = 0.0f;

    @Override
    public final int getMinNumMatches() {
        return 2;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(this.cos, this.sin, -this.sin, this.cos, this.tx, this.ty);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(this.cos, -this.sin, this.sin, this.cos, this.itx, this.ity);
    }

    @Override
    public final float[] apply(float[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        float[] transformed = (float[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        float l0 = l[0];
        l[0] = this.cos * l0 - this.sin * l[1] + this.tx;
        l[1] = this.sin * l0 + this.cos * l[1] + this.ty;
    }

    @Override
    public final float[] applyInverse(float[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        float[] transformed = (float[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(float[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        float l0 = l[0];
        l[0] = this.cos * l0 + this.sin * l[1] + this.itx;
        l[1] = -this.sin * l0 + this.cos * l[1] + this.ity;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(String.valueOf(l) + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        int i = 0;
        while (i < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
            ++i;
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double cosd = 0.0;
        double sind = 0.0;
        int i2 = 0;
        while (i2 < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i2];
            double x1 = (double)pX[i2] - pcx;
            double y1 = (double)pY[i2] - pcy;
            double x2 = (double)qX[i2] - qcx + dx;
            double y2 = (double)qY[i2] - qcy + dy;
            sind += ww * (x1 * y2 - y1 * x2);
            cosd += ww * (x1 * x2 + y1 * y2);
            ++i2;
        }
        double norm = Math.sqrt(cosd * cosd + sind * sind);
        this.cos = (float)(cosd /= norm);
        this.sin = (float)(sind /= norm);
        this.tx = (float)(qcx - cosd * pcx + sind * pcy);
        this.ty = (float)(qcy - sind * pcx - cosd * pcy);
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 2) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * (double)p[0];
            pcy += w * (double)p[1];
            qcx += w * (double)q[0];
            qcy += w * (double)q[1];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double cosd = 0.0;
        double sind = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            double x1 = (double)p[0] - pcx;
            double y1 = (double)p[1] - pcy;
            double x2 = (double)q[0] - qcx + dx;
            double y2 = (double)q[1] - qcy + dy;
            sind += w * (x1 * y2 - y1 * x2);
            cosd += w * (x1 * x2 + y1 * y2);
        }
        double norm = Math.sqrt(cosd * cosd + sind * sind);
        this.cos = (float)(cosd /= norm);
        this.sin = (float)(sind /= norm);
        this.tx = (float)(qcx - cosd * pcx + sind * pcy);
        this.ty = (float)(qcy - sind * pcx - cosd * pcy);
        this.invert();
    }

    @Override
    public RigidModel2D copy() {
        RigidModel2D m = new RigidModel2D();
        m.cos = this.cos;
        m.sin = this.sin;
        m.tx = this.tx;
        m.ty = this.ty;
        m.itx = this.itx;
        m.ity = this.ity;
        m.cost = this.cost;
        return m;
    }

    @Override
    public final void set(RigidModel2D m) {
        this.cos = m.cos;
        this.sin = m.sin;
        this.tx = m.tx;
        this.ty = m.ty;
        this.itx = m.itx;
        this.ity = m.ity;
        this.cost = m.cost;
    }

    private final void invert() {
        this.itx = -this.sin * this.ty - this.cos * this.tx;
        this.ity = this.sin * this.tx - this.cos * this.ty;
    }

    @Override
    public final void preConcatenate(RigidModel2D model) {
        double a = model.cos * this.cos - model.sin * this.sin;
        double b = model.sin * this.cos + model.cos * this.sin;
        double c = model.cos * this.tx - model.sin * this.ty + model.tx;
        double d = model.sin * this.tx + model.cos * this.ty + model.ty;
        this.cos = (float)a;
        this.sin = (float)b;
        this.tx = (float)c;
        this.ty = (float)d;
        this.invert();
    }

    @Override
    public final void concatenate(RigidModel2D model) {
        double a = this.cos * model.cos - this.sin * model.sin;
        double b = this.sin * model.cos + this.cos * model.sin;
        double c = this.cos * model.tx - this.sin * model.ty + this.tx;
        double d = this.sin * model.tx + this.cos * model.ty + this.ty;
        this.cos = (float)a;
        this.sin = (float)b;
        this.tx = (float)c;
        this.ty = (float)d;
        this.invert();
    }

    public final void set(float theta, float tx, float ty) {
        this.set((float)Math.cos(theta), (float)Math.sin(theta), tx, ty);
    }

    public final void set(float cos, float sin, float tx, float ty) {
        this.cos = cos;
        this.sin = sin;
        this.tx = tx;
        this.ty = ty;
        this.invert();
    }

    @Override
    public RigidModel2D createInverse() {
        RigidModel2D ict = new RigidModel2D();
        ict.cos = this.cos;
        ict.sin = -this.sin;
        ict.tx = this.itx;
        ict.ty = this.ity;
        ict.itx = this.tx;
        ict.ity = this.ty;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(float[] data) {
        data[0] = this.cos;
        data[1] = this.sin;
        data[2] = -this.sin;
        data[3] = this.cos;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.cos;
        data[1] = this.sin;
        data[2] = -this.sin;
        data[3] = this.cos;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = this.cos;
        data[0][1] = -this.sin;
        data[0][2] = this.tx;
        data[1][0] = this.sin;
        data[1][1] = this.cos;
        data[1][1] = this.ty;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.cos;
        data[0][1] = -this.sin;
        data[0][2] = this.tx;
        data[1][0] = this.sin;
        data[1][1] = this.cos;
        data[1][1] = this.ty;
    }
}

