/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.Point;

public class PointMatch
implements Serializable {
    private static final long serialVersionUID = -4194179098872410057L;
    protected float strength = 1.0f;
    protected final Point p1;
    protected final Point p2;
    protected float[] weights;
    protected float weight;

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }

    protected void calculateWeight() {
        this.weight = 1.0f;
        float[] fArray = this.weights;
        int n = this.weights.length;
        int n2 = 0;
        while (n2 < n) {
            float wi = fArray[n2];
            this.weight *= wi;
            ++n2;
        }
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setWeights(float[] weights) {
        this.weights = (float[])weights.clone();
        this.calculateWeight();
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(int index, float weight) {
        this.weights[index] = weight;
        this.calculateWeight();
    }

    public float popWeight() {
        int l = this.weights.length - 1;
        float w = this.weights[l];
        if (l > 0) {
            float[] newWeights = new float[l];
            System.arraycopy(this.weights, 0, newWeights, 0, l);
            this.weights = newWeights;
            this.calculateWeight();
        } else {
            this.weight = 1.0f;
            this.weights[0] = 1.0f;
        }
        return w;
    }

    public void pushWeight(float w) {
        float[] newWeights = new float[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 0, this.weights.length);
        newWeights[this.weights.length] = w;
        this.weights = newWeights;
        this.weight *= w;
    }

    public float shiftWeight() {
        int l = this.weights.length - 1;
        float w = this.weights[0];
        if (l > 0) {
            float[] newWeights = new float[l];
            System.arraycopy(this.weights, 1, newWeights, 0, l);
            this.weights = newWeights;
            this.calculateWeight();
        } else {
            this.weight = 1.0f;
            this.weights[0] = 1.0f;
        }
        return w;
    }

    public void unshiftWeight(float w) {
        float[] newWeights = new float[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 1, this.weights.length);
        newWeights[0] = w;
        this.weights = newWeights;
        this.weight *= w;
    }

    public float getDistance() {
        return Point.distance(this.p1, this.p2);
    }

    public PointMatch(Point p1, Point p2, float[] weights, float strength) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = (float[])weights.clone();
        this.calculateWeight();
        this.strength = strength;
    }

    public PointMatch(Point p1, Point p2, float[] weights) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = (float[])weights.clone();
        this.calculateWeight();
    }

    public PointMatch(Point p1, Point p2, float weight) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new float[]{weight};
        this.weight = weight;
    }

    public PointMatch(Point p1, Point p2, float weight, float strength) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new float[]{weight};
        this.weight = weight;
        this.strength = strength;
    }

    public PointMatch(Point p1, Point p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new float[]{1.0f};
        this.weight = 1.0f;
    }

    public void apply(CoordinateTransform t) {
        this.p1.apply(t);
    }

    public void apply(CoordinateTransform t, float amount) {
        this.p1.apply(t, this.strength * amount);
    }

    public static void apply(Collection<? extends PointMatch> matches, CoordinateTransform t) {
        for (PointMatch pointMatch : matches) {
            pointMatch.apply(t);
        }
    }

    public static final void flip(Collection<PointMatch> matches, Collection<PointMatch> flippedMatches) {
        for (PointMatch match : matches) {
            flippedMatches.add(new PointMatch(match.p2, match.p1, match.weights));
        }
    }

    public static final Collection<PointMatch> flip(Collection<PointMatch> matches) {
        ArrayList<PointMatch> list = new ArrayList<PointMatch>();
        PointMatch.flip(matches, list);
        return list;
    }

    public static final void sourcePoints(Collection<PointMatch> matches, Collection<Point> sourcePoints) {
        for (PointMatch m : matches) {
            sourcePoints.add(m.getP1());
        }
    }

    public static final void cloneSourcePoints(Collection<PointMatch> matches, Collection<Point> sourcePoints) {
        for (PointMatch m : matches) {
            sourcePoints.add(m.getP1().clone());
        }
    }

    public static final void targetPoints(Collection<PointMatch> matches, Collection<Point> targetPoints) {
        for (PointMatch m : matches) {
            targetPoints.add(m.getP2());
        }
    }

    public static final void cloneTargetPoints(Collection<PointMatch> matches, Collection<Point> targetPoints) {
        for (PointMatch m : matches) {
            targetPoints.add(m.getP2().clone());
        }
    }

    public static float meanDistance(Collection<PointMatch> matches) {
        double d = 0.0;
        for (PointMatch match : matches) {
            d += (double)match.getDistance();
        }
        return (float)(d / (double)matches.size());
    }

    public static float maxDistance(Collection<PointMatch> matches) {
        float max = -3.4028235E38f;
        for (PointMatch match : matches) {
            float d = match.getDistance();
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }
}

