/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class Point
implements Serializable {
    private static final long serialVersionUID = 7779693088835156795L;
    protected final float[] w;
    protected final float[] l;

    public float[] getW() {
        return this.w;
    }

    public float[] getL() {
        return this.l;
    }

    public Point(float[] l, float[] w) {
        assert (l.length == w.length) : "Local and world coordinates have to have the same dimensionality.";
        this.l = l;
        this.w = w;
    }

    public Point(float[] l) {
        this(l, (float[])l.clone());
    }

    public final void apply(CoordinateTransform t) {
        System.arraycopy(this.l, 0, this.w, 0, this.l.length);
        t.applyInPlace(this.w);
    }

    public final void apply(CoordinateTransform t, float amount) {
        float[] a = t.apply(this.l);
        int i = 0;
        while (i < a.length) {
            int n = i;
            this.w[n] = this.w[n] + amount * (a[i] - this.w[i]);
            ++i;
        }
    }

    public final void applyInverse(InverseCoordinateTransform t) throws NoninvertibleModelException {
        System.arraycopy(this.l, 0, this.w, 0, this.l.length);
        t.applyInverseInPlace(this.w);
    }

    public float squareDistance() {
        double sum = 0.0;
        int i = 0;
        while (i < this.l.length) {
            double d = this.w[i] - this.l[i];
            sum += d * d;
            ++i;
        }
        return (float)sum;
    }

    public float distance() {
        return (float)Math.sqrt(this.squareDistance());
    }

    public static final float squareDistance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same number of dimensions.";
        double sum = 0.0;
        int i = 0;
        while (i < p1.w.length) {
            double d = p1.w[i] - p2.w[i];
            sum += d * d;
            ++i;
        }
        return (float)sum;
    }

    public static final float distance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same number of dimensions.";
        return (float)Math.sqrt(Point.squareDistance(p1, p2));
    }

    public static final float squareLocalDistance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same number of dimensions.";
        double sum = 0.0;
        int i = 0;
        while (i < p1.l.length) {
            double d = p1.l[i] - p2.l[i];
            sum += d * d;
            ++i;
        }
        return (float)sum;
    }

    public static final float localDistance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same number of dimensions.";
        return (float)Math.sqrt(Point.squareLocalDistance(p1, p2));
    }

    public Point clone() {
        Point p = new Point((float[])this.l.clone());
        int i = 0;
        while (i < this.w.length) {
            p.w[i] = this.w[i];
            ++i;
        }
        return p;
    }

    public static <P extends Point> void apply(CoordinateTransform t, Iterable<P> points) {
        for (Point p : points) {
            p.apply(t);
        }
    }

    public static void applyInverse(InverseCoordinateTransform t, Iterable<Point> points) throws NoninvertibleModelException {
        for (Point p : points) {
            p.applyInverse(t);
        }
    }
}

