/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractMovingLeastSquaresTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class MovingLeastSquaresTransform2
extends AbstractMovingLeastSquaresTransform {
    protected float[][] p;
    protected float[][] q;
    protected float[] w;

    @Override
    public final void setMatches(Collection<PointMatch> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int n = matches.size() > 0 ? matches.iterator().next().getP1().getL().length : 0;
        this.p = new float[n][matches.size()];
        this.q = new float[n][matches.size()];
        this.w = new float[matches.size()];
        int i = 0;
        for (PointMatch match : matches) {
            float[] pp = match.getP1().getL();
            float[] qq = match.getP2().getW();
            int d = 0;
            while (d < n) {
                this.p[d][i] = pp[d];
                this.q[d][i] = qq[d];
                ++d;
            }
            this.w[i] = match.getWeight();
            ++i;
        }
        if (n <= 0) {
            throw new NotEnoughDataPointsException("No matches passed.");
        }
        this.model.fit(this.p, this.q, this.w);
    }

    public final void setMatches(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.p = p;
        this.q = q;
        this.w = w;
        this.model.fit(p, q, w);
    }

    @Override
    public void applyInPlace(float[] location) {
        float[] ww = new float[this.w.length];
        int i = 0;
        while (i < this.w.length) {
            float s = 0.0f;
            int d = 0;
            while (d < location.length) {
                float dx = this.p[d][i] - location[d];
                s += dx * dx;
                ++d;
            }
            if (s <= 0.0f) {
                d = 0;
                while (d < location.length) {
                    location[d] = this.q[d][i];
                    ++d;
                }
                return;
            }
            ww[i] = this.w[i] * (float)this.weigh(s);
            ++i;
        }
        try {
            this.model.fit(this.p, this.q, ww);
            this.model.applyInPlace(location);
        }
        catch (IllDefinedDataPointsException illDefinedDataPointsException) {
        }
        catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            // empty catch block
        }
    }
}

