/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mpicbg.models.AbstractMovingLeastSquaresTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class MovingLeastSquaresTransform
extends AbstractMovingLeastSquaresTransform {
    protected final Set<PointMatch> matches = new HashSet<PointMatch>();

    public final Set<PointMatch> getMatches() {
        return this.matches;
    }

    @Override
    public final void setMatches(Collection<PointMatch> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.matches.clear();
        this.matches.addAll(matches);
        this.model.fit(matches);
    }

    @Override
    public void applyInPlace(float[] location) {
        ArrayList<PointMatch> weightedMatches = new ArrayList<PointMatch>();
        for (PointMatch m : this.matches) {
            float[] l = m.getP1().getL();
            float s = 0.0f;
            int i = 0;
            while (i < location.length) {
                float dx = l[i] - location[i];
                s += dx * dx;
                ++i;
            }
            if (s <= 0.0f) {
                float[] w = m.getP2().getW();
                int i2 = 0;
                while (i2 < location.length) {
                    location[i2] = w[i2];
                    ++i2;
                }
                return;
            }
            float weight = m.getWeight() * (float)this.weigh(s);
            PointMatch mw = new PointMatch(m.getP1(), m.getP2(), weight);
            weightedMatches.add(mw);
        }
        try {
            this.model.fit(weightedMatches);
            this.model.applyInPlace(location);
        }
        catch (IllDefinedDataPointsException illDefinedDataPointsException) {
        }
        catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            // empty catch block
        }
    }
}

