/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.HashMap;
import java.util.Set;
import mpicbg.models.AbstractModel;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.models.TransformMesh;

public class MovingLeastSquaresMesh<M extends AbstractModel<M>>
extends TransformMesh {
    protected final HashMap<PointMatch, Tile<M>> pt = new HashMap();
    protected double error = Double.MAX_VALUE;
    protected final Class<M> modelClass;

    public final HashMap<PointMatch, Tile<M>> getVerticeModelMap() {
        return this.pt;
    }

    public final Set<PointMatch> getVertices() {
        return this.pt.keySet();
    }

    public final int numVertices() {
        return this.pt.size();
    }

    public final double getError() {
        return this.error;
    }

    public final Class<M> getModelClass() {
        return this.modelClass;
    }

    public MovingLeastSquaresMesh(Class<M> modelClass, int numX, int numY, float width, float height) {
        super(numX, numY, width, height);
        this.modelClass = modelClass;
        Set s = this.va.keySet();
        for (PointMatch vertex : s) {
            try {
                AbstractModel model = (AbstractModel)modelClass.newInstance();
                Tile<AbstractModel> t = new Tile<AbstractModel>(model);
                this.pt.put(vertex, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MovingLeastSquaresMesh(Class<M> modelClass, int numX, float width, float height) {
        this(modelClass, numX, MovingLeastSquaresMesh.numY(numX, width, height), width, height);
    }

    protected final float weigh(float d, float alpha) {
        return 1.0f / (float)Math.pow(d, alpha);
    }

    public final Tile<M> findClosest(float[] there) {
        Set<PointMatch> s = this.pt.keySet();
        PointMatch closest = null;
        float cd = Float.MAX_VALUE;
        for (PointMatch vertex : s) {
            float dy;
            float[] here = vertex.getP2().getW();
            float dx = here[0] - there[0];
            float d = dx * dx + (dy = here[1] - there[1]) * dy;
            if (!(d < cd)) continue;
            cd = d;
            closest = vertex;
        }
        return this.pt.get(closest);
    }

    public final void addMatchWeightedByDistance(PointMatch pm, float alpha) {
        Set s = this.va.keySet();
        Tile<M> c = this.findClosest(pm.getP1().getW());
        float[] there = pm.getP1().getL();
        float[] oldWeights = pm.getWeights();
        float[] weights = new float[oldWeights.length + 1];
        System.arraycopy(oldWeights, 0, weights, 0, oldWeights.length);
        for (PointMatch m : s) {
            float[] here = m.getP1().getW();
            float dx = here[0] - there[0];
            float dy = here[1] - there[1];
            weights[oldWeights.length] = this.weigh(0.001f + dx * dx + dy * dy, alpha);
            Tile<M> t = this.pt.get(m);
            if (t == c) {
                t.addMatch(new PointMatch(pm.getP1(), pm.getP2(), weights, 1.0f));
                continue;
            }
            t.addMatch(new PointMatch(pm.getP1(), pm.getP2(), weights, 0.0f));
        }
    }

    public final void updateModels() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        Set s = this.va.keySet();
        this.error = 0.0;
        for (PointMatch m : s) {
            Tile<M> t = this.pt.get(m);
            t.fitModel();
            t.update();
            m.getP2().apply((CoordinateTransform)t.getModel());
            this.error += t.getDistance();
        }
        this.error /= (double)s.size();
    }

    public final void apply(CoordinateTransform t) {
        Set s = this.va.keySet();
        for (PointMatch m : s) {
            Set<PointMatch> matches = this.pt.get(m).getMatches();
            for (PointMatch match : matches) {
                match.apply(t);
            }
            m.getP2().apply(t);
            this.updateAffine(m);
        }
    }
}

