/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class InverseCoordinateTransformMap2D
implements InverseCoordinateTransform {
    protected final float[][] map;
    protected final int width;
    protected final int height;

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public InverseCoordinateTransformMap2D(float[][] map) {
        this.map = map;
        this.width = map[0].length / 2;
        this.height = map.length;
    }

    public InverseCoordinateTransformMap2D(InverseCoordinateTransform t, int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new float[height][width * 2];
        float[] l = new float[2];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                l[0] = x;
                l[1] = y;
                try {
                    t.applyInverseInPlace(l);
                    this.map[y][2 * x] = l[0];
                    this.map[y][2 * x + 1] = l[1];
                }
                catch (NoninvertibleModelException e) {
                    this.map[y][2 * x] = Float.NaN;
                    this.map[y][2 * x + 1] = Float.NaN;
                }
                ++x;
            }
            ++y;
        }
    }

    public InverseCoordinateTransformMap2D(FileInputStream fis) throws IOException {
        byte[] header = new byte[8];
        fis.read(header);
        long longWidth = ((0xFFL & (long)header[0]) << 24) + ((0xFFL & (long)header[1]) << 16) + ((0xFFL & (long)header[2]) << 8) + (0xFFL & (long)header[3]);
        this.width = (int)longWidth;
        long longHeight = ((0xFFL & (long)header[4]) << 24) + ((0xFFL & (long)header[5]) << 16) + ((0xFFL & (long)header[6]) << 8) + (0xFFL & (long)header[7]);
        this.height = (int)longHeight;
        this.map = new float[this.height][2 * this.width];
        byte[] byteRow = new byte[this.width * 8];
        int y = 0;
        while (y < this.height) {
            fis.read(byteRow);
            float[] row = this.map[y];
            int i = 0;
            while (i < row.length) {
                int j = 4 * i;
                int tx = (0xFF & byteRow[j]) << 24 | (0xFF & byteRow[j + 1]) << 16 | (0xFF & byteRow[j + 2]) << 8 | 0xFF & byteRow[j + 3];
                int ty = (0xFF & byteRow[j + 4]) << 24 | (0xFF & byteRow[j + 5]) << 16 | (0xFF & byteRow[j + 6]) << 8 | 0xFF & byteRow[j + 7];
                row[i] = Float.intBitsToFloat(tx);
                row[i + 1] = Float.intBitsToFloat(ty);
                i += 2;
            }
            ++y;
        }
    }

    public void export(FileOutputStream fos) throws IOException {
        byte[] header = new byte[]{(byte)(this.width >> 24), (byte)(this.width >> 16), (byte)(this.width >> 8), (byte)this.width, (byte)(this.height >> 24), (byte)(this.height >> 16), (byte)(this.height >> 8), (byte)this.height};
        fos.write(header);
        byte[] byteRow = new byte[this.width * 8];
        int y = 0;
        while (y < this.height) {
            float[] row = this.map[y];
            int i = 0;
            while (i < row.length) {
                int j = 4 * i;
                int tx = Float.floatToIntBits(row[i]);
                int ty = Float.floatToIntBits(row[i + 1]);
                byteRow[j] = (byte)(tx >> 24);
                byteRow[j + 1] = (byte)(tx >> 16);
                byteRow[j + 2] = (byte)(tx >> 8);
                byteRow[j + 3] = (byte)tx;
                byteRow[j + 4] = (byte)(ty >> 24);
                byteRow[j + 5] = (byte)(ty >> 16);
                byteRow[j + 6] = (byte)(ty >> 8);
                byteRow[j + 7] = (byte)ty;
                i += 2;
            }
            fos.write(byteRow);
            ++y;
        }
        fos.close();
    }

    @Override
    public float[] applyInverse(float[] location) {
        float[] t = (float[])location.clone();
        this.applyInverseInPlace(t);
        return t;
    }

    @Override
    public void applyInverseInPlace(float[] location) {
        int ix = 2 * (int)location[0];
        int iy = (int)location[1];
        float x = this.map[iy][ix];
        float y = this.map[iy][ix + 1];
        location[0] = x;
        location[1] = y;
    }
}

