/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import mpicbg.models.InverseBoundable;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.TransformList;
import mpicbg.util.Util;

public class InverseCoordinateTransformList<E extends InverseCoordinateTransform>
implements InverseBoundable,
TransformList<E> {
    private final List<E> transforms = new ArrayList();

    @Override
    public final void add(E t) {
        this.transforms.add(t);
    }

    @Override
    public final void remove(E t) {
        this.transforms.remove(t);
    }

    @Override
    public final E remove(int i) {
        return (E)((InverseCoordinateTransform)this.transforms.remove(i));
    }

    @Override
    public final E get(int i) {
        return (E)((InverseCoordinateTransform)this.transforms.get(i));
    }

    @Override
    public final void clear() {
        this.transforms.clear();
    }

    @Override
    public final List<E> getList(List<E> preAllocatedList) {
        ArrayList<E> returnList = preAllocatedList == null ? new ArrayList<E>() : preAllocatedList;
        returnList.addAll(this.transforms);
        return returnList;
    }

    @Override
    public final float[] applyInverse(float[] location) throws NoninvertibleModelException {
        float[] a = (float[])location.clone();
        this.applyInverseInPlace(a);
        return a;
    }

    @Override
    public final void applyInverseInPlace(float[] location) throws NoninvertibleModelException {
        ListIterator<E> i = this.transforms.listIterator(this.transforms.size());
        while (i.hasPrevious()) {
            ((InverseCoordinateTransform)i.previous()).applyInverseInPlace(location);
        }
    }

    @Override
    public void estimateInverseBounds(float[] min, float[] max) throws NoninvertibleModelException {
        assert (min.length == max.length) : "min and max have to have equal length.";
        int g = 32;
        float[] minBounds = new float[min.length];
        float[] maxBounds = new float[min.length];
        float[] s = new float[min.length];
        int[] i = new int[min.length];
        float[] l = new float[min.length];
        int k = 0;
        while (k < min.length) {
            minBounds[k] = Float.MAX_VALUE;
            maxBounds[k] = -3.4028235E38f;
            s[k] = (max[k] - min[k]) / 31.0f;
            l[k] = min[k];
            ++k;
        }
        long d = Util.pow(32, min.length);
        long j = 0L;
        while (j < d) {
            float[] m = this.applyInverse(l);
            int k2 = 0;
            while (k2 < min.length) {
                if (m[k2] < minBounds[k2]) {
                    minBounds[k2] = m[k2];
                }
                if (m[k2] > maxBounds[k2]) {
                    maxBounds[k2] = m[k2];
                }
                ++k2;
            }
            k2 = 0;
            while (k2 < min.length) {
                int n = k2;
                i[n] = i[n] + 1;
                if (i[k2] < 32) {
                    l[k2] = min[k2] + (float)i[k2] * s[k2];
                    break;
                }
                i[k2] = 0;
                l[k2] = min[k2];
                ++k2;
            }
            ++j;
        }
        int k3 = 0;
        while (k3 < min.length) {
            min[k3] = minBounds[k3];
            max[k3] = maxBounds[k3];
            ++k3;
        }
    }
}

