/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractModel;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class InterpolatedModel<A extends Model<A>, B extends Model<B>, M extends InterpolatedModel<A, B, M>>
extends AbstractModel<M> {
    protected final A a;
    protected final B b;
    protected float lambda;
    protected float l1;

    public InterpolatedModel(A a, B b, float lambda) {
        this.a = a;
        this.b = b;
        this.lambda = lambda;
        this.l1 = 1.0f - lambda;
    }

    public A getA() {
        return this.a;
    }

    public B getB() {
        return this.b;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(float lambda) {
        this.lambda = lambda;
        this.l1 = 1.0f - lambda;
    }

    @Override
    public int getMinNumMatches() {
        return Math.max(this.a.getMinNumMatches(), this.b.getMinNumMatches());
    }

    @Override
    public <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.a.fit(matches);
        this.b.fit(matches);
    }

    @Override
    public void set(M m) {
        this.a.set(((InterpolatedModel)m).a);
        this.b.set(((InterpolatedModel)m).b);
        this.lambda = ((InterpolatedModel)m).lambda;
        this.l1 = ((InterpolatedModel)m).l1;
        this.cost = ((InterpolatedModel)m).cost;
    }

    @Override
    public M copy() {
        InterpolatedModel copy = new InterpolatedModel(this.a.copy(), this.b.copy(), this.lambda);
        copy.cost = this.cost;
        return (M)copy;
    }

    @Override
    public float[] apply(float[] location) {
        float[] copy = (float[])location.clone();
        this.applyInPlace(copy);
        return copy;
    }

    @Override
    public void applyInPlace(float[] location) {
        float[] copy = this.b.apply(location);
        this.a.applyInPlace(location);
        int d = 0;
        while (d < location.length) {
            float dd = copy[d] - location[d];
            int n = d++;
            location[n] = location[n] + this.lambda * dd;
        }
    }
}

