/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.Affine3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleInterpolatedModel;
import mpicbg.models.Model;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public final class InterpolatedAffineModel3D<A extends Model<A> & Affine3D<A>, B extends Model<B> & Affine3D<B>>
extends InvertibleInterpolatedModel<A, B, InterpolatedAffineModel3D<A, B>>
implements Affine3D<InterpolatedAffineModel3D<A, B>> {
    protected final AffineModel3D affine = new AffineModel3D();
    protected final float[] afs = new float[12];
    protected final float[] bfs = new float[12];

    public InterpolatedAffineModel3D(A model, B regularizer, float lambda) {
        super(model, regularizer, lambda);
        this.interpolate();
    }

    protected void interpolate() {
        ((Affine3D)((Object)this.a)).toArray(this.afs);
        ((Affine3D)((Object)this.b)).toArray(this.bfs);
        int i = 0;
        while (i < this.afs.length) {
            this.afs[i] = this.afs[i] * this.l1 + this.bfs[i] * this.lambda;
            ++i;
        }
        this.affine.set(this.afs[0], this.afs[3], this.afs[6], this.afs[9], this.afs[1], this.afs[4], this.afs[7], this.afs[10], this.afs[2], this.afs[5], this.afs[8], this.afs[11]);
    }

    @Override
    public <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        super.fit(matches);
        this.interpolate();
    }

    @Override
    public void set(InterpolatedAffineModel3D<A, B> m) {
        super.set(m);
        if (InterpolatedAffineModel3D.class.isInstance(m)) {
            this.affine.set(m.affine);
        }
    }

    @Override
    public InterpolatedAffineModel3D<A, B> copy() {
        InterpolatedAffineModel3D copy = new InterpolatedAffineModel3D(this.a.copy(), this.b.copy(), this.lambda);
        copy.cost = this.cost;
        return copy;
    }

    @Override
    public float[] apply(float[] location) {
        float[] copy = (float[])location.clone();
        this.applyInPlace(copy);
        return copy;
    }

    @Override
    public void applyInPlace(float[] location) {
        this.affine.applyInPlace(location);
    }

    @Override
    public float[] applyInverse(float[] point) throws NoninvertibleModelException {
        float[] copy = (float[])point.clone();
        this.applyInverseInPlace(copy);
        return copy;
    }

    @Override
    public void applyInverseInPlace(float[] point) throws NoninvertibleModelException {
        this.affine.applyInverseInPlace(point);
    }

    @Override
    public InterpolatedAffineModel3D<A, B> createInverse() {
        InterpolatedAffineModel3D<Model, Model> inverse = new InterpolatedAffineModel3D<Model, Model>((Model)((Affine3D)((Object)this.a)).createInverse(), (Model)((Affine3D)((Object)this.b)).createInverse(), this.lambda);
        inverse.cost = this.cost;
        return inverse;
    }

    public AffineModel3D createAffineModel3D() {
        return this.affine.copy();
    }

    @Override
    public void preConcatenate(InterpolatedAffineModel3D<A, B> affine3d) {
        this.affine.preConcatenate(affine3d.affine);
    }

    @Override
    public void concatenate(InterpolatedAffineModel3D<A, B> affine3d) {
        this.affine.concatenate(affine3d.affine);
    }

    @Override
    public void toArray(float[] data) {
        this.affine.toArray(data);
    }

    @Override
    public void toArray(double[] data) {
        this.affine.toArray(data);
    }

    @Override
    public void toMatrix(float[][] data) {
        this.affine.toMatrix(data);
    }

    @Override
    public void toMatrix(double[][] data) {
        this.affine.toMatrix(data);
    }
}

