/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.Affine2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleInterpolatedModel;
import mpicbg.models.Model;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public final class InterpolatedAffineModel2D<A extends Model<A> & Affine2D<A>, B extends Model<B> & Affine2D<B>>
extends InvertibleInterpolatedModel<A, B, InterpolatedAffineModel2D<A, B>>
implements Affine2D<InterpolatedAffineModel2D<A, B>> {
    protected final AffineModel2D affine = new AffineModel2D();
    protected final float[] afs = new float[6];
    protected final float[] bfs = new float[6];

    public InterpolatedAffineModel2D(A model, B regularizer, float lambda) {
        super(model, regularizer, lambda);
        this.interpolate();
    }

    protected void interpolate() {
        ((Affine2D)((Object)this.a)).toArray(this.afs);
        ((Affine2D)((Object)this.b)).toArray(this.bfs);
        int i = 0;
        while (i < this.afs.length) {
            this.afs[i] = this.afs[i] * this.l1 + this.bfs[i] * this.lambda;
            ++i;
        }
        this.affine.set(this.afs[0], this.afs[1], this.afs[2], this.afs[3], this.afs[4], this.afs[5]);
    }

    @Override
    public <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        super.fit(matches);
        this.interpolate();
    }

    @Override
    public void set(InterpolatedAffineModel2D<A, B> m) {
        super.set(m);
        if (InterpolatedAffineModel2D.class.isInstance(m)) {
            this.affine.set(m.affine);
        }
    }

    @Override
    public InterpolatedAffineModel2D<A, B> copy() {
        InterpolatedAffineModel2D copy = new InterpolatedAffineModel2D(this.a.copy(), this.b.copy(), this.lambda);
        copy.cost = this.cost;
        return copy;
    }

    @Override
    public float[] apply(float[] location) {
        float[] copy = (float[])location.clone();
        this.applyInPlace(copy);
        return copy;
    }

    @Override
    public void applyInPlace(float[] location) {
        this.affine.applyInPlace(location);
    }

    @Override
    public float[] applyInverse(float[] point) throws NoninvertibleModelException {
        float[] copy = (float[])point.clone();
        this.applyInverseInPlace(copy);
        return copy;
    }

    @Override
    public void applyInverseInPlace(float[] point) throws NoninvertibleModelException {
        this.affine.applyInverseInPlace(point);
    }

    @Override
    public InterpolatedAffineModel2D<A, B> createInverse() {
        InterpolatedAffineModel2D<Model, Model> inverse = new InterpolatedAffineModel2D<Model, Model>((Model)((Affine2D)((Object)this.a)).createInverse(), (Model)((Affine2D)((Object)this.b)).createInverse(), this.lambda);
        inverse.cost = this.cost;
        return inverse;
    }

    public AffineModel2D createAffineModel2D() {
        return this.affine.copy();
    }

    @Override
    public AffineTransform createAffine() {
        return this.affine.createAffine();
    }

    @Override
    public AffineTransform createInverseAffine() {
        return this.affine.createInverseAffine();
    }

    @Override
    public void preConcatenate(InterpolatedAffineModel2D<A, B> affine2d) {
        this.affine.preConcatenate(affine2d.affine);
    }

    @Override
    public void concatenate(AffineModel2D affine2d) {
        this.affine.concatenate(affine2d);
    }

    @Override
    public void preConcatenate(AffineModel2D affine2d) {
        this.affine.preConcatenate(affine2d);
    }

    @Override
    public void concatenate(InterpolatedAffineModel2D<A, B> affine2d) {
        this.affine.concatenate(affine2d.affine);
    }

    @Override
    public void toArray(float[] data) {
        this.affine.toArray(data);
    }

    @Override
    public void toArray(double[] data) {
        this.affine.toArray(data);
    }

    @Override
    public void toMatrix(float[][] data) {
        this.affine.toMatrix(data);
    }

    @Override
    public void toMatrix(double[][] data) {
        this.affine.toMatrix(data);
    }

    public final void set(float m00, float m10, float m01, float m11, float m02, float m12) {
        this.affine.set(m00, m10, m01, m11, m02, m12);
    }

    @Override
    public final void set(AffineTransform a) {
        this.affine.set(a);
    }
}

