/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.util.Collection;
import mpicbg.models.AbstractModel;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.util.Matrix3x3;

public class HomographyModel2D
extends AbstractModel<HomographyModel2D>
implements InvertibleBoundable {
    protected static final int MIN_NUM_MATCHES = 4;
    protected float m00 = 1.0f;
    protected float m01 = 0.0f;
    protected float m02 = 0.0f;
    protected float m10 = 0.0f;
    protected float m11 = 1.0f;
    protected float m12 = 0.0f;
    protected float m20 = 0.0f;
    protected float m21 = 0.0f;
    protected float m22 = 1.0f;
    protected float i00 = 1.0f;
    protected float i01 = 0.0f;
    protected float i02 = 0.0f;
    protected float i10 = 0.0f;
    protected float i11 = 1.0f;
    protected float i12 = 0.0f;
    protected float i20 = 0.0f;
    protected float i21 = 0.0f;
    protected float i22 = 1.0f;

    @Override
    public final int getMinNumMatches() {
        return 4;
    }

    public void set(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.invert();
    }

    private final void invert() {
        float det = Matrix3x3.det(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        this.i00 = (this.m11 * this.m22 - this.m12 * this.m21) / det;
        this.i01 = (this.m02 * this.m21 - this.m01 * this.m22) / det;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) / det;
        this.i10 = (this.m12 * this.m20 - this.m10 * this.m22) / det;
        this.i11 = (this.m00 * this.m22 - this.m02 * this.m20) / det;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) / det;
        this.i20 = (this.m10 * this.m21 - this.m11 * this.m20) / det;
        this.i21 = (this.m01 * this.m20 - this.m00 * this.m21) / det;
        this.i22 = (this.m00 * this.m11 - this.m01 * this.m10) / det;
    }

    private static final float[] fitToUnitSquare(float[] p1, float[] p2, float[] p3, float[] p4) {
        float x1 = p1[0];
        float x2 = p2[0];
        float x3 = p3[0];
        float x4 = p4[0];
        float y1 = p1[1];
        float y2 = p2[1];
        float y3 = p3[1];
        float y4 = p4[1];
        float s = (x2 - x3) * (y4 - y3) - (x4 - x3) * (y2 - y3);
        float b20 = ((x1 - x2 + x3 - x4) * (y4 - y3) - (y1 - y2 + y3 - y4) * (x4 - x3)) / s;
        float b21 = ((y1 - y2 + y3 - y4) * (x2 - x3) - (x1 - x2 + x3 - x4) * (y2 - y3)) / s;
        float b00 = x2 - x1 + b20 * x2;
        float b01 = x4 - x1 + b21 * x4;
        float b02 = x1;
        float b10 = y2 - y1 + b20 * y2;
        float b11 = y4 - y1 + b21 * y4;
        float b12 = y1;
        float b22 = 1.0f;
        return new float[]{b00, b01, b02, b10, b11, b12, b20, b21, b22};
    }

    @Override
    public final float[] apply(float[] point) {
        assert (point.length >= 2) : "2d homographies can be applied to 2d points only.";
        float[] t = (float[])point.clone();
        this.applyInPlace(t);
        return t;
    }

    @Override
    public final void applyInPlace(float[] point) {
        assert (point.length >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.m20 * point[0] + this.m21 * point[1] + this.m22;
        double t0 = this.m00 * point[0] + this.m01 * point[1] + this.m02;
        double t1 = this.m10 * point[0] + this.m11 * point[1] + this.m12;
        point[0] = (float)(t0 / s);
        point[1] = (float)(t1 / s);
    }

    @Override
    public final float[] applyInverse(float[] point) throws NoninvertibleModelException {
        assert (point.length >= 2) : "2d homographies can be applied to 2d points only.";
        float[] t = (float[])point.clone();
        this.applyInPlace(t);
        return null;
    }

    @Override
    public final void applyInverseInPlace(float[] point) throws NoninvertibleModelException {
        assert (point.length >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.i20 * point[0] + this.i21 * point[1] + this.i22;
        double t0 = this.i00 * point[0] + this.i01 * point[1] + this.i02;
        double t1 = this.i10 * point[0] + this.i11 * point[1] + this.i12;
        point[0] = (float)(t0 / s);
        point[1] = (float)(t1 / s);
    }

    @Override
    public final void set(HomographyModel2D m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.i00 = m.i00;
        this.i01 = m.i01;
        this.i02 = m.i02;
        this.i10 = m.i10;
        this.i11 = m.i11;
        this.i12 = m.i12;
        this.i20 = m.i20;
        this.i21 = m.i21;
        this.i22 = m.i22;
        this.cost = m.getCost();
    }

    @Override
    public final HomographyModel2D copy() {
        HomographyModel2D m = new HomographyModel2D();
        m.m00 = this.m00;
        m.m01 = this.m01;
        m.m02 = this.m02;
        m.m10 = this.m10;
        m.m11 = this.m11;
        m.m12 = this.m12;
        m.m20 = this.m20;
        m.m21 = this.m21;
        m.m22 = this.m22;
        m.i00 = this.i00;
        m.i01 = this.i01;
        m.i02 = this.i02;
        m.i10 = this.i10;
        m.i11 = this.i11;
        m.i12 = this.i12;
        m.i20 = this.i20;
        m.i21 = this.i21;
        m.i22 = this.i22;
        m.cost = this.getCost();
        return m;
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 4) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 2d homography model, at least " + 4 + " data points required.");
        }
        if (matches.size() == 4) {
            PointMatch[] p = new PointMatch[4];
            matches.toArray(p);
            float[] h1 = HomographyModel2D.fitToUnitSquare(p[0].getP1().getL(), p[1].getP1().getL(), p[2].getP1().getL(), p[3].getP1().getL());
            float[] h2 = HomographyModel2D.fitToUnitSquare(p[0].getP2().getW(), p[1].getP2().getW(), p[2].getP2().getW(), p[3].getP2().getW());
            try {
                Matrix3x3.invert(h1);
                this.m00 = h2[0] * h1[0] + h2[1] * h1[3] + h2[2] * h1[6];
                this.m01 = h2[0] * h1[1] + h2[1] * h1[4] + h2[2] * h1[7];
                this.m02 = h2[0] * h1[2] + h2[1] * h1[5] + h2[2] * h1[8];
                this.m10 = h2[3] * h1[0] + h2[4] * h1[3] + h2[5] * h1[6];
                this.m11 = h2[3] * h1[1] + h2[4] * h1[4] + h2[5] * h1[7];
                this.m12 = h2[3] * h1[2] + h2[4] * h1[5] + h2[5] * h1[8];
                this.m20 = h2[6] * h1[0] + h2[7] * h1[3] + h2[8] * h1[6];
                this.m21 = h2[6] * h1[1] + h2[7] * h1[4] + h2[8] * h1[7];
                this.m22 = h2[6] * h1[2] + h2[7] * h1[5] + h2[8] * h1[8];
                this.invert();
            }
            catch (NoninvertibleModelException e) {
                throw new IllDefinedDataPointsException();
            }
        } else {
            int n = matches.size() * 2;
            double[][] a = new double[n][9];
            int i = 0;
            for (PointMatch pm : matches) {
                float[] p = pm.getP1().getL();
                float[] q = pm.getP2().getW();
                double px = p[0];
                double py = p[1];
                double qx = q[0];
                double qy = q[1];
                if (Double.isInfinite(px) || Double.isNaN(px)) {
                    px = 1.0;
                }
                if (Double.isInfinite(py) || Double.isNaN(py)) {
                    py = 1.0;
                }
                if (Double.isInfinite(qx) || Double.isNaN(qx)) {
                    qx = 1.0;
                }
                if (Double.isInfinite(qy) || Double.isNaN(qy)) {
                    qy = 1.0;
                }
                a[i][0] = -px;
                a[i][1] = -py;
                a[i][2] = -1.0;
                a[i][6] = qx * px;
                a[i][7] = qx * py;
                a[i++][8] = qx;
                a[i][3] = -px;
                a[i][4] = -py;
                a[i][5] = -1.0;
                a[i][6] = qy * px;
                a[i][7] = qy * py;
                a[i++][8] = qy;
            }
            Matrix mA = new Matrix(a);
            SingularValueDecomposition svd = new SingularValueDecomposition(mA);
            Matrix s = svd.getS();
            Matrix v = svd.getV();
            this.cost = s.get(8, 8);
            this.m00 = (float)v.get(0, 8);
            this.m01 = (float)v.get(1, 8);
            this.m02 = (float)v.get(2, 8);
            this.m10 = (float)v.get(3, 8);
            this.m11 = (float)v.get(4, 8);
            this.m12 = (float)v.get(5, 8);
            this.m20 = (float)v.get(6, 8);
            this.m21 = (float)v.get(7, 8);
            this.m22 = (float)v.get(8, 8);
            this.invert();
        }
    }

    public final String toString() {
        return "| " + this.m00 + " " + this.m01 + " " + this.m02 + " |\n" + "| " + this.m10 + " " + this.m11 + " " + this.m12 + " |\n" + "| " + this.m20 + " " + this.m21 + " " + this.m22 + " |";
    }

    @Override
    public void estimateBounds(float[] min, float[] max) {
        assert (min.length >= 2 && max.length >= 2) : "2d homographies can be applied to 2d points only.";
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float[] l = (float[])min.clone();
        this.applyInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        }
        if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        }
        if (l[1] > maxY) {
            maxY = l[1];
        }
        l[0] = min[0];
        l[1] = max[1];
        this.applyInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        } else if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        } else if (l[1] > maxY) {
            maxY = l[1];
        }
        l[0] = max[0];
        l[1] = max[1];
        this.applyInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        } else if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        } else if (l[1] > maxY) {
            maxY = l[1];
        }
        l[0] = max[0];
        l[1] = min[1];
        this.applyInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        } else if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        } else if (l[1] > maxY) {
            maxY = l[1];
        }
        min[0] = minX;
        min[1] = minY;
        max[0] = maxX;
        max[1] = maxY;
    }

    @Override
    public void estimateInverseBounds(float[] min, float[] max) throws NoninvertibleModelException {
        assert (min.length >= 2 && max.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float[] l = (float[])min.clone();
        this.applyInverseInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        }
        if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        }
        if (l[1] > maxY) {
            maxY = l[1];
        }
        l[0] = min[0];
        l[1] = max[1];
        this.applyInverseInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        } else if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        } else if (l[1] > maxY) {
            maxY = l[1];
        }
        l[0] = max[0];
        l[1] = max[1];
        this.applyInverseInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        } else if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        } else if (l[1] > maxY) {
            maxY = l[1];
        }
        l[0] = max[0];
        l[1] = min[1];
        this.applyInverseInPlace(l);
        if (l[0] < minX) {
            minX = l[0];
        } else if (l[0] > maxX) {
            maxX = l[0];
        }
        if (l[1] < minY) {
            minY = l[1];
        } else if (l[1] > maxY) {
            maxY = l[1];
        }
        min[0] = minX;
        min[1] = minY;
        max[0] = maxX;
        max[1] = maxY;
    }

    @Override
    public final HomographyModel2D createInverse() {
        HomographyModel2D m = new HomographyModel2D();
        m.m00 = this.i00;
        m.m01 = this.i01;
        m.m02 = this.i02;
        m.m10 = this.i00;
        m.m11 = this.i11;
        m.m12 = this.i12;
        m.m20 = this.i20;
        m.m21 = this.i21;
        m.m22 = this.i22;
        m.i00 = this.m00;
        m.i01 = this.m01;
        m.i02 = this.m02;
        m.i10 = this.m00;
        m.i11 = this.m11;
        m.i12 = this.m12;
        m.i20 = this.m20;
        m.i21 = this.m21;
        m.i22 = this.m22;
        m.cost = this.getCost();
        return m;
    }
}

