/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.List;
import mpicbg.models.Boundable;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.TransformList;
import mpicbg.util.Util;

public class CoordinateTransformList<E extends CoordinateTransform>
implements Boundable,
TransformList<E> {
    protected final List<E> transforms = new ArrayList();

    @Override
    public final void add(E t) {
        this.transforms.add(t);
    }

    @Override
    public final void remove(E t) {
        this.transforms.remove(t);
    }

    @Override
    public final E remove(int i) {
        return (E)((CoordinateTransform)this.transforms.remove(i));
    }

    @Override
    public final E get(int i) {
        return (E)((CoordinateTransform)this.transforms.get(i));
    }

    @Override
    public final void clear() {
        this.transforms.clear();
    }

    @Override
    public final List<E> getList(List<E> preAllocatedList) {
        ArrayList<E> returnList = preAllocatedList == null ? new ArrayList<E>() : preAllocatedList;
        returnList.addAll(this.transforms);
        return returnList;
    }

    @Override
    public final float[] apply(float[] location) {
        float[] a = (float[])location.clone();
        this.applyInPlace(a);
        return a;
    }

    @Override
    public final void applyInPlace(float[] location) {
        for (CoordinateTransform t : this.transforms) {
            t.applyInPlace(location);
        }
    }

    @Override
    public void estimateBounds(float[] min, float[] max) {
        assert (min.length == max.length) : "min and max have to have equal length.";
        int g = 32;
        float[] minBounds = new float[min.length];
        float[] maxBounds = new float[min.length];
        float[] s = new float[min.length];
        int[] i = new int[min.length];
        float[] l = new float[min.length];
        int k = 0;
        while (k < min.length) {
            minBounds[k] = Float.MAX_VALUE;
            maxBounds[k] = -3.4028235E38f;
            s[k] = (max[k] - min[k]) / 31.0f;
            l[k] = min[k];
            ++k;
        }
        long d = Util.pow(32, min.length);
        long j = 0L;
        while (j < d) {
            float[] m = this.apply(l);
            int k2 = 0;
            while (k2 < min.length) {
                if (m[k2] < minBounds[k2]) {
                    minBounds[k2] = m[k2];
                }
                if (m[k2] > maxBounds[k2]) {
                    maxBounds[k2] = m[k2];
                }
                ++k2;
            }
            k2 = 0;
            while (k2 < min.length) {
                int n = k2;
                i[n] = i[n] + 1;
                if (i[k2] < 32) {
                    l[k2] = min[k2] + (float)i[k2] * s[k2];
                    break;
                }
                i[k2] = 0;
                l[k2] = min[k2];
                ++k2;
            }
            ++j;
        }
        int k3 = 0;
        while (k3 < min.length) {
            min[k3] = minBounds[k3];
            max[k3] = maxBounds[k3];
            ++k3;
        }
    }
}

