/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.TranslationModel3D;
import mpicbg.util.Matrix3x3;

public class AffineModel3D
extends AbstractAffineModel3D<AffineModel3D>
implements InvertibleBoundable {
    protected static final int MIN_NUM_MATCHES = 4;
    protected float m00 = 1.0f;
    protected float m01 = 0.0f;
    protected float m02 = 0.0f;
    protected float m03 = 0.0f;
    protected float m10 = 0.0f;
    protected float m11 = 1.0f;
    protected float m12 = 0.0f;
    protected float m13 = 0.0f;
    protected float m20 = 0.0f;
    protected float m21 = 0.0f;
    protected float m22 = 1.0f;
    protected float m23 = 0.0f;
    protected float i00 = 1.0f;
    protected float i01 = 0.0f;
    protected float i02 = 0.0f;
    protected float i03 = 0.0f;
    protected float i10 = 0.0f;
    protected float i11 = 1.0f;
    protected float i12 = 0.0f;
    protected float i13 = 0.0f;
    protected float i20 = 0.0f;
    protected float i21 = 0.0f;
    protected float i22 = 1.0f;
    protected float i23 = 0.0f;
    protected boolean isInvertible = true;

    @Override
    public float[] getMatrix(float[] m) {
        float[] a = m == null || m.length != 12 ? new float[12] : m;
        a[0] = this.m00;
        a[1] = this.m01;
        a[2] = this.m02;
        a[3] = this.m03;
        a[4] = this.m10;
        a[5] = this.m11;
        a[6] = this.m12;
        a[7] = this.m13;
        a[8] = this.m20;
        a[9] = this.m21;
        a[10] = this.m22;
        a[11] = this.m23;
        return a;
    }

    @Override
    public final int getMinNumMatches() {
        return 4;
    }

    @Override
    public final float[] apply(float[] l) {
        float[] transformed = (float[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        float l0 = l[0];
        float l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02 + this.m03;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12 + this.m13;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22 + this.m23;
    }

    @Override
    public final float[] applyInverse(float[] l) throws NoninvertibleModelException {
        float[] transformed = (float[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(float[] l) throws NoninvertibleModelException {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        float l0 = l[0];
        float l1 = l[1];
        l[0] = l0 * this.i00 + l1 * this.i01 + l[2] * this.i02 + this.i03;
        l[1] = l0 * this.i10 + l1 * this.i11 + l[2] * this.i12 + this.i13;
        l[2] = l0 * this.i20 + l1 * this.i21 + l[2] * this.i22 + this.i23;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 3 && q.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 4) {
            throw new NotEnoughDataPointsException(String.valueOf(l) + " data points are not enough to estimate a 2d affine model, at least " + 4 + " data points required.");
        }
        float pcx = 0.0f;
        float pcy = 0.0f;
        float pcz = 0.0f;
        float qcx = 0.0f;
        float qcy = 0.0f;
        float qcz = 0.0f;
        double ws = 0.0;
        int i = 0;
        while (i < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] pZ = p[2];
            float[] qX = q[0];
            float[] qY = q[1];
            float[] qZ = q[2];
            float ww = w[i];
            ws += (double)ww;
            pcx += ww * pX[i];
            pcy += ww * pY[i];
            pcz += ww * pZ[i];
            qcx += ww * qX[i];
            qcy += ww * qY[i];
            qcz += ww * qZ[i];
            ++i;
        }
        pcx = (float)((double)pcx / ws);
        pcy = (float)((double)pcy / ws);
        pcz = (float)((double)pcz / ws);
        qcx = (float)((double)qcx / ws);
        qcy = (float)((double)qcy / ws);
        qcz = (float)((double)qcz / ws);
        float b22 = 0.0f;
        float b21 = 0.0f;
        float b20 = 0.0f;
        float b12 = 0.0f;
        float b11 = 0.0f;
        float b10 = 0.0f;
        float b02 = 0.0f;
        float b01 = 0.0f;
        float b00 = 0.0f;
        float a22 = 0.0f;
        float a12 = 0.0f;
        float a11 = 0.0f;
        float a02 = 0.0f;
        float a01 = 0.0f;
        float a00 = 0.0f;
        int i2 = 0;
        while (i2 < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] pZ = p[2];
            float[] qX = q[0];
            float[] qY = q[1];
            float[] qZ = q[2];
            float ww = w[i2];
            float px = pX[i2] - pcx;
            float py = pY[i2] - pcy;
            float pz = pZ[i2] - pcz;
            float qx = qX[i2] - qcx;
            float qy = qY[i2] - qcy;
            float qz = qZ[i2] - qcz;
            a00 += ww * px * px;
            a01 += ww * px * py;
            a02 += ww * px * pz;
            a11 += ww * py * py;
            a12 += ww * py * pz;
            a22 += ww * pz * pz;
            b00 += ww * px * qx;
            b01 += ww * px * qy;
            b02 += ww * px * qz;
            b10 += ww * py * qx;
            b11 += ww * py * qy;
            b12 += ww * py * qz;
            b20 += ww * pz * qx;
            b21 += ww * pz * qy;
            b22 += ww * pz * qz;
            ++i2;
        }
        float det = a00 * a11 * a22 + a01 * a12 * a02 + a02 * a01 * a12 - a02 * a11 * a02 - a12 * a12 * a00 - a22 * a01 * a01;
        if (det == 0.0f) {
            throw new IllDefinedDataPointsException();
        }
        float idet = 1.0f / det;
        float ai00 = (a11 * a22 - a12 * a12) * idet;
        float ai01 = (a02 * a12 - a01 * a22) * idet;
        float ai02 = (a01 * a12 - a02 * a11) * idet;
        float ai11 = (a00 * a22 - a02 * a02) * idet;
        float ai12 = (a02 * a01 - a00 * a12) * idet;
        float ai22 = (a00 * a11 - a01 * a01) * idet;
        this.m00 = ai00 * b00 + ai01 * b10 + ai02 * b20;
        this.m01 = ai01 * b00 + ai11 * b10 + ai12 * b20;
        this.m02 = ai02 * b00 + ai12 * b10 + ai22 * b20;
        this.m10 = ai00 * b01 + ai01 * b11 + ai02 * b21;
        this.m11 = ai01 * b01 + ai11 * b11 + ai12 * b21;
        this.m12 = ai02 * b01 + ai12 * b11 + ai22 * b21;
        this.m20 = ai00 * b02 + ai01 * b12 + ai02 * b22;
        this.m21 = ai01 * b02 + ai11 * b12 + ai12 * b22;
        this.m22 = ai02 * b02 + ai12 * b12 + ai22 * b22;
        this.m03 = qcx - this.m00 * pcx - this.m01 * pcy - this.m02 * pcz;
        this.m13 = qcy - this.m10 * pcx - this.m11 * pcy - this.m12 * pcz;
        this.m23 = qcz - this.m20 * pcx - this.m21 * pcy - this.m22 * pcz;
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 4) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 2d affine model, at least " + 4 + " data points required.");
        }
        float pcx = 0.0f;
        float pcy = 0.0f;
        float pcz = 0.0f;
        float qcx = 0.0f;
        float qcy = 0.0f;
        float qcz = 0.0f;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            float w = m.getWeight();
            ws += (double)w;
            pcx += w * p[0];
            pcy += w * p[1];
            pcz += w * p[2];
            qcx += w * q[0];
            qcy += w * q[1];
            qcz += w * q[2];
        }
        pcx = (float)((double)pcx / ws);
        pcy = (float)((double)pcy / ws);
        pcz = (float)((double)pcz / ws);
        qcx = (float)((double)qcx / ws);
        qcy = (float)((double)qcy / ws);
        qcz = (float)((double)qcz / ws);
        float b22 = 0.0f;
        float b21 = 0.0f;
        float b20 = 0.0f;
        float b12 = 0.0f;
        float b11 = 0.0f;
        float b10 = 0.0f;
        float b02 = 0.0f;
        float b01 = 0.0f;
        float b00 = 0.0f;
        float a22 = 0.0f;
        float a12 = 0.0f;
        float a11 = 0.0f;
        float a02 = 0.0f;
        float a01 = 0.0f;
        float a00 = 0.0f;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            float w = m.getWeight();
            float px = p[0] - pcx;
            float py = p[1] - pcy;
            float pz = p[2] - pcz;
            float qx = q[0] - qcx;
            float qy = q[1] - qcy;
            float qz = q[2] - qcz;
            a00 += w * px * px;
            a01 += w * px * py;
            a02 += w * px * pz;
            a11 += w * py * py;
            a12 += w * py * pz;
            a22 += w * pz * pz;
            b00 += w * px * qx;
            b01 += w * px * qy;
            b02 += w * px * qz;
            b10 += w * py * qx;
            b11 += w * py * qy;
            b12 += w * py * qz;
            b20 += w * pz * qx;
            b21 += w * pz * qy;
            b22 += w * pz * qz;
        }
        float det = a00 * a11 * a22 + a01 * a12 * a02 + a02 * a01 * a12 - a02 * a11 * a02 - a12 * a12 * a00 - a22 * a01 * a01;
        if (det == 0.0f) {
            throw new IllDefinedDataPointsException();
        }
        float idet = 1.0f / det;
        float ai00 = (a11 * a22 - a12 * a12) * idet;
        float ai01 = (a02 * a12 - a01 * a22) * idet;
        float ai02 = (a01 * a12 - a02 * a11) * idet;
        float ai11 = (a00 * a22 - a02 * a02) * idet;
        float ai12 = (a02 * a01 - a00 * a12) * idet;
        float ai22 = (a00 * a11 - a01 * a01) * idet;
        this.m00 = ai00 * b00 + ai01 * b10 + ai02 * b20;
        this.m01 = ai01 * b00 + ai11 * b10 + ai12 * b20;
        this.m02 = ai02 * b00 + ai12 * b10 + ai22 * b20;
        this.m10 = ai00 * b01 + ai01 * b11 + ai02 * b21;
        this.m11 = ai01 * b01 + ai11 * b11 + ai12 * b21;
        this.m12 = ai02 * b01 + ai12 * b11 + ai22 * b21;
        this.m20 = ai00 * b02 + ai01 * b12 + ai02 * b22;
        this.m21 = ai01 * b02 + ai11 * b12 + ai12 * b22;
        this.m22 = ai02 * b02 + ai12 * b12 + ai22 * b22;
        this.m03 = qcx - this.m00 * pcx - this.m01 * pcy - this.m02 * pcz;
        this.m13 = qcy - this.m10 * pcx - this.m11 * pcy - this.m12 * pcz;
        this.m23 = qcz - this.m20 * pcx - this.m21 * pcy - this.m22 * pcz;
        this.invert();
    }

    @Override
    public final void set(AffineModel3D m) {
        this.m00 = m.m00;
        this.m10 = m.m10;
        this.m20 = m.m20;
        this.m01 = m.m01;
        this.m11 = m.m11;
        this.m21 = m.m21;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.m22 = m.m22;
        this.m03 = m.m03;
        this.m13 = m.m13;
        this.m23 = m.m23;
        this.cost = m.cost;
        this.invert();
    }

    @Override
    public AffineModel3D copy() {
        AffineModel3D m = new AffineModel3D();
        m.m00 = this.m00;
        m.m10 = this.m10;
        m.m20 = this.m20;
        m.m01 = this.m01;
        m.m11 = this.m11;
        m.m21 = this.m21;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.m22 = this.m22;
        m.m03 = this.m03;
        m.m13 = this.m13;
        m.m23 = this.m23;
        m.cost = this.cost;
        m.invert();
        return m;
    }

    protected void invert() {
        float det = Matrix3x3.det(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        if (det == 0.0f) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        float idet = 1.0f / det;
        this.i00 = (this.m11 * this.m22 - this.m12 * this.m21) * idet;
        this.i01 = (this.m02 * this.m21 - this.m01 * this.m22) * idet;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) * idet;
        this.i10 = (this.m12 * this.m20 - this.m10 * this.m22) * idet;
        this.i11 = (this.m00 * this.m22 - this.m02 * this.m20) * idet;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) * idet;
        this.i20 = (this.m10 * this.m21 - this.m11 * this.m20) * idet;
        this.i21 = (this.m01 * this.m20 - this.m00 * this.m21) * idet;
        this.i22 = (this.m00 * this.m11 - this.m01 * this.m10) * idet;
        this.i03 = -this.i00 * this.m03 - this.i01 * this.m13 - this.i02 * this.m23;
        this.i13 = -this.i10 * this.m03 - this.i11 * this.m13 - this.i12 * this.m23;
        this.i23 = -this.i20 * this.m03 - this.i21 * this.m13 - this.i22 * this.m23;
    }

    @Override
    public final void preConcatenate(AffineModel3D model) {
        float a00 = model.m00 * this.m00 + model.m01 * this.m10 + model.m02 * this.m20;
        float a01 = model.m00 * this.m01 + model.m01 * this.m11 + model.m02 * this.m21;
        float a02 = model.m00 * this.m02 + model.m01 * this.m12 + model.m02 * this.m22;
        float a03 = model.m00 * this.m03 + model.m01 * this.m13 + model.m02 * this.m23 + model.m03;
        float a10 = model.m10 * this.m00 + model.m11 * this.m10 + model.m12 * this.m20;
        float a11 = model.m10 * this.m01 + model.m11 * this.m11 + model.m12 * this.m21;
        float a12 = model.m10 * this.m02 + model.m11 * this.m12 + model.m12 * this.m22;
        float a13 = model.m10 * this.m03 + model.m11 * this.m13 + model.m12 * this.m23 + model.m13;
        float a20 = model.m20 * this.m00 + model.m21 * this.m10 + model.m22 * this.m20;
        float a21 = model.m20 * this.m01 + model.m21 * this.m11 + model.m22 * this.m21;
        float a22 = model.m20 * this.m02 + model.m21 * this.m12 + model.m22 * this.m22;
        float a23 = model.m20 * this.m03 + model.m21 * this.m13 + model.m22 * this.m23 + model.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(AffineModel3D model) {
        float a00 = this.m00 * model.m00 + this.m01 * model.m10 + this.m02 * model.m20;
        float a01 = this.m00 * model.m01 + this.m01 * model.m11 + this.m02 * model.m21;
        float a02 = this.m00 * model.m02 + this.m01 * model.m12 + this.m02 * model.m22;
        float a03 = this.m00 * model.m03 + this.m01 * model.m13 + this.m02 * model.m23 + this.m03;
        float a10 = this.m10 * model.m00 + this.m11 * model.m10 + this.m12 * model.m20;
        float a11 = this.m10 * model.m01 + this.m11 * model.m11 + this.m12 * model.m21;
        float a12 = this.m10 * model.m02 + this.m11 * model.m12 + this.m12 * model.m22;
        float a13 = this.m10 * model.m03 + this.m11 * model.m13 + this.m12 * model.m23 + this.m13;
        float a20 = this.m20 * model.m00 + this.m21 * model.m10 + this.m22 * model.m20;
        float a21 = this.m20 * model.m01 + this.m21 * model.m11 + this.m22 * model.m21;
        float a22 = this.m20 * model.m02 + this.m21 * model.m12 + this.m22 * model.m22;
        float a23 = this.m20 * model.m03 + this.m21 * model.m13 + this.m22 * model.m23 + this.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(TranslationModel3D model) {
        float[] t = model.getTranslation();
        this.m03 = this.m00 * t[0] + this.m01 * t[1] + this.m02 * t[2] + this.m03;
        this.m13 = this.m10 * t[0] + this.m11 * t[1] + this.m12 * t[2] + this.m13;
        this.m23 = this.m20 * t[0] + this.m21 * t[1] + this.m22 * t[2] + this.m23;
        this.invert();
    }

    @Override
    public final void preConcatenate(TranslationModel3D model) {
        float[] t = model.getTranslation();
        this.m03 += t[0];
        this.m13 += t[1];
        this.m23 += t[2];
        this.invert();
    }

    public final void set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.invert();
    }

    public final String toString() {
        return "3d-affine: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + ")";
    }

    @Override
    public AffineModel3D createInverse() {
        AffineModel3D ict = new AffineModel3D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m20 = this.i20;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m21 = this.i21;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.m22 = this.i22;
        ict.m03 = this.i03;
        ict.m13 = this.i13;
        ict.m23 = this.i23;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i20 = this.m20;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i21 = this.m21;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.i22 = this.m22;
        ict.i03 = this.m03;
        ict.i13 = this.m13;
        ict.i23 = this.m23;
        ict.cost = this.cost;
        ict.isInvertible = this.isInvertible;
        return ict;
    }

    public void rotate(int axis, float d) {
        float dcos = (float)Math.cos(d);
        float dsin = (float)Math.sin(d);
        AffineModel3D dR = new AffineModel3D();
        switch (axis) {
            case 0: {
                dR.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, dcos, -dsin, 0.0f, 0.0f, dsin, dcos, 0.0f);
                break;
            }
            case 1: {
                dR.set(dcos, 0.0f, dsin, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -dsin, 0.0f, dcos, 0.0f);
                break;
            }
            default: {
                dR.set(dcos, -dsin, 0.0f, 0.0f, dsin, dcos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            }
        }
        this.preConcatenate(dR);
    }

    @Override
    public void toArray(float[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m20;
        data[3] = this.m01;
        data[4] = this.m11;
        data[5] = this.m21;
        data[6] = this.m02;
        data[7] = this.m12;
        data[8] = this.m22;
        data[9] = this.m03;
        data[10] = this.m13;
        data[11] = this.m23;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m20;
        data[3] = this.m01;
        data[4] = this.m11;
        data[5] = this.m21;
        data[6] = this.m02;
        data[7] = this.m12;
        data[8] = this.m22;
        data[9] = this.m03;
        data[10] = this.m13;
        data[11] = this.m23;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[0][3] = this.m03;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
        data[1][3] = this.m13;
        data[2][0] = this.m20;
        data[2][1] = this.m21;
        data[2][2] = this.m22;
        data[2][3] = this.m23;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[0][3] = this.m03;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
        data[1][3] = this.m13;
        data[2][0] = this.m20;
        data[2][1] = this.m21;
        data[2][2] = this.m22;
        data[2][3] = this.m23;
    }
}

