/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.TranslationModel2D;

public class AffineModel2D
extends AbstractAffineModel2D<AffineModel2D> {
    protected static final int MIN_NUM_MATCHES = 3;
    protected float m00 = 1.0f;
    protected float m10 = 0.0f;
    protected float m01 = 0.0f;
    protected float m11 = 1.0f;
    protected float m02 = 0.0f;
    protected float m12 = 0.0f;
    protected float i00 = 1.0f;
    protected float i10 = 0.0f;
    protected float i01 = 0.0f;
    protected float i11 = 1.0f;
    protected float i02 = 0.0f;
    protected float i12 = 0.0f;
    private boolean isInvertible = true;

    @Override
    public final int getMinNumMatches() {
        return 3;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(this.i00, this.i10, this.i01, this.i11, this.i02, this.i12);
    }

    @Override
    public final float[] apply(float[] l) {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        float[] transformed = (float[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        float l0 = l[0];
        l[0] = l0 * this.m00 + l[1] * this.m01 + this.m02;
        l[1] = l0 * this.m10 + l[1] * this.m11 + this.m12;
    }

    @Override
    public final float[] applyInverse(float[] l) throws NoninvertibleModelException {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        float[] transformed = (float[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(float[] l) throws NoninvertibleModelException {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        float l0 = l[0];
        l[0] = l0 * this.i00 + l[1] * this.i01 + this.i02;
        l[1] = l0 * this.i10 + l[1] * this.i11 + this.i12;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 3) {
            throw new NotEnoughDataPointsException(String.valueOf(l) + " data points are not enough to estimate a 2d affine model, at least " + 3 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        int i = 0;
        while (i < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
            ++i;
        }
        pcx /= ws;
        pcy /= ws;
        qcx /= ws;
        qcy /= ws;
        double b11 = 0.0;
        double b10 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a11 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        int i2 = 0;
        while (i2 < l) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i2];
            double px = (double)pX[i2] - pcx;
            double py = (double)pY[i2] - pcy;
            double qx = (double)qX[i2] - qcx;
            double qy = (double)qY[i2] - qcy;
            a00 += ww * px * px;
            a01 += ww * px * py;
            a11 += ww * py * py;
            b00 += ww * px * qx;
            b01 += ww * px * qy;
            b10 += ww * py * qx;
            b11 += ww * py * qy;
            ++i2;
        }
        double det = a00 * a11 - a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = (float)((a11 * b00 - a01 * b10) / det);
        this.m01 = (float)((a00 * b10 - a01 * b00) / det);
        this.m10 = (float)((a11 * b01 - a01 * b11) / det);
        this.m11 = (float)((a00 * b11 - a01 * b01) / det);
        this.m02 = (float)(qcx - (double)this.m00 * pcx - (double)this.m01 * pcy);
        this.m12 = (float)(qcy - (double)this.m10 * pcx - (double)this.m11 * pcy);
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 3) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 2d affine model, at least " + 3 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * (double)p[0];
            pcy += w * (double)p[1];
            qcx += w * (double)q[0];
            qcy += w * (double)q[1];
        }
        pcx /= ws;
        pcy /= ws;
        qcx /= ws;
        qcy /= ws;
        double b11 = 0.0;
        double b10 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a11 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            double w = m.getWeight();
            double px = (double)p[0] - pcx;
            double py = (double)p[1] - pcy;
            double qx = (double)q[0] - qcx;
            double qy = (double)q[1] - qcy;
            a00 += w * px * px;
            a01 += w * px * py;
            a11 += w * py * py;
            b00 += w * px * qx;
            b01 += w * px * qy;
            b10 += w * py * qx;
            b11 += w * py * qy;
        }
        double det = a00 * a11 - a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = (float)((a11 * b00 - a01 * b10) / det);
        this.m01 = (float)((a00 * b10 - a01 * b00) / det);
        this.m10 = (float)((a11 * b01 - a01 * b11) / det);
        this.m11 = (float)((a00 * b11 - a01 * b01) / det);
        this.m02 = (float)(qcx - (double)this.m00 * pcx - (double)this.m01 * pcy);
        this.m12 = (float)(qcy - (double)this.m10 * pcx - (double)this.m11 * pcy);
        this.invert();
    }

    @Override
    public final void set(AffineModel2D m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.invert();
        this.cost = m.getCost();
    }

    @Override
    public AffineModel2D copy() {
        AffineModel2D m = new AffineModel2D();
        m.m00 = this.m00;
        m.m01 = this.m01;
        m.m10 = this.m10;
        m.m11 = this.m11;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.cost = this.cost;
        m.invert();
        return m;
    }

    protected final void invert() {
        double det = this.m00 * this.m11 - this.m01 * this.m10;
        if (det == 0.0) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        this.i00 = (float)((double)this.m11 / det);
        this.i01 = (float)((double)(-this.m01) / det);
        this.i02 = (float)((double)(this.m01 * this.m12 - this.m02 * this.m11) / det);
        this.i10 = (float)((double)(-this.m10) / det);
        this.i11 = (float)((double)this.m00 / det);
        this.i12 = (float)((double)(this.m02 * this.m10 - this.m00 * this.m12) / det);
    }

    @Override
    public final void preConcatenate(AffineModel2D model) {
        double a00 = model.m00 * this.m00 + model.m01 * this.m10;
        double a01 = model.m00 * this.m01 + model.m01 * this.m11;
        double a02 = model.m00 * this.m02 + model.m01 * this.m12 + model.m02;
        double a10 = model.m10 * this.m00 + model.m11 * this.m10;
        double a11 = model.m10 * this.m01 + model.m11 * this.m11;
        double a12 = model.m10 * this.m02 + model.m11 * this.m12 + model.m12;
        this.m00 = (float)a00;
        this.m01 = (float)a01;
        this.m02 = (float)a02;
        this.m10 = (float)a10;
        this.m11 = (float)a11;
        this.m12 = (float)a12;
        this.invert();
    }

    @Override
    public final void concatenate(TranslationModel2D model) {
        this.m02 = this.m00 * model.tx + this.m01 * model.ty + this.m02;
        this.m12 = this.m10 * model.tx + this.m11 * model.ty + this.m12;
        this.invert();
    }

    @Override
    public final void preConcatenate(TranslationModel2D model) {
        this.m02 += model.tx;
        this.m12 += model.ty;
        this.invert();
    }

    @Override
    public final void concatenate(AffineModel2D model) {
        double a00 = this.m00 * model.m00 + this.m01 * model.m10;
        double a01 = this.m00 * model.m01 + this.m01 * model.m11;
        double a02 = this.m00 * model.m02 + this.m01 * model.m12 + this.m02;
        double a10 = this.m10 * model.m00 + this.m11 * model.m10;
        double a11 = this.m10 * model.m01 + this.m11 * model.m11;
        double a12 = this.m10 * model.m02 + this.m11 * model.m12 + this.m12;
        this.m00 = (float)a00;
        this.m01 = (float)a01;
        this.m02 = (float)a02;
        this.m10 = (float)a10;
        this.m11 = (float)a11;
        this.m12 = (float)a12;
        this.invert();
    }

    public final void set(float m00, float m10, float m01, float m11, float m02, float m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.invert();
    }

    @Override
    public final void set(AffineTransform a) {
        this.m00 = (float)a.getScaleX();
        this.m10 = (float)a.getShearY();
        this.m01 = (float)a.getShearX();
        this.m11 = (float)a.getScaleY();
        this.m02 = (float)a.getTranslateX();
        this.m12 = (float)a.getTranslateY();
        this.invert();
    }

    @Override
    public AffineModel2D createInverse() {
        AffineModel2D ict = new AffineModel2D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(float[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m01;
        data[3] = this.m11;
        data[4] = this.m02;
        data[5] = this.m12;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m01;
        data[3] = this.m11;
        data[4] = this.m02;
        data[5] = this.m12;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][1] = this.m12;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][1] = this.m12;
    }
}

