/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractAffineModel1D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class AffineModel1D
extends AbstractAffineModel1D<AffineModel1D>
implements InvertibleBoundable {
    protected static final int MIN_NUM_MATCHES = 2;
    protected float m00 = 1.0f;
    protected float m01 = 0.0f;
    protected float i00 = 1.0f;
    protected float i01 = 0.0f;
    protected boolean isInvertible = true;

    @Override
    public float[] getMatrix(float[] m) {
        float[] a = m == null || m.length != 2 ? new float[2] : m;
        a[0] = this.m00;
        a[1] = this.m01;
        return a;
    }

    @Override
    public final int getMinNumMatches() {
        return 2;
    }

    @Override
    public final float[] apply(float[] l) {
        float[] transformed = (float[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(float[] l) {
        assert (l.length >= 1) : "1d affine transformations can be applied to 1d points only.";
        l[0] = l[0] * this.m00 + this.m01;
    }

    @Override
    public final float[] applyInverse(float[] l) throws NoninvertibleModelException {
        float[] transformed = (float[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(float[] l) throws NoninvertibleModelException {
        assert (l.length >= 1) : "1d affine transformations can be applied to 1d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        l[0] = l[0] * this.i00 + this.i01;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 1 && q.length >= 1) : "1d affine transformations can be applied to 3d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(String.valueOf(l) + " data points are not enough to estimate a 2d affine model, at least " + 2 + " data points required.");
        }
        float pcx = 0.0f;
        float qcx = 0.0f;
        double ws = 0.0;
        float[] pX = p[0];
        float[] qX = q[0];
        int i = 0;
        while (i < l) {
            float ww = w[i];
            ws += (double)ww;
            pcx += ww * pX[i];
            qcx += ww * qX[i];
            ++i;
        }
        pcx = (float)((double)pcx / ws);
        qcx = (float)((double)qcx / ws);
        float a = 0.0f;
        float b = 0.0f;
        int i2 = 0;
        while (i2 < l) {
            float px = pX[i2] - pcx;
            float qx = qX[i2] - qcx;
            float wwpx = w[i2] * px;
            a += wwpx * px;
            b += wwpx * qx;
            ++i2;
        }
        if (a == 0.0f) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = b / a;
        this.m01 = qcx - this.m00 * pcx;
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 2) {
            throw new NotEnoughDataPointsException(String.valueOf(matches.size()) + " data points are not enough to estimate a 2d affine model, at least " + 2 + " data points required.");
        }
        float pcx = 0.0f;
        float qcx = 0.0f;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            float w = m.getWeight();
            ws += (double)w;
            pcx += w * p[0];
            qcx += w * q[0];
        }
        pcx = (float)((double)pcx / ws);
        qcx = (float)((double)qcx / ws);
        float a = 0.0f;
        float b = 0.0f;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            float px = p[0] - pcx;
            float qx = q[0] - qcx;
            float wwpx = m.getWeight() * px;
            a += wwpx * px;
            b += wwpx * qx;
        }
        if (a == 0.0f) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = b / a;
        this.m01 = qcx - this.m00 * pcx;
        this.invert();
    }

    @Override
    public final void set(AffineModel1D m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.cost = m.cost;
        this.invert();
    }

    @Override
    public AffineModel1D copy() {
        AffineModel1D m = new AffineModel1D();
        m.set(this);
        return m;
    }

    protected void invert() {
        if (this.m00 == 0.0f) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        this.i00 = 1.0f / this.m00;
        this.i01 = -this.m01 / this.m00;
    }

    @Override
    public final void preConcatenate(AffineModel1D model) {
        float a00 = model.m00 * this.m00;
        float a01 = model.m00 * this.m01 + model.m01;
        this.m00 = a00;
        this.m01 = a01;
        this.invert();
    }

    @Override
    public final void concatenate(AffineModel1D model) {
        float a00 = this.m00 * model.m00;
        float a01 = this.m00 * model.m01 + this.m01;
        this.m00 = a00;
        this.m01 = a01;
        this.invert();
    }

    public final void set(float m00, float m01) {
        this.m00 = m00;
        this.m01 = m01;
        this.invert();
    }

    public final String toString() {
        return "1d-affine: (" + this.m00 + ", " + this.m01 + ")";
    }

    @Override
    public AffineModel1D createInverse() {
        AffineModel1D ict = new AffineModel1D();
        ict.m00 = this.i00;
        ict.m01 = this.i01;
        ict.i00 = this.m00;
        ict.i01 = this.m01;
        ict.cost = this.cost;
        ict.isInvertible = this.isInvertible;
        return ict;
    }

    @Override
    public void toArray(float[] data) {
        data[0] = this.m00;
        data[1] = this.m01;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m01;
    }

    @Override
    public void toMatrix(float[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
    }
}

