/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public abstract class AbstractModel<M extends AbstractModel<M>>
implements Model<M> {
    protected static final Random rnd = new Random(69997L);
    protected double cost = Double.MAX_VALUE;

    @Override
    @Deprecated
    public final int getMinSetSize() {
        return this.getMinNumMatches();
    }

    @Override
    public final double getCost() {
        return this.cost;
    }

    @Override
    public final void setCost(double c) {
        this.cost = c;
    }

    @Override
    @Deprecated
    public final double getError() {
        return this.getCost();
    }

    @Override
    @Deprecated
    public final void setError(double e) {
        this.setCost(e);
    }

    @Override
    public final boolean betterThan(M m) {
        if (this.cost < 0.0) {
            return false;
        }
        return this.cost < ((AbstractModel)m).cost;
    }

    @Override
    public final <P extends PointMatch> boolean test(Collection<P> candidates, Collection<P> inliers, double epsilon, double minInlierRatio, int minNumInliers) {
        inliers.clear();
        for (PointMatch m : candidates) {
            m.apply(this);
            if (!((double)m.getDistance() < epsilon)) continue;
            inliers.add(m);
        }
        float ir = (float)inliers.size() / (float)candidates.size();
        this.setCost(Math.max(0.0, Math.min(1.0, 1.0 - (double)ir)));
        return inliers.size() >= minNumInliers && (double)ir > minInlierRatio;
    }

    @Override
    public final <P extends PointMatch> boolean test(Collection<P> candidates, Collection<P> inliers, double epsilon, double minInlierRatio) {
        return this.test(candidates, inliers, epsilon, minInlierRatio, this.getMinNumMatches());
    }

    @Override
    public final <P extends PointMatch> boolean filter(Collection<P> candidates, Collection<P> inliers, float maxTrust, int minNumInliers) throws NotEnoughDataPointsException {
        int numInliers;
        if (candidates.size() < this.getMinNumMatches()) {
            throw new NotEnoughDataPointsException(String.valueOf(candidates.size()) + " data points are not enough to solve the Model, at least " + this.getMinNumMatches() + " data points required.");
        }
        AbstractModel copy = (AbstractModel)this.copy();
        inliers.clear();
        inliers.addAll(candidates);
        ArrayList<P> temp = new ArrayList<P>();
        do {
            temp.clear();
            temp.addAll(inliers);
            numInliers = inliers.size();
            try {
                copy.fit(inliers);
            }
            catch (NotEnoughDataPointsException e) {
                return false;
            }
            catch (IllDefinedDataPointsException e) {
                return false;
            }
            ErrorStatistic observer = new ErrorStatistic(temp.size());
            for (PointMatch m : temp) {
                m.apply(copy);
                observer.add(m.getDistance());
            }
            inliers.clear();
            double t = observer.getMedian() * (double)maxTrust;
            for (PointMatch m : temp) {
                if (!((double)m.getDistance() <= t)) continue;
                inliers.add(m);
            }
            copy.cost = observer.mean;
        } while (numInliers > inliers.size());
        if (numInliers < minNumInliers) {
            return false;
        }
        this.set(copy);
        return true;
    }

    @Override
    public final <P extends PointMatch> boolean filter(Collection<P> candidates, Collection<P> inliers, float maxTrust) throws NotEnoughDataPointsException {
        return this.filter(candidates, inliers, maxTrust, this.getMinNumMatches());
    }

    @Override
    public final <P extends PointMatch> boolean filter(Collection<P> candidates, Collection<P> inliers) throws NotEnoughDataPointsException {
        return this.filter(candidates, inliers, 4.0f, this.getMinNumMatches());
    }

    @Override
    public final <P extends PointMatch> boolean ransac(List<P> candidates, Collection<P> inliers, int iterations, double epsilon, double minInlierRatio, int minNumInliers) throws NotEnoughDataPointsException {
        if (candidates.size() < this.getMinNumMatches()) {
            throw new NotEnoughDataPointsException(String.valueOf(candidates.size()) + " data points are not enough to solve the Model, at least " + this.getMinNumMatches() + " data points required.");
        }
        this.cost = Double.MAX_VALUE;
        AbstractModel copy = (AbstractModel)this.copy();
        AbstractModel m = (AbstractModel)this.copy();
        inliers.clear();
        int i = 0;
        HashSet<PointMatch> minMatches = new HashSet<PointMatch>();
        block4: while (i < iterations) {
            minMatches.clear();
            int j = 0;
            while (j < this.getMinNumMatches()) {
                PointMatch p;
                while (minMatches.contains(p = (PointMatch)candidates.get((int)(rnd.nextDouble() * (double)candidates.size())))) {
                }
                minMatches.add(p);
                ++j;
            }
            try {
                m.fit(minMatches);
            }
            catch (IllDefinedDataPointsException e) {
                ++i;
                continue;
            }
            ArrayList tempInliers = new ArrayList();
            int numInliers = 0;
            boolean isGood = m.test(candidates, tempInliers, epsilon, minInlierRatio);
            while (isGood && numInliers < tempInliers.size()) {
                numInliers = tempInliers.size();
                try {
                    m.fit(tempInliers);
                }
                catch (IllDefinedDataPointsException e) {
                    ++i;
                    continue block4;
                }
                isGood = m.test(candidates, tempInliers, epsilon, minInlierRatio, minNumInliers);
            }
            if (isGood && m.betterThan((M)copy) && tempInliers.size() >= minNumInliers) {
                copy.set(m);
                inliers.clear();
                inliers.addAll(tempInliers);
            }
            ++i;
        }
        if (inliers.size() == 0) {
            return false;
        }
        this.set(copy);
        return true;
    }

    @Override
    public final <P extends PointMatch> boolean ransac(List<P> candidates, Collection<P> inliers, int iterations, double epsilon, double minInlierRatio) throws NotEnoughDataPointsException {
        return this.ransac(candidates, inliers, iterations, epsilon, minInlierRatio, this.getMinNumMatches());
    }

    @Override
    public final <P extends PointMatch> boolean filterRansac(List<P> candidates, Collection<P> inliers, int iterations, float maxEpsilon, float minInlierRatio, int minNumInliers, float maxTrust) throws NotEnoughDataPointsException {
        ArrayList temp = new ArrayList();
        return this.ransac(candidates, temp, iterations, maxEpsilon, minInlierRatio, minNumInliers) && this.filter(temp, inliers, maxTrust, minNumInliers);
    }

    @Override
    public final <P extends PointMatch> boolean filterRansac(List<P> candidates, Collection<P> inliers, int iterations, float maxEpsilon, float minInlierRatio, int minNumInliers) throws NotEnoughDataPointsException {
        return this.filterRansac(candidates, inliers, iterations, maxEpsilon, minInlierRatio, minNumInliers, 4.0f);
    }

    @Override
    public final <P extends PointMatch> boolean filterRansac(List<P> candidates, Collection<P> inliers, int iterations, float maxEpsilon, float minInlierRatio, float maxTrust) throws NotEnoughDataPointsException {
        return this.filterRansac(candidates, inliers, iterations, maxEpsilon, minInlierRatio, this.getMinNumMatches(), maxTrust);
    }

    @Override
    public final <P extends PointMatch> boolean filterRansac(List<P> candidates, Collection<P> inliers, int iterations, float maxEpsilon, float minInlierRatio) throws NotEnoughDataPointsException {
        return this.filterRansac(candidates, inliers, iterations, maxEpsilon, minInlierRatio, 4.0f);
    }

    @Override
    public final Collection<PointMatch> icp(List<Point> p, List<Point> q) {
        AbstractModel m = (AbstractModel)this.copy();
        ArrayList<PointMatch> currentMatches = new ArrayList<PointMatch>();
        ArrayList<PointMatch> previousMatches = new ArrayList<PointMatch>();
        do {
            previousMatches.clear();
            previousMatches.addAll(currentMatches);
            currentMatches.clear();
            for (Point pi : p) {
                float minimalDistance = Float.MAX_VALUE;
                Point closestPoint = null;
                for (Point qi : q) {
                    float d = Point.distance(pi, qi);
                    if (!(d < minimalDistance)) continue;
                    minimalDistance = d;
                    closestPoint = qi;
                }
                currentMatches.add(new PointMatch(pi, closestPoint));
            }
            try {
                m.fit(currentMatches);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } while (currentMatches.equals(previousMatches));
        this.set(m);
        return currentMatches;
    }

    @Override
    public void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length > 0 && q.length == p.length) : "Numbers of dimensions do not match.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int n = p.length;
        int l = p[0].length;
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>(l);
        int i = 0;
        while (i < l) {
            float[] pi = new float[n];
            float[] qi = new float[n];
            int d = 0;
            while (d < n) {
                pi[d] = p[d][i];
                qi[d] = q[d][i];
                ++d;
            }
            matches.add(new PointMatch(new Point(pi), new Point(qi), w[i]));
            ++i;
        }
        this.fit(matches);
    }

    @Override
    public <P extends PointMatch> boolean localSmoothnessFilter(Collection<P> candidates, Collection<P> inliers, double sigma, double maxEpsilon, double maxTrust) {
        double var2 = 2.0 * sigma * sigma;
        for (PointMatch match : candidates) {
            match.unshiftWeight(1.0f);
        }
        if (inliers != candidates) {
            inliers.clear();
            inliers.addAll(candidates);
        }
        boolean hasChanged = false;
        int p = 0;
        System.out.print("Smoothness filter pass  1:   0%");
        do {
            System.out.print("\rSmoothness filter pass " + String.format("%2d", ++p) + ":   0%");
            hasChanged = false;
            ArrayList<PointMatch> toBeRemoved = new ArrayList<PointMatch>();
            ArrayList localInliers = new ArrayList();
            int i = 0;
            for (PointMatch candidate : inliers) {
                boolean filteredLocalModelFound;
                System.out.print("\rSmoothness filter pass " + String.format("%2d", p) + ": " + String.format("%3d", ++i * 100 / inliers.size()) + "%");
                for (PointMatch match : inliers) {
                    float w = (float)Math.exp((double)(-Point.squareLocalDistance(candidate.getP1(), match.getP1())) / var2);
                    match.setWeight(0, w);
                }
                candidate.setWeight(0, 0.0f);
                try {
                    filteredLocalModelFound = this.filter(candidates, localInliers, (float)maxTrust);
                }
                catch (NotEnoughDataPointsException e) {
                    filteredLocalModelFound = false;
                }
                if (!filteredLocalModelFound) {
                    for (PointMatch match : candidates) {
                        match.shiftWeight();
                    }
                    inliers.clear();
                    return false;
                }
                candidate.apply(this);
                double candidateDistance = Point.distance(candidate.getP1(), candidate.getP2());
                if (candidateDistance <= maxEpsilon) {
                    PointMatch.apply(inliers, this);
                    double meanDistance = 0.0;
                    double ws = 0.0;
                    for (PointMatch match : inliers) {
                        float w = match.getWeight();
                        ws += (double)w;
                        meanDistance += (double)(Point.distance(match.getP1(), match.getP2()) * w);
                    }
                    if (!(candidateDistance > maxTrust * (meanDistance /= ws))) continue;
                    hasChanged = true;
                    toBeRemoved.add(candidate);
                    continue;
                }
                hasChanged = true;
                toBeRemoved.add(candidate);
            }
            inliers.removeAll(toBeRemoved);
            System.out.println();
        } while (hasChanged);
        for (PointMatch match : candidates) {
            match.shiftWeight();
        }
        return inliers.size() >= this.getMinNumMatches();
    }
}

