/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import mpicbg.imagefeatures.FloatArray2D;

public final class ImageArrayConverter {
    public static final ImagePlus FloatArrayToImagePlus(FloatArray2D image, String name, float min, float max) {
        ImagePlus imp = IJ.createImage((String)name, (String)"32-Bit Black", (int)image.width, (int)image.height, (int)1);
        FloatProcessor ip = (FloatProcessor)imp.getProcessor();
        ImageArrayConverter.floatArray2DToFloatProcessor(image, ip);
        if (min == max) {
            ip.resetMinAndMax();
        } else {
            ip.setMinAndMax((double)min, (double)max);
        }
        imp.updateAndDraw();
        return imp;
    }

    public static final void imageProcessorToFloatArray2D(ImageProcessor ip, FloatArray2D fa) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!(ip instanceof ByteProcessor)) break block4;
                        byte[] pixels = (byte[])ip.getPixels();
                        int i = 0;
                        while (i < pixels.length) {
                            fa.data[i] = pixels[i] & 0xFF;
                            ++i;
                        }
                        break block5;
                    }
                    if (!(ip instanceof ShortProcessor)) break block6;
                    short[] pixels = (short[])ip.getPixels();
                    int i = 0;
                    while (i < pixels.length) {
                        fa.data[i] = pixels[i] & 0xFFFF;
                        ++i;
                    }
                    break block5;
                }
                if (!(ip instanceof FloatProcessor)) break block7;
                float[] pixels = (float[])ip.getPixels();
                int i = 0;
                while (i < pixels.length) {
                    fa.data[i] = pixels[i];
                    ++i;
                }
                break block5;
            }
            if (!(ip instanceof ColorProcessor)) break block5;
            int[] pixels = (int[])ip.getPixels();
            int i = 0;
            while (i < pixels.length) {
                int rgb = pixels[i];
                int b = rgb & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                fa.data[i] = 0.3f * (float)r + 0.6f * (float)g + 0.1f * (float)b;
                ++i;
            }
        }
    }

    public static final void imageProcessorToFloatArray2DCropAndNormalize(ImageProcessor ip, FloatArray2D fa) {
        block5: {
            float scale;
            float min;
            block7: {
                block6: {
                    block4: {
                        min = (float)ip.getMin();
                        scale = 1.0f / ((float)ip.getMax() - min);
                        if (!(ip instanceof ByteProcessor)) break block4;
                        byte[] pixels = (byte[])ip.getPixels();
                        int i = 0;
                        while (i < pixels.length) {
                            fa.data[i] = ((float)(pixels[i] & 0xFF) - min) * scale;
                            ++i;
                        }
                        break block5;
                    }
                    if (!(ip instanceof ShortProcessor)) break block6;
                    short[] pixels = (short[])ip.getPixels();
                    int i = 0;
                    while (i < pixels.length) {
                        fa.data[i] = ((float)(pixels[i] & 0xFFFF) - min) * scale;
                        ++i;
                    }
                    break block5;
                }
                if (!(ip instanceof FloatProcessor)) break block7;
                float[] pixels = (float[])ip.getPixels();
                int i = 0;
                while (i < pixels.length) {
                    fa.data[i] = (pixels[i] - min) * scale;
                    ++i;
                }
                break block5;
            }
            if (!(ip instanceof ColorProcessor)) break block5;
            int[] pixels = (int[])ip.getPixels();
            int i = 0;
            while (i < pixels.length) {
                int rgb = pixels[i];
                int b = rgb & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                fa.data[i] = (0.3f * (float)r + 0.6f * (float)g + 0.1f * (float)b - min) * scale;
                ++i;
            }
        }
    }

    public static final void floatArray2DToFloatProcessor(FloatArray2D pixels, FloatProcessor ip) {
        float[] data = new float[pixels.width * pixels.height];
        int count = 0;
        int y = 0;
        while (y < pixels.height) {
            int x = 0;
            while (x < pixels.width) {
                data[count] = pixels.data[count++];
                ++x;
            }
            ++y;
        }
        ip.setPixels((Object)data);
        ip.resetMinAndMax();
    }
}

