/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.util.Vector;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DScaleOctave;
import mpicbg.util.Matrix3x3;

public class FloatArray2DScaleOctaveDoGDetector {
    private static final float MIN_CONTRAST = 0.025f;
    private static final float MAX_CURVATURE = 10.0f;
    private static final float MAX_CURVATURE_RATIO = 12.1f;
    private FloatArray2DScaleOctave octave = null;
    private Vector<float[]> candidates = null;

    public Vector<float[]> getCandidates() {
        return this.candidates;
    }

    public void run(FloatArray2DScaleOctave o) {
        this.octave = o;
        this.candidates = new Vector();
        this.detectCandidates();
    }

    private void detectCandidates() {
        FloatArray2D[] d = this.octave.getD();
        int i = d.length - 2;
        while (i >= 1) {
            int ia = i - 1;
            int ib = i + 1;
            int y = d[i].height - 2;
            while (y >= 1) {
                int r = y * d[i].width;
                int ra = r - d[i].width;
                int rb = r + d[i].width;
                int x = d[i].width - 2;
                while (x >= 1) {
                    block10: {
                        float e222;
                        float e122;
                        float e022;
                        float e212;
                        float e112;
                        float e012;
                        float e202;
                        float e102;
                        float e002;
                        float e221;
                        float e121;
                        float e021;
                        float e211;
                        float e011;
                        float e201;
                        float e101;
                        float e001;
                        float e220;
                        float e120;
                        float e020;
                        float e210;
                        float e110;
                        float e010;
                        float e200;
                        float e100;
                        boolean isMin;
                        int ic = i;
                        int iac = ia;
                        int ibc = ib;
                        int yc = y;
                        int rc = r;
                        int rac = ra;
                        int rbc = rb;
                        int xc = x;
                        int xa = xc - 1;
                        int xb = xc + 1;
                        float e000 = d[iac].data[rac + xa];
                        float e111 = d[ic].data[r + xc];
                        boolean isMax = e000 < e111;
                        boolean bl = isMin = e000 > e111;
                        if ((isMax || isMin) && ((isMax &= (e100 = d[iac].data[rac + xc]) < e111) || (isMin &= e100 > e111)) && ((isMax &= (e200 = d[iac].data[rac + xb]) < e111) || (isMin &= e200 > e111)) && ((isMax &= (e010 = d[iac].data[rc + xa]) < e111) || (isMin &= e010 > e111)) && ((isMax &= (e110 = d[iac].data[rc + xc]) < e111) || (isMin &= e110 > e111)) && ((isMax &= (e210 = d[iac].data[rc + xb]) < e111) || (isMin &= e210 > e111)) && ((isMax &= (e020 = d[iac].data[rbc + xa]) < e111) || (isMin &= e020 > e111)) && ((isMax &= (e120 = d[iac].data[rbc + xc]) < e111) || (isMin &= e120 > e111)) && ((isMax &= (e220 = d[iac].data[rbc + xb]) < e111) || (isMin &= e220 > e111)) && ((isMax &= (e001 = d[ic].data[rac + xa]) < e111) || (isMin &= e001 > e111)) && ((isMax &= (e101 = d[ic].data[rac + xc]) < e111) || (isMin &= e101 > e111)) && ((isMax &= (e201 = d[ic].data[rac + xb]) < e111) || (isMin &= e201 > e111)) && ((isMax &= (e011 = d[ic].data[rc + xa]) < e111) || (isMin &= e011 > e111)) && ((isMax &= (e211 = d[ic].data[rc + xb]) < e111) || (isMin &= e211 > e111)) && ((isMax &= (e021 = d[ic].data[rbc + xa]) < e111) || (isMin &= e021 > e111)) && ((isMax &= (e121 = d[ic].data[rbc + xc]) < e111) || (isMin &= e121 > e111)) && ((isMax &= (e221 = d[ic].data[rbc + xb]) < e111) || (isMin &= e221 > e111)) && ((isMax &= (e002 = d[ibc].data[rac + xa]) < e111) || (isMin &= e002 > e111)) && ((isMax &= (e102 = d[ibc].data[rac + xc]) < e111) || (isMin &= e102 > e111)) && ((isMax &= (e202 = d[ibc].data[rac + xb]) < e111) || (isMin &= e202 > e111)) && ((isMax &= (e012 = d[ibc].data[rc + xa]) < e111) || (isMin &= e012 > e111)) && ((isMax &= (e112 = d[ibc].data[rc + xc]) < e111) || (isMin &= e112 > e111)) && ((isMax &= (e212 = d[ibc].data[rc + xb]) < e111) || (isMin &= e212 > e111)) && ((isMax &= (e022 = d[ibc].data[rbc + xa]) < e111) || (isMin &= e022 > e111)) && ((isMax &= (e122 = d[ibc].data[rbc + xc]) < e111) || (isMin &= e122 > e111)) && ((isMax &= (e222 = d[ibc].data[rbc + xb]) < e111) || (isMin &= e222 > e111))) {
                            float det;
                            float trace;
                            float oi;
                            float oy;
                            float ox;
                            float dyy;
                            float dxy;
                            float dxx;
                            float di;
                            float dy;
                            float dx;
                            boolean isLocalized = false;
                            boolean isLocalizable = true;
                            float od = Float.MAX_VALUE;
                            float fx = 0.0f;
                            float fy = 0.0f;
                            float fi = 0.0f;
                            int t = 5;
                            do {
                                --t;
                                dx = (e211 - e011) / 2.0f;
                                dy = (e121 - e101) / 2.0f;
                                di = (e112 - e110) / 2.0f;
                                float e111_2 = 2.0f * e111;
                                dxx = e011 - e111_2 + e211;
                                dxy = (e221 - e021 - e201 + e001) / 4.0f;
                                float dxi = (e212 - e012 - e210 + e010) / 4.0f;
                                dyy = e101 - e111_2 + e121;
                                float dyi = (e122 - e102 - e120 + e100) / 4.0f;
                                float dii = e110 - e111_2 + e112;
                                float det2 = Matrix3x3.det(dxx, dxy, dxi, dxy, dyy, dyi, dxi, dyi, dii);
                                if (det2 == 0.0f) break block10;
                                float hixx = (dyy * dii - dyi * dyi) / det2;
                                float hixy = (dxi * dyi - dxy * dii) / det2;
                                ox = -hixx * dx - hixy * dy - hixx * di;
                                float hiyy = (dxx * dii - dxi * dxi) / det2;
                                oy = -hixy * dx - hiyy * dy - hixy * di;
                                float hixi = (dxy * dyi - dxi * dyy) / det2;
                                float hiyi = (dxi * dxy - dxx * dyi) / det2;
                                float hiii = (dxx * dyy - dxy * dxy) / det2;
                                oi = -hixi * dx - hiyi * dy - hiii * di;
                                float odc = ox * ox + oy * oy + oi * oi;
                                if (odc < 2.0f) {
                                    if (((double)Math.abs(ox) > 0.5 || (double)Math.abs(oy) > 0.5 || (double)Math.abs(oi) > 0.5) && odc < od) {
                                        od = odc;
                                        xc = Math.round((float)xc + ox);
                                        yc = Math.round((float)yc + oy);
                                        ic = Math.round((float)ic + oi);
                                        if (xc < 1 || yc < 1 || ic < 1 || xc > d[0].width - 2 || yc > d[0].height - 2 || ic > d.length - 2) {
                                            isLocalizable = false;
                                            continue;
                                        }
                                        xa = xc - 1;
                                        xb = xc + 1;
                                        rc = yc * d[ic].width;
                                        rac = rc - d[ic].width;
                                        rbc = rc + d[ic].width;
                                        iac = ic - 1;
                                        ibc = ic + 1;
                                        e000 = d[iac].data[rac + xa];
                                        e100 = d[iac].data[rac + xc];
                                        e200 = d[iac].data[rac + xb];
                                        e010 = d[iac].data[rc + xa];
                                        e110 = d[iac].data[rc + xc];
                                        e210 = d[iac].data[rc + xb];
                                        e020 = d[iac].data[rbc + xa];
                                        e120 = d[iac].data[rbc + xc];
                                        e220 = d[iac].data[rbc + xb];
                                        e001 = d[ic].data[rac + xa];
                                        e101 = d[ic].data[rac + xc];
                                        e201 = d[ic].data[rac + xb];
                                        e011 = d[ic].data[rc + xa];
                                        e111 = d[ic].data[rc + xc];
                                        e211 = d[ic].data[rc + xb];
                                        e021 = d[ic].data[rbc + xa];
                                        e121 = d[ic].data[rbc + xc];
                                        e221 = d[ic].data[rbc + xb];
                                        e002 = d[ibc].data[rac + xa];
                                        e102 = d[ibc].data[rac + xc];
                                        e202 = d[ibc].data[rac + xb];
                                        e012 = d[ibc].data[rc + xa];
                                        e112 = d[ibc].data[rc + xc];
                                        e212 = d[ibc].data[rc + xb];
                                        e022 = d[ibc].data[rbc + xa];
                                        e122 = d[ibc].data[rbc + xc];
                                        e222 = d[ibc].data[rbc + xb];
                                        continue;
                                    }
                                    fx = (float)xc + ox;
                                    fy = (float)yc + oy;
                                    fi = (float)ic + oi;
                                    if (fx < 0.0f || fy < 0.0f || fi < 0.0f || fx > (float)(d[0].width - 1) || fy > (float)(d[0].height - 1) || fi > (float)(d.length - 1)) {
                                        isLocalizable = false;
                                        continue;
                                    }
                                    isLocalized = true;
                                    continue;
                                }
                                isLocalizable = false;
                            } while (!isLocalized && isLocalizable && t >= 0);
                            if (isLocalized && !(Math.abs(e111 + 0.5f * (dx * ox + dy * oy + di * oi)) < 0.025f) && !((trace = dxx + dyy) * trace / (det = dxx * dyy - dxy * dxy) > 12.1f)) {
                                this.candidates.addElement(new float[]{fx, fy, fi});
                            }
                        }
                    }
                    --x;
                }
                --y;
            }
            --i;
        }
    }
}

