/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.Filter;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DFeatureTransform;
import mpicbg.imagefeatures.FloatArray2DScaleOctave;
import mpicbg.imagefeatures.FloatArray2DScaleOctaveDoGDetector;
import mpicbg.models.AbstractModel;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.util.Util;

public class FloatArray2DSIFT
extends FloatArray2DFeatureTransform<Param> {
    private final int fdWidth;
    private final float fdBinWidth;
    private float[] sigma;
    private float[] sigma_diff;
    private float[][] kernel_diff;
    private final float[][] descriptorMask;
    private FloatArray2DScaleOctave[] octaves = null;
    private final FloatArray2DScaleOctaveDoGDetector dog = new FloatArray2DScaleOctaveDoGDetector();

    public FloatArray2DScaleOctave[] getOctaves() {
        return this.octaves;
    }

    public FloatArray2DScaleOctave getOctave(int i) {
        return this.octaves[i];
    }

    public FloatArray2DSIFT(Param p) {
        super(p);
        this.fdWidth = 4 * p.fdSize;
        this.fdBinWidth = (float)Math.PI * 2 / (float)p.fdBins;
        this.descriptorMask = new float[this.fdWidth][this.fdWidth];
        float two_sq_sigma = p.fdSize * p.fdSize * 8;
        int y = p.fdSize * 2 - 1;
        while (y >= 0) {
            float fy = (float)y + 0.5f;
            int x = p.fdSize * 2 - 1;
            while (x >= 0) {
                float val;
                float fx = (float)x + 0.5f;
                this.descriptorMask[2 * p.fdSize - 1 - y][2 * p.fdSize - 1 - x] = val = (float)Math.exp(-(fy * fy + fx * fx) / two_sq_sigma);
                this.descriptorMask[2 * p.fdSize + y][2 * p.fdSize - 1 - x] = val;
                this.descriptorMask[2 * p.fdSize - 1 - y][2 * p.fdSize + x] = val;
                this.descriptorMask[2 * p.fdSize + y][2 * p.fdSize + x] = val;
                --x;
            }
            --y;
        }
        this.setInitialSigma(p.initialSigma);
    }

    @Override
    public final void init(FloatArray2D src) {
        int o = 0;
        float w = src.width;
        float h = src.height;
        int max_kernel_size = this.kernel_diff[((Param)this.p).steps + 2].length;
        while (w > (float)Math.max(max_kernel_size, ((Param)this.p).minOctaveSize - 1) && h > (float)Math.max(max_kernel_size, ((Param)this.p).minOctaveSize - 1)) {
            w /= 2.0f;
            h /= 2.0f;
            ++o;
        }
        this.octaves = new FloatArray2DScaleOctave[o];
        int i = 0;
        while (i < this.octaves.length) {
            this.octaves[i] = new FloatArray2DScaleOctave(src, this.sigma, this.sigma_diff, this.kernel_diff);
            this.octaves[i].buildStub();
            FloatArray2D next = new FloatArray2D(src.width / 2 + src.width % 2, src.height / 2 + src.height % 2);
            FloatArray2DScaleOctave.downsample(this.octaves[i].getL(1), next);
            if (src.width > ((Param)this.p).maxOctaveSize || src.height > ((Param)this.p).maxOctaveSize) {
                this.octaves[i].clear();
            }
            src = next;
            ++i;
        }
    }

    private float[] createDescriptor(float[] c, int o, float octave_sigma, float orientation) {
        FloatArray2DScaleOctave octave = this.octaves[o];
        FloatArray2D[] gradients = octave.getL1(Math.round(c[2]));
        FloatArray2D[] region = new FloatArray2D[]{new FloatArray2D(this.fdWidth, this.fdWidth), new FloatArray2D(this.fdWidth, this.fdWidth)};
        float cos_o = (float)Math.cos(orientation);
        float sin_o = (float)Math.sin(orientation);
        int y = this.fdWidth - 1;
        while (y >= 0) {
            float ys = ((float)y - 2.0f * (float)((Param)this.p).fdSize + 0.5f) * octave_sigma;
            int x = this.fdWidth - 1;
            while (x >= 0) {
                float xs = ((float)x - 2.0f * (float)((Param)this.p).fdSize + 0.5f) * octave_sigma;
                float yr = cos_o * ys + sin_o * xs;
                float xr = cos_o * xs - sin_o * ys;
                int yg = Util.pingPong(Math.round(yr + c[1]), gradients[0].height);
                int xg = Util.pingPong(Math.round(xr + c[0]), gradients[0].width);
                int region_p = this.fdWidth * y + x;
                int gradient_p = gradients[0].width * yg + xg;
                region[0].data[region_p] = gradients[0].data[gradient_p] * this.descriptorMask[y][x];
                region[1].data[region_p] = gradients[1].data[gradient_p] - orientation;
                --x;
            }
            --y;
        }
        float[][][] hist = new float[((Param)this.p).fdSize][((Param)this.p).fdSize][((Param)this.p).fdBins];
        int y2 = ((Param)this.p).fdSize - 1;
        while (y2 >= 0) {
            int yp = ((Param)this.p).fdSize * 16 * y2;
            int x = ((Param)this.p).fdSize - 1;
            while (x >= 0) {
                int xp = 4 * x;
                int ysr = 3;
                while (ysr >= 0) {
                    int ysrp = 4 * ((Param)this.p).fdSize * ysr;
                    int xsr = 3;
                    while (xsr >= 0) {
                        float bin_location = (region[1].data[yp + xp + ysrp + xsr] + (float)Math.PI) / this.fdBinWidth;
                        int bin_b = (int)bin_location;
                        int bin_t = bin_b + 1;
                        float d = bin_location - (float)bin_b;
                        bin_b = (bin_b + 2 * ((Param)this.p).fdBins) % ((Param)this.p).fdBins;
                        bin_t = (bin_t + 2 * ((Param)this.p).fdBins) % ((Param)this.p).fdBins;
                        float t = region[0].data[yp + xp + ysrp + xsr];
                        float[] fArray = hist[y2][x];
                        int n = bin_b;
                        fArray[n] = fArray[n] + t * (1.0f - d);
                        float[] fArray2 = hist[y2][x];
                        int n2 = bin_t;
                        fArray2[n2] = fArray2[n2] + t * d;
                        --xsr;
                    }
                    --ysr;
                }
                --x;
            }
            --y2;
        }
        float[] desc = new float[((Param)this.p).fdSize * ((Param)this.p).fdSize * ((Param)this.p).fdBins];
        float max_bin_val = 0.0f;
        int i = 0;
        int y3 = ((Param)this.p).fdSize - 1;
        while (y3 >= 0) {
            int x = ((Param)this.p).fdSize - 1;
            while (x >= 0) {
                int b = ((Param)this.p).fdBins - 1;
                while (b >= 0) {
                    desc[i] = hist[y3][x][b];
                    if (desc[i] > max_bin_val) {
                        max_bin_val = desc[i];
                    }
                    ++i;
                    --b;
                }
                --x;
            }
            --y3;
        }
        max_bin_val = (float)((double)max_bin_val / 0.2);
        i = 0;
        while (i < desc.length) {
            desc[i] = (float)Math.min(1.0, (double)(desc[i] / max_bin_val));
            ++i;
        }
        return desc;
    }

    protected final void processCandidate(float[] c, int o, List<Feature> features) {
        int ORIENTATION_BINS = 36;
        float ORIENTATION_BIN_SIZE = 0.17453294f;
        float[] histogram_bins = new float[36];
        int scale = (int)Math.pow(2.0, o);
        FloatArray2DScaleOctave octave = this.octaves[o];
        float octave_sigma = octave.SIGMA[0] * (float)Math.pow(2.0, c[2] / (float)octave.STEPS);
        FloatArray2D gaussianMask = Filter.createGaussianKernelOffset(octave_sigma * 1.5f, c[0] - (float)Math.floor(c[0]), c[1] - (float)Math.floor(c[1]), false);
        FloatArray2D[] src = octave.getL1(Math.round(c[2]));
        FloatArray2D[] gradientROI = new FloatArray2D[]{new FloatArray2D(gaussianMask.width, gaussianMask.width), new FloatArray2D(gaussianMask.width, gaussianMask.width)};
        int half_size = gaussianMask.width / 2;
        int n = gaussianMask.width * gaussianMask.width - 1;
        int yi = gaussianMask.width - 1;
        while (yi >= 0) {
            int ra_y = src[0].width * Math.max(0, Math.min(src[0].height - 1, (int)c[1] + yi - half_size));
            int ra_x = ra_y + Math.min((int)c[0], src[0].width - 1);
            int xi = gaussianMask.width - 1;
            while (xi >= 0) {
                int pt = Math.max(ra_y, Math.min(ra_y + src[0].width - 2, ra_x + xi - half_size));
                gradientROI[0].data[n] = src[0].data[pt];
                gradientROI[1].data[n] = src[1].data[pt];
                --n;
                --xi;
            }
            --yi;
        }
        int i = 0;
        while (i < gradientROI[0].data.length) {
            int n2 = i;
            gradientROI[0].data[n2] = gradientROI[0].data[n2] * gaussianMask.data[i];
            ++i;
        }
        i = 0;
        while (i < gradientROI[0].data.length) {
            int bin;
            int n3 = bin = Math.max(0, (int)(((double)gradientROI[1].data[i] + Math.PI) / 0.1745329350233078));
            histogram_bins[n3] = histogram_bins[n3] + gradientROI[0].data[i];
            ++i;
        }
        int max_i = 0;
        int i2 = 0;
        while (i2 < 36) {
            if (histogram_bins[i2] > histogram_bins[max_i]) {
                max_i = i2;
            }
            ++i2;
        }
        float e0 = histogram_bins[(max_i + 36 - 1) % 36];
        float e1 = histogram_bins[max_i];
        float e2 = histogram_bins[(max_i + 1) % 36];
        float offset = (e0 - e2) / 2.0f / (e0 - 2.0f * e1 + e2);
        float orientation = ((float)max_i + offset) * 0.17453294f - (float)Math.PI;
        features.add(new Feature(octave_sigma * (float)scale, orientation, new float[]{c[0] * (float)scale, c[1] * (float)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        int i3 = 0;
        while (i3 < 36) {
            if (i3 != max_i && (max_i + 1) % 36 != i3 && (max_i - 1 + 36) % 36 != i3 && (double)histogram_bins[i3] > 0.8 * (double)histogram_bins[max_i]) {
                e0 = histogram_bins[(i3 + 36 - 1) % 36];
                e1 = histogram_bins[i3];
                e2 = histogram_bins[(i3 + 1) % 36];
                if (e0 < e1 && e2 < e1) {
                    offset = (e0 - e2) / 2.0f / (e0 - 2.0f * e1 + e2);
                    orientation = ((float)i3 + 0.5f + offset) * 0.17453294f - (float)Math.PI;
                    features.add(new Feature(octave_sigma * (float)scale, orientation, new float[]{c[0] * (float)scale, c[1] * (float)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
                }
            }
            ++i3;
        }
    }

    private final Vector<Feature> runOctave(int o) {
        Vector<Feature> features = new Vector<Feature>();
        FloatArray2DScaleOctave octave = this.octaves[o];
        octave.build();
        this.dog.run(octave);
        Vector<float[]> candidates = this.dog.getCandidates();
        for (float[] c : candidates) {
            this.processCandidate(c, o, features);
        }
        return features;
    }

    public Vector<Feature> run() {
        Vector<Feature> features = new Vector<Feature>();
        int o = 0;
        while (o < this.octaves.length) {
            if (this.octaves[o].state != FloatArray2DScaleOctave.State.EMPTY) {
                Vector<Feature> more = this.runOctave(o);
                features.addAll(more);
            }
            ++o;
        }
        return features;
    }

    public Vector<Feature> run(int max_size) {
        Vector<Feature> features = new Vector<Feature>();
        int o = 0;
        while (o < this.octaves.length) {
            if (this.octaves[o].width <= max_size && this.octaves[o].height <= max_size) {
                Vector<Feature> more = this.runOctave(o);
                features.addAll(more);
            }
            ++o;
        }
        return features;
    }

    public static Vector<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float rod) {
        Vector<PointMatch> matches = new Vector<PointMatch>();
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            for (Feature f2 : fs2) {
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.addElement(new PointMatch(new Point(new float[]{f1.location[0], f1.location[1]}), new Point(new float[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0f));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.removeElementAt(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.removeElementAt(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    public static Vector<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float max_sd, AbstractModel<?> model, float max_id, float rod) {
        Vector<PointMatch> matches = new Vector<PointMatch>();
        float min_sd = 1.0f / max_sd;
        int size = fs2.size();
        int size_1 = size - 1;
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            int first = 0;
            int last = size_1;
            int s = size / 2 + size % 2;
            if (max_sd < Float.MAX_VALUE) {
                while (s > 1) {
                    Feature f2 = fs2.get(last);
                    last = f2.scale / f1.scale < min_sd ? Math.max(0, last - s) : Math.min(size_1, last + s);
                    f2 = fs2.get(first);
                    first = f2.scale / f1.scale < max_sd ? Math.max(0, first - s) : Math.min(size_1, first + s);
                    s = s / 2 + s % 2;
                }
            }
            int i = first;
            while (i <= last) {
                Feature f2 = fs2.get(i);
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                } else if (d < second_best_d) {
                    second_best_d = d;
                }
                ++i;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.addElement(new PointMatch(new Point(new float[]{f1.location[0], f1.location[1]}), new Point(new float[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0f));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.removeElementAt(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.removeElementAt(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    @Override
    public final void extractFeatures(Collection<Feature> features) {
        features.addAll(this.run(((Param)this.p).maxOctaveSize));
    }

    public static float[] featureSizeHistogram(Vector<Feature> features, float min, float max, int bins) {
        System.out.print("estimating feature size histogram ...");
        int num_features = features.size();
        float[] h = new float[bins];
        int[] hb = new int[bins];
        for (Feature f : features) {
            int bin;
            int n = bin = Math.max(0, Math.min(bins - 1, (int)(Math.log(f.scale) / Math.log(2.0) * 28.0)));
            hb[n] = hb[n] + 1;
        }
        int i = 0;
        while (i < bins) {
            h[i] = (float)hb[i] / (float)num_features;
            ++i;
        }
        System.out.println(" done");
        return h;
    }

    public final float getInitialSigma() {
        return ((Param)this.p).initialSigma;
    }

    public final void setInitialSigma(float initialSigma) {
        ((Param)this.p).initialSigma = initialSigma;
        this.sigma = new float[((Param)this.p).steps + 3];
        this.sigma[0] = ((Param)this.p).initialSigma;
        this.sigma_diff = new float[((Param)this.p).steps + 3];
        this.sigma_diff[0] = 0.0f;
        this.kernel_diff = new float[((Param)this.p).steps + 3][];
        int i = 1;
        while (i < ((Param)this.p).steps + 3) {
            this.sigma[i] = ((Param)this.p).initialSigma * (float)Math.pow(2.0, (float)i / (float)((Param)this.p).steps);
            this.sigma_diff[i] = (float)Math.sqrt(this.sigma[i] * this.sigma[i] - ((Param)this.p).initialSigma * ((Param)this.p).initialSigma);
            this.kernel_diff[i] = Filter.createGaussianKernel(this.sigma_diff[i], true);
            ++i;
        }
    }

    public final int getMaxOctaveSize() {
        return ((Param)this.p).maxOctaveSize;
    }

    public static final class Param
    implements Serializable {
        private static final long serialVersionUID = -5989002253597993595L;
        public int fdSize = 4;
        public int fdBins = 8;
        public int maxOctaveSize = 1024;
        public int minOctaveSize = 64;
        public int steps = 3;
        public float initialSigma = 1.6f;

        public boolean equals(Param p) {
            return this.fdSize == p.fdSize && this.fdBins == p.fdBins && this.maxOctaveSize == p.maxOctaveSize && this.minOctaveSize == p.minOctaveSize && this.steps == p.steps && this.initialSigma == p.initialSigma;
        }

        public boolean equals(Object p) {
            if (this.getClass().isInstance(p)) {
                return this.equals((Param)p);
            }
            return false;
        }

        public Param clone() {
            Param s = new Param();
            s.fdBins = this.fdBins;
            s.fdSize = this.fdSize;
            s.initialSigma = this.initialSigma;
            s.maxOctaveSize = this.maxOctaveSize;
            s.minOctaveSize = this.minOctaveSize;
            s.steps = this.steps;
            return s;
        }

        public void set(Param p) {
            this.fdBins = p.fdBins;
            this.fdSize = p.fdSize;
            this.initialSigma = p.initialSigma;
            this.maxOctaveSize = p.maxOctaveSize;
            this.minOctaveSize = p.minOctaveSize;
            this.steps = p.steps;
        }
    }
}

