/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.Filter;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DFeatureTransform;
import mpicbg.imagefeatures.FloatArray2DScaleOctave;
import mpicbg.imagefeatures.FloatArray2DScaleOctaveDoGDetector;
import mpicbg.models.AbstractModel;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.util.Util;

public class FloatArray2DMOPS
extends FloatArray2DFeatureTransform<Param> {
    private float[] sigma;
    private float[] sigma_diff;
    private float[][] kernel_diff;
    final int O_SCALE = 4;
    final int O_SCALE_LD2 = 2;
    private FloatArray2DScaleOctave[] octaves = null;
    private FloatArray2DScaleOctaveDoGDetector dog = new FloatArray2DScaleOctaveDoGDetector();
    public FloatArray2D pattern;

    public long getFeatureObjectSize() {
        return FloatArray2DMOPS.getFeatureObjectSize(((Param)this.p).fdSize);
    }

    public static long getFeatureObjectSize(int fdsize) {
        return fdsize * fdsize * 4 + 32 + 32;
    }

    public FloatArray2DScaleOctave[] getOctaves() {
        return this.octaves;
    }

    public FloatArray2DScaleOctave getOctave(int i) {
        return this.octaves[i];
    }

    public FloatArray2DMOPS(Param p) {
        super(p);
        this.sigma = new float[p.steps + 3];
        this.sigma[0] = p.initialSigma;
        this.sigma_diff = new float[p.steps + 3];
        this.sigma_diff[0] = 0.0f;
        this.kernel_diff = new float[p.steps + 3][];
        int i = 1;
        while (i < p.steps + 3) {
            this.sigma[i] = p.initialSigma * (float)Math.pow(2.0, (float)i / (float)p.steps);
            this.sigma_diff[i] = (float)Math.sqrt(this.sigma[i] * this.sigma[i] - p.initialSigma * p.initialSigma);
            this.kernel_diff[i] = Filter.createGaussianKernel(this.sigma_diff[i], true);
            ++i;
        }
    }

    @Override
    public void init(FloatArray2D src) {
        int o = 0;
        float w = src.width;
        float h = src.height;
        int minOctaveSize = ((Param)this.p).minOctaveSize / 4;
        int max_kernel_size = this.kernel_diff[((Param)this.p).steps + 2].length;
        while (w > (float)Math.max(max_kernel_size, minOctaveSize - 1) && h > (float)Math.max(max_kernel_size, minOctaveSize - 1)) {
            w /= 2.0f;
            h /= 2.0f;
            ++o;
        }
        this.octaves = new FloatArray2DScaleOctave[o];
        int i = 0;
        while (i < this.octaves.length) {
            this.octaves[i] = new FloatArray2DScaleOctave(src, this.sigma, this.sigma_diff, this.kernel_diff);
            this.octaves[i].buildStub();
            FloatArray2D next = new FloatArray2D(src.width / 2 + src.width % 2, src.height / 2 + src.height % 2);
            FloatArray2DScaleOctave.downsample(this.octaves[i].getL(1), next);
            if (src.width > ((Param)this.p).maxOctaveSize || src.height > ((Param)this.p).maxOctaveSize) {
                this.octaves[i].clear();
            }
            src = next;
            ++i;
        }
    }

    private float[] createDescriptor(float[] c, int o, float octave_sigma, float orientation) {
        FloatArray2DScaleOctave octave = this.octaves[o + 2];
        FloatArray2D l = octave.getL(Math.round(c[2]));
        float[] desc = new float[((Param)this.p).fdSize * ((Param)this.p).fdSize];
        float cos_o = (float)Math.cos(orientation);
        float sin_o = (float)Math.sin(orientation);
        int i = 0;
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        int y = ((Param)this.p).fdSize - 1;
        while (y >= 0) {
            float ys = ((float)y - (float)((Param)this.p).fdSize / 2.0f + 0.5f) * octave_sigma;
            int x = ((Param)this.p).fdSize - 1;
            while (x >= 0) {
                float xs = ((float)x - (float)((Param)this.p).fdSize / 2.0f + 0.5f) * octave_sigma;
                float yr = cos_o * ys + sin_o * xs;
                float xr = cos_o * xs - sin_o * ys;
                int yg = Util.pingPong(Math.round(yr + c[1] / 4.0f), l.height);
                int xg = Util.pingPong(Math.round(xr + c[0] / 4.0f), l.width);
                desc[i] = l.get(xg, yg);
                if (desc[i] > max) {
                    max = desc[i];
                } else if (desc[i] < min) {
                    min = desc[i];
                }
                ++i;
                --x;
            }
            --y;
        }
        float n = max - min;
        i = 0;
        while (i < desc.length) {
            desc[i] = (desc[i] - min) / n;
            ++i;
        }
        return desc;
    }

    void processCandidate(float[] c, int o, List<Feature> features) {
        int ORIENTATION_BINS = 36;
        float ORIENTATION_BIN_SIZE = 0.17453294f;
        float[] histogram_bins = new float[36];
        int scale = (int)Math.pow(2.0, o);
        FloatArray2DScaleOctave octave = this.octaves[o];
        float octave_sigma = octave.SIGMA[0] * (float)Math.pow(2.0, c[2] / (float)octave.STEPS);
        FloatArray2D gaussianMask = Filter.createGaussianKernelOffset(octave_sigma * 1.5f, c[0] - (float)Math.floor(c[0]), c[1] - (float)Math.floor(c[1]), false);
        FloatArray2D[] src = octave.getL1(Math.round(c[2]));
        FloatArray2D[] gradientROI = new FloatArray2D[]{new FloatArray2D(gaussianMask.width, gaussianMask.width), new FloatArray2D(gaussianMask.width, gaussianMask.width)};
        int half_size = gaussianMask.width / 2;
        int n = gaussianMask.width * gaussianMask.width - 1;
        int yi = gaussianMask.width - 1;
        while (yi >= 0) {
            int ra_y = src[0].width * Math.max(0, Math.min(src[0].height - 1, (int)c[1] + yi - half_size));
            int ra_x = ra_y + Math.min((int)c[0], src[0].width - 1);
            int xi = gaussianMask.width - 1;
            while (xi >= 0) {
                int pt = Math.max(ra_y, Math.min(ra_y + src[0].width - 2, ra_x + xi - half_size));
                gradientROI[0].data[n] = src[0].data[pt];
                gradientROI[1].data[n] = src[1].data[pt];
                --n;
                --xi;
            }
            --yi;
        }
        int i = 0;
        while (i < gradientROI[0].data.length) {
            int n2 = i;
            gradientROI[0].data[n2] = gradientROI[0].data[n2] * gaussianMask.data[i];
            ++i;
        }
        i = 0;
        while (i < gradientROI[0].data.length) {
            int bin;
            int n3 = bin = Math.max(0, (int)(((double)gradientROI[1].data[i] + Math.PI) / 0.1745329350233078));
            histogram_bins[n3] = histogram_bins[n3] + gradientROI[0].data[i];
            ++i;
        }
        int max_i = 0;
        int i2 = 0;
        while (i2 < 36) {
            if (histogram_bins[i2] > histogram_bins[max_i]) {
                max_i = i2;
            }
            ++i2;
        }
        float e0 = histogram_bins[(max_i + 36 - 1) % 36];
        float e1 = histogram_bins[max_i];
        float e2 = histogram_bins[(max_i + 1) % 36];
        float offset = (e0 - e2) / 2.0f / (e0 - 2.0f * e1 + e2);
        float orientation = ((float)max_i + offset) * 0.17453294f - (float)Math.PI;
        features.add(new Feature(octave_sigma * (float)scale, orientation, new float[]{c[0] * (float)scale, c[1] * (float)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        int i3 = 0;
        while (i3 < 36) {
            if (i3 != max_i && (max_i + 1) % 36 != i3 && (max_i - 1 + 36) % 36 != i3 && (double)histogram_bins[i3] > 0.8 * (double)histogram_bins[max_i]) {
                e0 = histogram_bins[(i3 + 36 - 1) % 36];
                e1 = histogram_bins[i3];
                e2 = histogram_bins[(i3 + 1) % 36];
                if (e0 < e1 && e2 < e1) {
                    offset = (e0 - e2) / 2.0f / (e0 - 2.0f * e1 + e2);
                    orientation = ((float)i3 + 0.5f + offset) * 0.17453294f - (float)Math.PI;
                    features.add(new Feature(octave_sigma * (float)scale, orientation, new float[]{c[0] * (float)scale, c[1] * (float)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
                }
            }
            ++i3;
        }
    }

    public List<Feature> runOctave(int o) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        FloatArray2DScaleOctave octave = this.octaves[o];
        octave.build();
        this.dog.run(octave);
        Vector<float[]> candidates = this.dog.getCandidates();
        for (float[] c : candidates) {
            this.processCandidate(c, o, features);
        }
        return features;
    }

    public List<Feature> run() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        int o = 0;
        while (o < this.octaves.length) {
            if (this.octaves[o].state != FloatArray2DScaleOctave.State.EMPTY) {
                this.octaves[o].build();
            }
            ++o;
        }
        o = 0;
        while (o < this.octaves.length - 2) {
            if (this.octaves[o].state != FloatArray2DScaleOctave.State.EMPTY) {
                List<Feature> more = this.runOctave(o);
                features.addAll(more);
            }
            ++o;
        }
        return features;
    }

    public List<Feature> run(int max_size) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        int o = 0;
        while (o < this.octaves.length) {
            if (this.octaves[o].width <= max_size && this.octaves[o].height <= max_size) {
                this.octaves[o].build();
            }
            ++o;
        }
        o = 0;
        while (o < this.octaves.length - 2) {
            if (this.octaves[o].width <= max_size && this.octaves[o].height <= max_size) {
                List<Feature> more = this.runOctave(o);
                features.addAll(more);
            }
            ++o;
        }
        return features;
    }

    public static List<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float rod) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            for (Feature f2 : fs2) {
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.add(new PointMatch(new Point(new float[]{f1.location[0], f1.location[1]}), new Point(new float[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0f));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = (PointMatch)matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = (PointMatch)matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    public static List<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float rod, HashMap<Point, Feature> m1, HashMap<Point, Feature> m2) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            for (Feature f2 : fs2) {
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            Point p1 = new Point(new float[]{f1.location[0], f1.location[1]});
            Point p2 = new Point(new float[]{best.location[0], best.location[1]});
            matches.add(new PointMatch(p1, p2, (f1.scale + best.scale) / 2.0f));
            m1.put(p1, f1);
            m2.put(p2, best);
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = (PointMatch)matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = (PointMatch)matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    m1.remove(n.getP1());
                    m2.remove(n.getP2());
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                m1.remove(m.getP1());
                m2.remove(m.getP2());
                continue;
            }
            ++i;
        }
        return matches;
    }

    public static List<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float max_sd, AbstractModel<?> model, float max_id, float rod) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        float min_sd = 1.0f / max_sd;
        int size = fs2.size();
        int size_1 = size - 1;
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            int first = 0;
            int last = size_1;
            int s = size / 2 + size % 2;
            if (max_sd < Float.MAX_VALUE) {
                while (s > 1) {
                    Feature f2 = fs2.get(last);
                    last = f2.scale / f1.scale < min_sd ? Math.max(0, last - s) : Math.min(size_1, last + s);
                    f2 = fs2.get(first);
                    first = f2.scale / f1.scale < max_sd ? Math.max(0, first - s) : Math.min(size_1, first + s);
                    s = s / 2 + s % 2;
                }
            }
            int i = first;
            while (i <= last) {
                Feature f2 = fs2.get(i);
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                } else if (d < second_best_d) {
                    second_best_d = d;
                }
                ++i;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.add(new PointMatch(new Point(new float[]{f1.location[0], f1.location[1]}), new Point(new float[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0f));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = (PointMatch)matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = (PointMatch)matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    @Override
    public final void extractFeatures(Collection<Feature> features) {
        features.addAll(this.run(((Param)this.p).maxOctaveSize));
    }

    public static float[] featureSizeHistogram(List<Feature> features, float min, float max, int bins) {
        System.out.print("estimating feature size histogram ...");
        int num_features = features.size();
        float[] h = new float[bins];
        int[] hb = new int[bins];
        for (Feature f : features) {
            int bin;
            int n = bin = Math.max(0, Math.min(bins - 1, (int)(Math.log(f.scale) / Math.log(2.0) * 28.0)));
            hb[n] = hb[n] + 1;
        }
        int i = 0;
        while (i < bins) {
            h[i] = (float)hb[i] / (float)num_features;
            ++i;
        }
        System.out.println(" done");
        return h;
    }

    public final float getInitialSigma() {
        return ((Param)this.p).initialSigma;
    }

    public final void setInitialSigma(float initialSigma) {
        ((Param)this.p).initialSigma = initialSigma;
        this.sigma = new float[((Param)this.p).steps + 3];
        this.sigma[0] = ((Param)this.p).initialSigma;
        this.sigma_diff = new float[((Param)this.p).steps + 3];
        this.sigma_diff[0] = 0.0f;
        this.kernel_diff = new float[((Param)this.p).steps + 3][];
        int i = 1;
        while (i < ((Param)this.p).steps + 3) {
            this.sigma[i] = ((Param)this.p).initialSigma * (float)Math.pow(2.0, (float)i / (float)((Param)this.p).steps);
            this.sigma_diff[i] = (float)Math.sqrt(this.sigma[i] * this.sigma[i] - ((Param)this.p).initialSigma * ((Param)this.p).initialSigma);
            this.kernel_diff[i] = Filter.createGaussianKernel(this.sigma_diff[i], true);
            ++i;
        }
    }

    public final int getMaxOctaveSize() {
        return ((Param)this.p).maxOctaveSize;
    }

    public static final class Param {
        public int fdSize = 16;
        public int maxOctaveSize = 1024;
        public int minOctaveSize = 64;
        public int steps = 3;
        public float initialSigma = 1.6f;
    }
}

